/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind.introspect;

import com.huawei.shade.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.huawei.shade.com.fasterxml.jackson.annotation.PropertyAccessor;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public interface VisibilityChecker<T extends VisibilityChecker<T>> {
    public T with(JsonAutoDetect var1);

    public T with(JsonAutoDetect.Visibility var1);

    public T withVisibility(PropertyAccessor var1, JsonAutoDetect.Visibility var2);

    public T withGetterVisibility(JsonAutoDetect.Visibility var1);

    public T withIsGetterVisibility(JsonAutoDetect.Visibility var1);

    public T withSetterVisibility(JsonAutoDetect.Visibility var1);

    public T withCreatorVisibility(JsonAutoDetect.Visibility var1);

    public T withFieldVisibility(JsonAutoDetect.Visibility var1);

    public boolean isGetterVisible(Method var1);

    public boolean isGetterVisible(AnnotatedMethod var1);

    public boolean isIsGetterVisible(Method var1);

    public boolean isIsGetterVisible(AnnotatedMethod var1);

    public boolean isSetterVisible(Method var1);

    public boolean isSetterVisible(AnnotatedMethod var1);

    public boolean isCreatorVisible(Member var1);

    public boolean isCreatorVisible(AnnotatedMember var1);

    public boolean isFieldVisible(Field var1);

    public boolean isFieldVisible(AnnotatedField var1);

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, isGetterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
    public static class Std
    implements VisibilityChecker<Std>,
    Serializable {
        private static final long serialVersionUID = -7073939237187922755L;
        protected static final Std DEFAULT = new Std(Std.class.getAnnotation(JsonAutoDetect.class));
        protected final JsonAutoDetect.Visibility _getterMinLevel;
        protected final JsonAutoDetect.Visibility _isGetterMinLevel;
        protected final JsonAutoDetect.Visibility _setterMinLevel;
        protected final JsonAutoDetect.Visibility _creatorMinLevel;
        protected final JsonAutoDetect.Visibility _fieldMinLevel;

        public static Std defaultInstance() {
            return DEFAULT;
        }

        public Std(JsonAutoDetect jsonAutoDetect) {
            this._getterMinLevel = jsonAutoDetect.getterVisibility();
            this._isGetterMinLevel = jsonAutoDetect.isGetterVisibility();
            this._setterMinLevel = jsonAutoDetect.setterVisibility();
            this._creatorMinLevel = jsonAutoDetect.creatorVisibility();
            this._fieldMinLevel = jsonAutoDetect.fieldVisibility();
        }

        public Std(JsonAutoDetect.Visibility visibility, JsonAutoDetect.Visibility visibility2, JsonAutoDetect.Visibility visibility3, JsonAutoDetect.Visibility visibility4, JsonAutoDetect.Visibility visibility5) {
            this._getterMinLevel = visibility;
            this._isGetterMinLevel = visibility2;
            this._setterMinLevel = visibility3;
            this._creatorMinLevel = visibility4;
            this._fieldMinLevel = visibility5;
        }

        public Std(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                this._getterMinLevel = Std.DEFAULT._getterMinLevel;
                this._isGetterMinLevel = Std.DEFAULT._isGetterMinLevel;
                this._setterMinLevel = Std.DEFAULT._setterMinLevel;
                this._creatorMinLevel = Std.DEFAULT._creatorMinLevel;
                this._fieldMinLevel = Std.DEFAULT._fieldMinLevel;
            } else {
                this._getterMinLevel = visibility;
                this._isGetterMinLevel = visibility;
                this._setterMinLevel = visibility;
                this._creatorMinLevel = visibility;
                this._fieldMinLevel = visibility;
            }
        }

        @Override
        public Std with(JsonAutoDetect jsonAutoDetect) {
            Std std = this;
            if (jsonAutoDetect != null) {
                std = std.withGetterVisibility(jsonAutoDetect.getterVisibility());
                std = std.withIsGetterVisibility(jsonAutoDetect.isGetterVisibility());
                std = std.withSetterVisibility(jsonAutoDetect.setterVisibility());
                std = std.withCreatorVisibility(jsonAutoDetect.creatorVisibility());
                std = std.withFieldVisibility(jsonAutoDetect.fieldVisibility());
            }
            return std;
        }

        @Override
        public Std with(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                return DEFAULT;
            }
            return new Std(visibility);
        }

        @Override
        public Std withVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
            switch (propertyAccessor) {
                case GETTER: {
                    return this.withGetterVisibility(visibility);
                }
                case SETTER: {
                    return this.withSetterVisibility(visibility);
                }
                case CREATOR: {
                    return this.withCreatorVisibility(visibility);
                }
                case FIELD: {
                    return this.withFieldVisibility(visibility);
                }
                case IS_GETTER: {
                    return this.withIsGetterVisibility(visibility);
                }
                case ALL: {
                    return this.with(visibility);
                }
            }
            return this;
        }

        @Override
        public Std withGetterVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._getterMinLevel;
            }
            if (this._getterMinLevel == visibility) {
                return this;
            }
            return new Std(visibility, this._isGetterMinLevel, this._setterMinLevel, this._creatorMinLevel, this._fieldMinLevel);
        }

        @Override
        public Std withIsGetterVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._isGetterMinLevel;
            }
            if (this._isGetterMinLevel == visibility) {
                return this;
            }
            return new Std(this._getterMinLevel, visibility, this._setterMinLevel, this._creatorMinLevel, this._fieldMinLevel);
        }

        @Override
        public Std withSetterVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._setterMinLevel;
            }
            if (this._setterMinLevel == visibility) {
                return this;
            }
            return new Std(this._getterMinLevel, this._isGetterMinLevel, visibility, this._creatorMinLevel, this._fieldMinLevel);
        }

        @Override
        public Std withCreatorVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._creatorMinLevel;
            }
            if (this._creatorMinLevel == visibility) {
                return this;
            }
            return new Std(this._getterMinLevel, this._isGetterMinLevel, this._setterMinLevel, visibility, this._fieldMinLevel);
        }

        @Override
        public Std withFieldVisibility(JsonAutoDetect.Visibility visibility) {
            if (visibility == JsonAutoDetect.Visibility.DEFAULT) {
                visibility = Std.DEFAULT._fieldMinLevel;
            }
            if (this._fieldMinLevel == visibility) {
                return this;
            }
            return new Std(this._getterMinLevel, this._isGetterMinLevel, this._setterMinLevel, this._creatorMinLevel, visibility);
        }

        @Override
        public boolean isCreatorVisible(Member member) {
            return this._creatorMinLevel.isVisible(member);
        }

        @Override
        public boolean isCreatorVisible(AnnotatedMember annotatedMember) {
            return this.isCreatorVisible(annotatedMember.getMember());
        }

        @Override
        public boolean isFieldVisible(Field field) {
            return this._fieldMinLevel.isVisible(field);
        }

        @Override
        public boolean isFieldVisible(AnnotatedField annotatedField) {
            return this.isFieldVisible(annotatedField.getAnnotated());
        }

        @Override
        public boolean isGetterVisible(Method method) {
            return this._getterMinLevel.isVisible(method);
        }

        @Override
        public boolean isGetterVisible(AnnotatedMethod annotatedMethod) {
            return this.isGetterVisible(annotatedMethod.getAnnotated());
        }

        @Override
        public boolean isIsGetterVisible(Method method) {
            return this._isGetterMinLevel.isVisible(method);
        }

        @Override
        public boolean isIsGetterVisible(AnnotatedMethod annotatedMethod) {
            return this.isIsGetterVisible(annotatedMethod.getAnnotated());
        }

        @Override
        public boolean isSetterVisible(Method method) {
            return this._setterMinLevel.isVisible(method);
        }

        @Override
        public boolean isSetterVisible(AnnotatedMethod annotatedMethod) {
            return this.isSetterVisible(annotatedMethod.getAnnotated());
        }

        public String toString() {
            return "[Visibility:" + " getter: " + (Object)((Object)this._getterMinLevel) + ", isGetter: " + (Object)((Object)this._isGetterMinLevel) + ", setter: " + (Object)((Object)this._setterMinLevel) + ", creator: " + (Object)((Object)this._creatorMinLevel) + ", field: " + (Object)((Object)this._fieldMinLevel) + "]";
        }
    }
}

