/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind.ser;

import com.huawei.shade.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.huawei.shade.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.huawei.shade.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.huawei.shade.com.fasterxml.jackson.databind.BeanDescription;
import com.huawei.shade.com.fasterxml.jackson.databind.BeanProperty;
import com.huawei.shade.com.fasterxml.jackson.databind.JavaType;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonMappingException;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.MapperFeature;
import com.huawei.shade.com.fasterxml.jackson.databind.SerializationConfig;
import com.huawei.shade.com.fasterxml.jackson.databind.SerializerProvider;
import com.huawei.shade.com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.huawei.shade.com.fasterxml.jackson.databind.jsontype.NamedType;
import com.huawei.shade.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.huawei.shade.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.BasicSerializerFactory;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.PropertyBuilder;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.Serializers;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.impl.FilteredBeanPropertyWriter;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.type.TypeBindings;
import com.huawei.shade.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.huawei.shade.com.fasterxml.jackson.databind.util.ClassUtil;
import com.huawei.shade.com.fasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BeanSerializerFactory
extends BasicSerializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BeanSerializerFactory instance = new BeanSerializerFactory(null);

    protected BeanSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        super(serializerFactoryConfig);
    }

    @Override
    public SerializerFactory withConfig(SerializerFactoryConfig serializerFactoryConfig) {
        if (this._factoryConfig == serializerFactoryConfig) {
            return this;
        }
        if (this.getClass() != BeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': can not instantiate subtype with " + "additional serializer definitions");
        }
        return new BeanSerializerFactory(serializerFactoryConfig);
    }

    @Override
    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    @Override
    public JsonSerializer<Object> createSerializer(SerializerProvider serializerProvider, JavaType javaType) throws JsonMappingException {
        boolean bl;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        Object t = serializationConfig.introspect(javaType);
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, ((BeanDescription)t).getClassInfo());
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        JavaType javaType2 = this.modifyTypeByAnnotation(serializationConfig, ((BeanDescription)t).getClassInfo(), javaType);
        if (javaType2 == javaType) {
            bl = false;
        } else {
            bl = true;
            if (!javaType2.hasRawClass(javaType.getRawClass())) {
                t = serializationConfig.introspect(javaType2);
            }
        }
        Converter<Object, Object> converter = ((BeanDescription)t).findSerializationConverter();
        if (converter == null) {
            return this._createSerializer2(serializerProvider, javaType2, (BeanDescription)t, bl);
        }
        JavaType javaType3 = converter.getOutputType(serializerProvider.getTypeFactory());
        if (!javaType3.hasRawClass(javaType2.getRawClass())) {
            t = serializationConfig.introspect(javaType3);
        }
        return new StdDelegatingSerializer(converter, javaType3, this._createSerializer2(serializerProvider, javaType3, (BeanDescription)t, true));
    }

    protected JsonSerializer<?> _createSerializer2(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this.findSerializerByAnnotations(serializerProvider, javaType, beanDescription);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        if (javaType.isContainerType()) {
            if (!bl) {
                bl = this.usesStaticTyping(serializationConfig, beanDescription, null);
            }
            if ((jsonSerializer = this.buildContainerSerializer(serializerProvider, javaType, beanDescription, bl)) != null) {
                return jsonSerializer;
            }
        } else {
            Serializers object;
            Iterator<Object> iterator = this.customSerializers().iterator();
            while (iterator.hasNext() && (jsonSerializer = (object = iterator.next()).findSerializer(serializationConfig, javaType, beanDescription)) == null) {
            }
        }
        if (jsonSerializer == null && (jsonSerializer = this.findSerializerByLookup(javaType, serializationConfig, beanDescription, bl)) == null && (jsonSerializer = this.findSerializerByPrimaryType(serializerProvider, javaType, beanDescription, bl)) == null && (jsonSerializer = this.findBeanSerializer(serializerProvider, javaType, beanDescription)) == null) {
            jsonSerializer = this.findSerializerByAddonType(serializationConfig, javaType, beanDescription, bl);
        }
        if (jsonSerializer != null && this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer = beanSerializerModifier.modifySerializer(serializationConfig, beanDescription, jsonSerializer);
            }
        }
        return jsonSerializer;
    }

    @Deprecated
    public final JsonSerializer<Object> findBeanSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, BeanProperty beanProperty) throws JsonMappingException {
        return this.findBeanSerializer(serializerProvider, javaType, beanDescription);
    }

    public JsonSerializer<Object> findBeanSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        if (!this.isPotentialBeanType(javaType.getRawClass()) && !javaType.isEnumType()) {
            return null;
        }
        return this.constructBeanSerializer(serializerProvider, beanDescription);
    }

    @Deprecated
    public final TypeSerializer findPropertyTypeSerializer(JavaType javaType, SerializationConfig serializationConfig, AnnotatedMember annotatedMember, BeanProperty beanProperty) throws JsonMappingException {
        return this.findPropertyTypeSerializer(javaType, serializationConfig, annotatedMember);
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType javaType, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyTypeResolver(serializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            return this.createTypeSerializer(serializationConfig, javaType);
        }
        Collection<NamedType> collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedMember, serializationConfig, annotationIntrospector, javaType);
        return typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType, collection);
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType javaType, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) throws JsonMappingException {
        JavaType javaType2 = javaType.getContentType();
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyContentTypeResolver(serializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            return this.createTypeSerializer(serializationConfig, javaType2);
        }
        Collection<NamedType> collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedMember, serializationConfig, annotationIntrospector, javaType2);
        return typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType2, collection);
    }

    @Deprecated
    protected final JsonSerializer<Object> constructBeanSerializer(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanProperty beanProperty) throws JsonMappingException {
        return this.constructBeanSerializer(serializerProvider, beanDescription);
    }

    protected JsonSerializer<Object> constructBeanSerializer(SerializerProvider serializerProvider, BeanDescription beanDescription) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer;
        if (beanDescription.getBeanClass() == Object.class) {
            return serializerProvider.getUnknownTypeSerializer(Object.class);
        }
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        BeanSerializerBuilder beanSerializerBuilder = this.constructBeanSerializerBuilder(beanDescription);
        beanSerializerBuilder.setConfig(serializationConfig);
        List<BeanPropertyWriter> list = this.findBeanProperties(serializerProvider, beanDescription, beanSerializerBuilder);
        if (list == null) {
            list = new ArrayList<BeanPropertyWriter>();
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier object2 : this._factoryConfig.serializerModifiers()) {
                list = object2.changeProperties(serializationConfig, beanDescription, list);
            }
        }
        list = this.filterBeanProperties(serializationConfig, beanDescription, list);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                list = beanSerializerModifier.orderProperties(serializationConfig, beanDescription, list);
            }
        }
        beanSerializerBuilder.setObjectIdWriter(this.constructObjectIdHandler(serializerProvider, beanDescription, list));
        beanSerializerBuilder.setProperties(list);
        beanSerializerBuilder.setFilterId(this.findFilterId(serializationConfig, beanDescription));
        AnnotatedMember annotatedMember = beanDescription.findAnyGetter();
        if (annotatedMember != null) {
            if (serializationConfig.canOverrideAccessModifiers()) {
                annotatedMember.fixAccess();
            }
            JavaType javaType = annotatedMember.getType(beanDescription.bindingsForBeanType());
            boolean bl = serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING);
            JavaType javaType2 = javaType.getContentType();
            TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
            MapSerializer mapSerializer = MapSerializer.construct(null, javaType, bl, typeSerializer, null, null);
            BeanProperty.Std std = new BeanProperty.Std(annotatedMember.getName(), javaType2, null, beanDescription.getClassAnnotations(), annotatedMember, false);
            beanSerializerBuilder.setAnyGetter(new AnyGetterWriter(std, annotatedMember, mapSerializer));
        }
        this.processViews(serializationConfig, beanSerializerBuilder);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                beanSerializerBuilder = beanSerializerModifier.updateBuilder(serializationConfig, beanDescription, beanSerializerBuilder);
            }
        }
        if ((jsonSerializer = beanSerializerBuilder.build()) == null && beanDescription.hasKnownClassAnnotations()) {
            return beanSerializerBuilder.createDummy();
        }
        return jsonSerializer;
    }

    protected ObjectIdWriter constructObjectIdHandler(SerializerProvider serializerProvider, BeanDescription beanDescription, List<BeanPropertyWriter> list) throws JsonMappingException {
        ObjectIdInfo objectIdInfo = beanDescription.getObjectIdInfo();
        if (objectIdInfo == null) {
            return null;
        }
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
            String string = objectIdInfo.getPropertyName();
            BeanPropertyWriter beanPropertyWriter = null;
            int n = 0;
            int n2 = list.size();
            while (true) {
                if (n == n2) {
                    throw new IllegalArgumentException("Invalid Object Id definition for " + beanDescription.getBeanClass().getName() + ": can not find property with name '" + string + "'");
                }
                BeanPropertyWriter beanPropertyWriter2 = list.get(n);
                if (string.equals(beanPropertyWriter2.getName())) {
                    beanPropertyWriter = beanPropertyWriter2;
                    if (n <= 0) break;
                    list.remove(n);
                    list.add(0, beanPropertyWriter);
                    break;
                }
                ++n;
            }
            JavaType javaType = beanPropertyWriter.getType();
            PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo, beanPropertyWriter);
            return ObjectIdWriter.construct(javaType, null, propertyBasedObjectIdGenerator, objectIdInfo.getAlwaysAsId());
        }
        JavaType javaType = serializerProvider.constructType(clazz);
        JavaType javaType2 = serializerProvider.getTypeFactory().findTypeParameters(javaType, ObjectIdGenerator.class)[0];
        ObjectIdGenerator<?> objectIdGenerator = serializerProvider.objectIdGeneratorInstance(beanDescription.getClassInfo(), objectIdInfo);
        return ObjectIdWriter.construct(javaType2, objectIdInfo.getPropertyName(), objectIdGenerator, objectIdInfo.getAlwaysAsId());
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
        return FilteredBeanPropertyWriter.constructViewBased(beanPropertyWriter, classArray);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return new PropertyBuilder(serializationConfig, beanDescription);
    }

    protected BeanSerializerBuilder constructBeanSerializerBuilder(BeanDescription beanDescription) {
        return new BeanSerializerBuilder(beanDescription);
    }

    protected Object findFilterId(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return serializationConfig.getAnnotationIntrospector().findFilterId(beanDescription.getClassInfo());
    }

    protected boolean isPotentialBeanType(Class<?> clazz) {
        return ClassUtil.canBeABeanType(clazz) == null && !ClassUtil.isProxyType(clazz);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanSerializerBuilder beanSerializerBuilder) throws JsonMappingException {
        List<BeanPropertyDefinition> list = beanDescription.findProperties();
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        this.removeIgnorableTypes(serializationConfig, beanDescription, list);
        if (serializationConfig.isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
            this.removeSetterlessGetters(serializationConfig, beanDescription, list);
        }
        if (list.isEmpty()) {
            return null;
        }
        boolean bl = this.usesStaticTyping(serializationConfig, beanDescription, null);
        PropertyBuilder propertyBuilder = this.constructPropertyBuilder(serializationConfig, beanDescription);
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(list.size());
        TypeBindings typeBindings = beanDescription.bindingsForBeanType();
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (beanPropertyDefinition.isTypeId()) {
                if (annotatedMember == null) continue;
                if (serializationConfig.canOverrideAccessModifiers()) {
                    annotatedMember.fixAccess();
                }
                beanSerializerBuilder.setTypeId(annotatedMember);
                continue;
            }
            AnnotationIntrospector.ReferenceProperty referenceProperty = beanPropertyDefinition.findReferenceType();
            if (referenceProperty != null && referenceProperty.isBackReference()) continue;
            if (annotatedMember instanceof AnnotatedMethod) {
                arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, typeBindings, propertyBuilder, bl, (AnnotatedMethod)annotatedMember));
                continue;
            }
            arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, typeBindings, propertyBuilder, bl, (AnnotatedField)annotatedMember));
        }
        return arrayList;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
        AnnotatedClass annotatedClass;
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        String[] stringArray = annotationIntrospector.findPropertiesToIgnore(annotatedClass = beanDescription.getClassInfo());
        if (stringArray != null && stringArray.length > 0) {
            HashSet<String> hashSet = ArrayBuilders.arrayToSet(stringArray);
            Iterator<BeanPropertyWriter> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!hashSet.contains(iterator.next().getName())) continue;
                iterator.remove();
            }
        }
        return list;
    }

    protected void processViews(SerializationConfig serializationConfig, BeanSerializerBuilder beanSerializerBuilder) {
        List<BeanPropertyWriter> list = beanSerializerBuilder.getProperties();
        boolean bl = serializationConfig.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        int n = list.size();
        int n2 = 0;
        BeanPropertyWriter[] beanPropertyWriterArray = new BeanPropertyWriter[n];
        for (int i = 0; i < n; ++i) {
            BeanPropertyWriter beanPropertyWriter = list.get(i);
            Class<?>[] classArray = beanPropertyWriter.getViews();
            if (classArray == null) {
                if (!bl) continue;
                beanPropertyWriterArray[i] = beanPropertyWriter;
                continue;
            }
            ++n2;
            beanPropertyWriterArray[i] = this.constructFilteredBeanWriter(beanPropertyWriter, classArray);
        }
        if (bl && n2 == 0) {
            return;
        }
        beanSerializerBuilder.setFilteredProperties(beanPropertyWriterArray);
    }

    protected void removeIgnorableTypes(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        HashMap hashMap = new HashMap();
        Iterator<BeanPropertyDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (annotatedMember == null) {
                iterator.remove();
                continue;
            }
            Class<?> clazz = annotatedMember.getRawType();
            Boolean bl = (Boolean)hashMap.get(clazz);
            if (bl == null) {
                BeanDescription beanDescription2 = serializationConfig.introspectClassAnnotations(clazz);
                AnnotatedClass annotatedClass = beanDescription2.getClassInfo();
                bl = annotationIntrospector.isIgnorableType(annotatedClass);
                if (bl == null) {
                    bl = Boolean.FALSE;
                }
                hashMap.put(clazz, bl);
            }
            if (!bl.booleanValue()) continue;
            iterator.remove();
        }
    }

    protected void removeSetterlessGetters(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list) {
        Iterator<BeanPropertyDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            if (beanPropertyDefinition.couldDeserialize() || beanPropertyDefinition.isExplicitlyIncluded()) continue;
            iterator.remove();
        }
    }

    protected BeanPropertyWriter _constructWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, TypeBindings typeBindings, PropertyBuilder propertyBuilder, boolean bl, AnnotatedMember annotatedMember) throws JsonMappingException {
        String string = beanPropertyDefinition.getName();
        if (serializerProvider.canOverrideAccessModifiers()) {
            annotatedMember.fixAccess();
        }
        JavaType javaType = annotatedMember.getType(typeBindings);
        BeanProperty.Std std = new BeanProperty.Std(string, javaType, beanPropertyDefinition.getWrapperName(), propertyBuilder.getClassAnnotations(), annotatedMember, beanPropertyDefinition.isRequired());
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMember);
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
        }
        if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(serializerProvider, std);
        }
        TypeSerializer typeSerializer = null;
        if (ClassUtil.isCollectionMapOrArray(javaType.getRawClass())) {
            typeSerializer = this.findPropertyContentTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        }
        TypeSerializer typeSerializer2 = this.findPropertyTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        BeanPropertyWriter beanPropertyWriter = propertyBuilder.buildWriter(beanPropertyDefinition, javaType, jsonSerializer, typeSerializer2, typeSerializer, annotatedMember, bl);
        return beanPropertyWriter;
    }
}

