/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind.ser.impl;

import com.huawei.shade.com.fasterxml.jackson.databind.JsonSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.SerializerCache;
import java.util.Map;

public class JsonSerializerMap {
    private final Bucket[] _buckets;
    private final int _size;

    public JsonSerializerMap(Map<SerializerCache.TypeKey, JsonSerializer<Object>> map) {
        int n;
        this._size = n = JsonSerializerMap.findSize(map.size());
        int n2 = n - 1;
        Bucket[] bucketArray = new Bucket[n];
        for (Map.Entry<SerializerCache.TypeKey, JsonSerializer<Object>> entry : map.entrySet()) {
            SerializerCache.TypeKey typeKey = entry.getKey();
            int n3 = typeKey.hashCode() & n2;
            bucketArray[n3] = new Bucket(bucketArray[n3], typeKey, entry.getValue());
        }
        this._buckets = bucketArray;
    }

    private static final int findSize(int n) {
        int n2;
        int n3 = n <= 64 ? n + n : n + (n >> 2);
        for (n2 = 8; n2 < n3; n2 += n2) {
        }
        return n2;
    }

    public int size() {
        return this._size;
    }

    public JsonSerializer<Object> find(SerializerCache.TypeKey typeKey) {
        int n = typeKey.hashCode() & this._buckets.length - 1;
        Bucket bucket = this._buckets[n];
        if (bucket == null) {
            return null;
        }
        if (typeKey.equals(bucket.key)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!typeKey.equals(bucket.key)) continue;
            return bucket.value;
        }
        return null;
    }

    private static final class Bucket {
        public final SerializerCache.TypeKey key;
        public final JsonSerializer<Object> value;
        public final Bucket next;

        public Bucket(Bucket bucket, SerializerCache.TypeKey typeKey, JsonSerializer<Object> jsonSerializer) {
            this.next = bucket;
            this.key = typeKey;
            this.value = jsonSerializer;
        }
    }
}

