/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind.ser.impl;

import com.huawei.shade.com.fasterxml.jackson.core.JsonGenerationException;
import com.huawei.shade.com.fasterxml.jackson.core.JsonGenerator;
import com.huawei.shade.com.fasterxml.jackson.databind.BeanProperty;
import com.huawei.shade.com.fasterxml.jackson.databind.JavaType;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonMappingException;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonNode;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.SerializerProvider;
import com.huawei.shade.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.huawei.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.huawei.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.huawei.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.huawei.shade.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.huawei.shade.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class StringArraySerializer
extends ArraySerializerBase<String[]>
implements ContextualSerializer {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final JsonSerializer<Object> _elementSerializer;

    protected StringArraySerializer() {
        super(String[].class, null);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer stringArraySerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) {
        super(stringArraySerializer, beanProperty);
        this._elementSerializer = jsonSerializer;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return this;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        JsonSerializer<Object> jsonSerializer = null;
        if (beanProperty != null && (annotatedMember = beanProperty.getMember()) != null && (object = serializerProvider.getAnnotationIntrospector().findContentSerializer(annotatedMember)) != null) {
            jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._elementSerializer;
        }
        if ((jsonSerializer = this.findConvertingContentSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            jsonSerializer = serializerProvider.findValueSerializer(String.class, beanProperty);
        } else if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(serializerProvider, beanProperty);
        }
        if (this.isDefaultSerializer(jsonSerializer)) {
            jsonSerializer = null;
        }
        if (jsonSerializer == this._elementSerializer) {
            return this;
        }
        return new StringArraySerializer(this, beanProperty, jsonSerializer);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(String[] stringArray) {
        return stringArray == null || stringArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(String[] stringArray) {
        return stringArray.length == 1;
    }

    @Override
    public void serializeContents(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n = stringArray.length;
        if (n == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsSlow(stringArray, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null) {
                jsonGenerator.writeNull();
                continue;
            }
            jsonGenerator.writeString(stringArray[i]);
        }
    }

    private void serializeContentsSlow(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            jsonSerializer.serialize(stringArray[i], jsonGenerator, serializerProvider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        ObjectNode objectNode = this.createSchemaNode("array", true);
        objectNode.put("items", this.createSchemaNode("string"));
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonArrayFormatVisitor jsonArrayFormatVisitor;
        if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
            jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.STRING);
        }
    }
}

