/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind.ser.std;

import com.huawei.shade.com.fasterxml.jackson.core.JsonGenerationException;
import com.huawei.shade.com.fasterxml.jackson.core.JsonGenerator;
import com.huawei.shade.com.fasterxml.jackson.databind.SerializerProvider;
import com.huawei.shade.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

@JacksonStdImpl
public class DateSerializer
extends DateTimeSerializerBase<Date> {
    public static final DateSerializer instance = new DateSerializer();

    public DateSerializer() {
        this(false, null);
    }

    public DateSerializer(boolean bl, DateFormat dateFormat) {
        super(Date.class, bl, dateFormat);
    }

    public DateSerializer withFormat(boolean bl, DateFormat dateFormat) {
        if (bl) {
            return new DateSerializer(true, null);
        }
        return new DateSerializer(false, dateFormat);
    }

    @Override
    protected long _timestamp(Date date) {
        return date == null ? 0L : date.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._useTimestamp) {
            jsonGenerator.writeNumber(this._timestamp(date));
        } else if (this._customFormat != null) {
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                jsonGenerator.writeString(this._customFormat.format(date));
            }
        } else {
            serializerProvider.defaultSerializeDateValue(date, jsonGenerator);
        }
    }
}

