/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind.ser.std;

import com.huawei.shade.com.fasterxml.jackson.core.JsonGenerationException;
import com.huawei.shade.com.fasterxml.jackson.core.JsonGenerator;
import com.huawei.shade.com.fasterxml.jackson.databind.BeanProperty;
import com.huawei.shade.com.fasterxml.jackson.databind.JavaType;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonMappingException;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonNode;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.SerializerProvider;
import com.huawei.shade.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.huawei.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.huawei.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.huawei.shade.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.huawei.shade.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.huawei.shade.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.huawei.shade.com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.huawei.shade.com.fasterxml.jackson.databind.type.ArrayType;
import com.huawei.shade.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ObjectArraySerializer
extends ArraySerializerBase<Object[]>
implements ContextualSerializer {
    protected final boolean _staticTyping;
    protected final JavaType _elementType;
    protected final TypeSerializer _valueTypeSerializer;
    protected JsonSerializer<Object> _elementSerializer;
    protected PropertySerializerMap _dynamicSerializers;

    public ObjectArraySerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        super(Object[].class, null);
        this._elementType = javaType;
        this._staticTyping = bl;
        this._valueTypeSerializer = typeSerializer;
        this._dynamicSerializers = PropertySerializerMap.emptyMap();
        this._elementSerializer = jsonSerializer;
    }

    public ObjectArraySerializer(ObjectArraySerializer objectArraySerializer, TypeSerializer typeSerializer) {
        super(objectArraySerializer);
        this._elementType = objectArraySerializer._elementType;
        this._valueTypeSerializer = typeSerializer;
        this._staticTyping = objectArraySerializer._staticTyping;
        this._dynamicSerializers = objectArraySerializer._dynamicSerializers;
        this._elementSerializer = objectArraySerializer._elementSerializer;
    }

    public ObjectArraySerializer(ObjectArraySerializer objectArraySerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        super(objectArraySerializer, beanProperty);
        this._elementType = objectArraySerializer._elementType;
        this._valueTypeSerializer = typeSerializer;
        this._staticTyping = objectArraySerializer._staticTyping;
        this._dynamicSerializers = objectArraySerializer._dynamicSerializers;
        this._elementSerializer = jsonSerializer;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new ObjectArraySerializer(this._elementType, this._staticTyping, typeSerializer, this._elementSerializer);
    }

    public ObjectArraySerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        if (this._property == beanProperty && jsonSerializer == this._elementSerializer && this._valueTypeSerializer == typeSerializer) {
            return this;
        }
        return new ObjectArraySerializer(this, beanProperty, typeSerializer, jsonSerializer);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        JsonSerializer<Object> jsonSerializer = null;
        if (beanProperty != null && (annotatedMember = beanProperty.getMember()) != null && (object = serializerProvider.getAnnotationIntrospector().findContentSerializer(annotatedMember)) != null) {
            jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._elementSerializer;
        }
        if ((jsonSerializer = this.findConvertingContentSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            if (this._elementType != null && (this._staticTyping || this.hasContentTypeAnnotation(serializerProvider, beanProperty))) {
                jsonSerializer = serializerProvider.findValueSerializer(this._elementType, beanProperty);
            }
        } else if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(serializerProvider, beanProperty);
        }
        return this.withResolved(beanProperty, typeSerializer, jsonSerializer);
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(Object[] objectArray) {
        return objectArray.length == 1;
    }

    @Override
    public void serializeContents(Object[] objectArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        int n2 = objectArray.length;
        if (n2 == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(objectArray, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        if (this._valueTypeSerializer != null) {
            this.serializeTypedContents(objectArray, jsonGenerator, serializerProvider);
            return;
        }
        Object object = null;
        try {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (object == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> clazz = object.getClass();
                JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
                if (jsonSerializer == null) {
                    jsonSerializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                }
                jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw JsonMappingException.wrapWithPath(throwable, object, n);
        }
    }

    public void serializeContentsUsing(Object[] objectArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        int n;
        int n2 = objectArray.length;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        Object object = null;
        try {
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (object == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                if (typeSerializer == null) {
                    jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw JsonMappingException.wrapWithPath(throwable, object, n);
        }
    }

    public void serializeTypedContents(Object[] objectArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        int n2 = objectArray.length;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        Object object = null;
        try {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (object == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> clazz = object.getClass();
                JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
                if (jsonSerializer == null) {
                    jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                }
                jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw JsonMappingException.wrapWithPath(throwable, object, n);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        JavaType javaType;
        ObjectNode objectNode = this.createSchemaNode("array", true);
        if (type != null && (javaType = serializerProvider.constructType(type)).isArrayType()) {
            Class<?> clazz = ((ArrayType)javaType).getContentType().getRawClass();
            if (clazz == Object.class) {
                objectNode.put("items", JsonSchema.getDefaultSchemaNode());
            } else {
                JsonSerializer<Object> jsonSerializer = serializerProvider.findValueSerializer(clazz, this._property);
                JsonNode jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, null) : JsonSchema.getDefaultSchemaNode();
                objectNode.put("items", jsonNode);
            }
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonArrayFormatVisitor jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType);
        if (jsonArrayFormatVisitor != null) {
            TypeFactory typeFactory = jsonFormatVisitorWrapper.getProvider().getTypeFactory();
            JavaType javaType2 = typeFactory.moreSpecificType(this._elementType, javaType.getContentType());
            if (javaType2 == null) {
                throw new JsonMappingException("Could not resolve type");
            }
            JsonSerializer<Object> jsonSerializer = this._elementSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = jsonFormatVisitorWrapper.getProvider().findValueSerializer(javaType2, this._property);
            }
            jsonArrayFormatVisitor.itemsFormat(jsonSerializer, javaType2);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddSerializer(clazz, serializerProvider, this._property);
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType javaType, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddSerializer(javaType, serializerProvider, this._property);
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }
}

