/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind.type;

import com.huawei.shade.com.fasterxml.jackson.databind.JavaType;
import com.huawei.shade.com.fasterxml.jackson.databind.type.TypeBase;
import java.util.Collection;
import java.util.Map;

public final class SimpleType
extends TypeBase {
    private static final long serialVersionUID = -800374828948534376L;
    protected final JavaType[] _typeParameters;
    protected final String[] _typeNames;

    protected SimpleType(Class<?> clazz) {
        this(clazz, null, null, null, null, false);
    }

    protected SimpleType(Class<?> clazz, String[] stringArray, JavaType[] javaTypeArray, Object object, Object object2, boolean bl) {
        super(clazz, 0, object, object2, bl);
        if (stringArray == null || stringArray.length == 0) {
            this._typeNames = null;
            this._typeParameters = null;
        } else {
            this._typeNames = stringArray;
            this._typeParameters = javaTypeArray;
        }
    }

    public static SimpleType constructUnsafe(Class<?> clazz) {
        return new SimpleType(clazz, null, null, null, null, false);
    }

    @Override
    protected JavaType _narrow(Class<?> clazz) {
        return new SimpleType(clazz, this._typeNames, this._typeParameters, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType narrowContentsBy(Class<?> clazz) {
        throw new IllegalArgumentException("Internal error: SimpleType.narrowContentsBy() should never be called");
    }

    @Override
    public JavaType widenContentsBy(Class<?> clazz) {
        throw new IllegalArgumentException("Internal error: SimpleType.widenContentsBy() should never be called");
    }

    public static SimpleType construct(Class<?> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Can not construct SimpleType for a Map (class: " + clazz.getName() + ")");
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Can not construct SimpleType for a Collection (class: " + clazz.getName() + ")");
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Can not construct SimpleType for an array (class: " + clazz.getName() + ")");
        }
        return new SimpleType(clazz);
    }

    @Override
    public SimpleType withTypeHandler(Object object) {
        return new SimpleType(this._class, this._typeNames, this._typeParameters, this._valueHandler, object, this._asStatic);
    }

    @Override
    public JavaType withContentTypeHandler(Object object) {
        throw new IllegalArgumentException("Simple types have no content types; can not call withContenTypeHandler()");
    }

    @Override
    public SimpleType withValueHandler(Object object) {
        if (object == this._valueHandler) {
            return this;
        }
        return new SimpleType(this._class, this._typeNames, this._typeParameters, object, this._typeHandler, this._asStatic);
    }

    @Override
    public SimpleType withContentValueHandler(Object object) {
        throw new IllegalArgumentException("Simple types have no content types; can not call withContenValueHandler()");
    }

    @Override
    public SimpleType withStaticTyping() {
        return this._asStatic ? this : new SimpleType(this._class, this._typeNames, this._typeParameters, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    protected String buildCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._class.getName());
        if (this._typeParameters != null && this._typeParameters.length > 0) {
            stringBuilder.append('<');
            boolean bl = true;
            for (JavaType javaType : this._typeParameters) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(javaType.toCanonical());
            }
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isContainerType() {
        return false;
    }

    @Override
    public int containedTypeCount() {
        return this._typeParameters == null ? 0 : this._typeParameters.length;
    }

    @Override
    public JavaType containedType(int n) {
        if (n < 0 || this._typeParameters == null || n >= this._typeParameters.length) {
            return null;
        }
        return this._typeParameters[n];
    }

    @Override
    public String containedTypeName(int n) {
        if (n < 0 || this._typeNames == null || n >= this._typeNames.length) {
            return null;
        }
        return this._typeNames[n];
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        return SimpleType._classSignature(this._class, stringBuilder, true);
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        SimpleType._classSignature(this._class, stringBuilder, false);
        if (this._typeParameters != null) {
            stringBuilder.append('<');
            for (JavaType javaType : this._typeParameters) {
                stringBuilder = javaType.getGenericSignature(stringBuilder);
            }
            stringBuilder.append('>');
        }
        stringBuilder.append(';');
        return stringBuilder;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append("[simple type, class ").append(this.buildCanonicalName()).append(']');
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        SimpleType simpleType = (SimpleType)object;
        if (simpleType._class != this._class) {
            return false;
        }
        JavaType[] javaTypeArray = this._typeParameters;
        JavaType[] javaTypeArray2 = simpleType._typeParameters;
        if (javaTypeArray == null) {
            return javaTypeArray2 == null || javaTypeArray2.length == 0;
        }
        if (javaTypeArray2 == null) {
            return false;
        }
        if (javaTypeArray.length != javaTypeArray2.length) {
            return false;
        }
        int n = javaTypeArray.length;
        for (int i = 0; i < n; ++i) {
            if (javaTypeArray[i].equals(javaTypeArray2[i])) continue;
            return false;
        }
        return true;
    }
}

