/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.org.apache.http.impl.client;

import com.huawei.shade.org.apache.http.HeaderElement;
import com.huawei.shade.org.apache.http.HttpResponse;
import com.huawei.shade.org.apache.http.annotation.Immutable;
import com.huawei.shade.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.huawei.shade.org.apache.http.message.BasicHeaderElementIterator;
import com.huawei.shade.org.apache.http.protocol.HttpContext;
import com.huawei.shade.org.apache.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

