/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.org.apache.http.impl.entity;

import com.huawei.shade.org.apache.http.HttpException;
import com.huawei.shade.org.apache.http.HttpMessage;
import com.huawei.shade.org.apache.http.ProtocolException;
import com.huawei.shade.org.apache.http.annotation.Immutable;
import com.huawei.shade.org.apache.http.entity.ContentLengthStrategy;
import com.huawei.shade.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

