/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.org.apache.http.impl.pool;

import com.huawei.shade.org.apache.http.HttpClientConnection;
import com.huawei.shade.org.apache.http.HttpHost;
import com.huawei.shade.org.apache.http.annotation.ThreadSafe;
import com.huawei.shade.org.apache.http.config.ConnectionConfig;
import com.huawei.shade.org.apache.http.config.SocketConfig;
import com.huawei.shade.org.apache.http.impl.pool.BasicConnFactory;
import com.huawei.shade.org.apache.http.impl.pool.BasicPoolEntry;
import com.huawei.shade.org.apache.http.params.HttpParams;
import com.huawei.shade.org.apache.http.pool.AbstractConnPool;
import com.huawei.shade.org.apache.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }
}

