/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.org.apache.http.util;

import com.huawei.shade.org.apache.http.Consts;
import com.huawei.shade.org.apache.http.util.Args;
import java.io.UnsupportedEncodingException;

public final class EncodingUtils {
    public static String getString(byte[] data, int offset, int length, String charset) {
        Args.notNull(data, "Input");
        Args.notEmpty(charset, "Charset");
        try {
            return new String(data, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(data, offset, length);
        }
    }

    public static String getString(byte[] data, String charset) {
        Args.notNull(data, "Input");
        return EncodingUtils.getString(data, 0, data.length, charset);
    }

    public static byte[] getBytes(String data, String charset) {
        Args.notNull(data, "Input");
        Args.notEmpty(charset, "Charset");
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return data.getBytes();
        }
    }

    public static byte[] getAsciiBytes(String data) {
        Args.notNull(data, "Input");
        try {
            return data.getBytes(Consts.ASCII.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("ASCII not supported");
        }
    }

    public static String getAsciiString(byte[] data, int offset, int length) {
        Args.notNull(data, "Input");
        try {
            return new String(data, offset, length, Consts.ASCII.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("ASCII not supported");
        }
    }

    public static String getAsciiString(byte[] data) {
        Args.notNull(data, "Input");
        return EncodingUtils.getAsciiString(data, 0, data.length);
    }

    private EncodingUtils() {
    }
}

