/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.initialize;

import kd.isc.rabbitmq.consumer.QueueManager;
import kd.isc.rabbitmq.entity.ConnectionEntity;
import kd.isc.rabbitmq.entity.ConnectionsEntity;
import kd.isc.rabbitmq.entity.IERPConsumerParamEntity;
import kd.isc.rabbitmq.entity.IERPConsumerQueue;
import kd.isc.rabbitmq.entity.MQConfInfoEntity;
import kd.isc.rabbitmq.entity.ProductorEntity;
import kd.isc.rabbitmq.entity.ProductorsEntity;
import kd.isc.rabbitmq.entity.PublisherEntity;
import kd.isc.rabbitmq.entity.PublishersEntity;
import kd.isc.rabbitmq.initialize.InitConfig;
import kd.isc.rabbitmq.initialize.InitConsumer;
import kd.isc.rabbitmq.util.RabbitMQCacheUtils;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class ConfigManager {
    private static Logger log = Logger.getLogger((String)ConfigManager.class.getName());

    private ConfigManager() {
    }

    public static void initConsumer() {
        log.info((Object)"MQ consumer init begin...");
        MQConfInfoEntity configInfo = InitConfig.getConfig();
        if (configInfo != null) {
            InitConsumer.initConsumer(configInfo.getConsumers());
        }
    }

    public static ProductorEntity getProductor(String name) {
        MQConfInfoEntity configInfo = InitConfig.getPublishConfig();
        ProductorsEntity productors = null;
        if (configInfo != null) {
            productors = configInfo.getProductors();
        }
        if (StringUtils.isNullObj(productors)) {
            log.error((Object)"MQ xml productors node config information is null.");
            return null;
        }
        for (ProductorEntity productor : productors.getProductors()) {
            if (!productor.getName().equals(name)) continue;
            return productor;
        }
        return null;
    }

    public static ConnectionEntity getConnection(String name) {
        MQConfInfoEntity configInfo = InitConfig.getPublishConfig();
        ConnectionsEntity connections = null;
        if (!StringUtils.isNullObj(configInfo)) {
            connections = configInfo.getConnections();
            for (ConnectionEntity con : connections.getConnections()) {
                if (!con.getName().equals(name)) continue;
                return con;
            }
        }
        return null;
    }

    public static PublisherEntity getPublisherEntity(String name) {
        MQConfInfoEntity configInfo = InitConfig.getPublishConfig();
        if (configInfo == null) {
            log.error((Object)"get mq xml config information is not exist.");
            return null;
        }
        PublishersEntity publishers = configInfo.getPublishers();
        if (publishers == null) {
            log.error((Object)"get mq xml config information,the <publishers> node information is null.");
            return null;
        }
        for (PublisherEntity p : publishers.getPublisherList()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static void initIerpConsumer(IERPConsumerParamEntity consumerParam) {
        log.info((Object)"init ierp system deal per consumer server begin...");
        if (consumerParam == null) {
            log.error((Object)"ierp system deal per consumer,method parameter is null.");
            throw new RuntimeException("ierp system deal per consumer,method parameter is null.");
        }
        try {
            InitConsumer.ierpDealPerConsumerServer(consumerParam);
        }
        catch (RuntimeException e) {
            log.error((Object)("ierp system deal consumer queue failed.exception info:" + e));
            throw e;
        }
    }

    public static void ierpEnableConsumer(IERPConsumerParamEntity consumerParam) {
        ConfigManager.initIerpConsumer(consumerParam);
    }

    public static void ierpDisableConsumer(IERPConsumerParamEntity consumerParam) {
        if (consumerParam == null) {
            log.error((Object)"ierp system deal per consumer,method parameter is null.");
            return;
        }
        ConnectionEntity conn = consumerParam.getConnectionEntity();
        if (conn == null) {
            log.error((Object)"ierp system deal per consumer,MQ connection is null.");
            return;
        }
        String realQueue = null;
        for (IERPConsumerQueue queue : consumerParam.getConsumerQueues()) {
            realQueue = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), queue.getRegion(), queue.getQueueName(), false);
            if (RabbitMQCacheUtils.containKey(realQueue)) continue;
            RabbitMQCacheUtils.put(realQueue, true);
        }
    }

    public static void ierpDealAutoSubscribeConsumer(IERPConsumerParamEntity consumerParam) {
        if (consumerParam == null) {
            log.error((Object)"ierp system deal per auto subscirbe consumer,method parameter is null.");
            throw new RuntimeException("ierp system deal per consumer,method parameter is null.");
        }
        try {
            InitConsumer.ierpDealPerAutoSubscribeConsumer(consumerParam);
        }
        catch (RuntimeException e) {
            log.error((Object)("ierp system deal auto subscribe consumer queue failed.exception info:" + e));
            throw e;
        }
    }
}

