/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.initialize;

import kd.isc.rabbitmq.constant.MQConstantEnum;
import kd.isc.rabbitmq.consumer.QueueManager;
import kd.isc.rabbitmq.entity.ConnectionEntity;
import kd.isc.rabbitmq.entity.ConsumerEntity;
import kd.isc.rabbitmq.entity.ConsumersEntity;
import kd.isc.rabbitmq.entity.IERPConsumerParamEntity;
import kd.isc.rabbitmq.entity.IERPConsumerQueue;
import kd.isc.rabbitmq.entity.ProductorEntity;
import kd.isc.rabbitmq.entity.QueueDef;
import kd.isc.rabbitmq.entity.RegionDef;
import kd.isc.rabbitmq.initialize.ConfigManager;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class InitConsumer {
    private static Logger log = Logger.getLogger((String)InitConsumer.class.getName());

    protected static void initConsumer(ConsumersEntity consumers) {
        for (ConsumerEntity consumer : consumers.getConsumers()) {
            InitConsumer.dealPerConsumer(consumer);
        }
    }

    protected static void ierpDealPerConsumerServer(IERPConsumerParamEntity consumerParam) {
        ConnectionEntity mqConn = consumerParam.getConnectionEntity();
        ProductorEntity autoCallBackProductor = consumerParam.getAutoCallBackProductor();
        for (IERPConsumerQueue consumerQueue : consumerParam.getConsumerQueues()) {
            QueueManager.initIerpPerConsumerQueue(consumerQueue, mqConn, autoCallBackProductor, false);
        }
    }

    protected static void ierpDealPerAutoSubscribeConsumer(IERPConsumerParamEntity consumerParam) {
        ConnectionEntity mqConn = consumerParam.getConnectionEntity();
        for (IERPConsumerQueue consumerQueue : consumerParam.getConsumerQueues()) {
            QueueManager.initIerpPerConsumerQueue(consumerQueue, mqConn, null, true);
        }
    }

    private static void dealPerConsumer(ConsumerEntity consumer) {
        String mqType = consumer.getType();
        if (StringUtils.isEmpty(mqType)) {
            mqType = MQConstantEnum.RABBITMQ_TYPE.getDesc();
        }
        String connectionName = consumer.getConnection();
        ConnectionEntity conn = ConfigManager.getConnection(connectionName);
        if (!StringUtils.isEmpty(mqType) && MQConstantEnum.RABBITMQ_TYPE.getDesc().equalsIgnoreCase(mqType)) {
            for (RegionDef region : consumer.getRegionDefs()) {
                try {
                    InitConsumer.initRegion(region, conn);
                }
                catch (Exception e) {
                    log.error((Object)("init mq for region " + region + "error"), (Throwable)e);
                }
            }
        }
    }

    private static void initRegion(RegionDef region, ConnectionEntity conn) {
        if (region == null) {
            log.warn((Object)"the other systme get region information failed.");
            return;
        }
        String name = region.getName();
        if (region.getQueues() == null) {
            return;
        }
        for (QueueDef queue : region.getQueues()) {
            InitConsumer.initQueue(name, queue, conn);
        }
    }

    private static void initQueue(String region, QueueDef queueDef, ConnectionEntity conn) {
        QueueManager.add(region, queueDef, conn);
    }
}

