/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.initialize;

import kd.isc.rabbitmq.consumer.subscribe.MessageConsumer;
import kd.isc.rabbitmq.consumer.subscribe.RabbitConsumer;
import kd.isc.rabbitmq.entity.ConnectionEntity;
import kd.isc.rabbitmq.entity.IERPConsumerQueue;
import kd.isc.rabbitmq.entity.ProductorEntity;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class InitQueue {
    private static final Logger logger = Logger.getLogger((String)InitQueue.class.getName());

    public static void initConsumer(String region, String queueName, String className, boolean isAutoAck, ConnectionEntity conn, boolean needCallBack, String productorName) {
        try {
            MessageConsumer mc = (MessageConsumer)Class.forName(className).newInstance();
            RabbitConsumer consumer = new RabbitConsumer(region, queueName, isAutoAck, conn, mc, needCallBack, productorName);
            consumer.start();
        }
        catch (Exception e) {
            logger.error((Object)("the consumer deal with MQ message failed ! exception info:" + e));
            throw new RuntimeException("the consumer deal with MQ message failed.", e);
        }
    }

    public static void initIerpConsumer(IERPConsumerQueue consumerQueue, String queueName, ConnectionEntity conn, ProductorEntity autoCallBackProductor) {
        if (StringUtils.isEmpty(consumerQueue.getConsumerClass())) {
            logger.error((Object)"the consumer deal with MQ message the consumer class is not exist.");
            throw new RuntimeException("the consumer deal with MQ message the consumer class is not exist.");
        }
        try {
            MessageConsumer mc = (MessageConsumer)Class.forName(consumerQueue.getConsumerClass()).newInstance();
            RabbitConsumer consumer = new RabbitConsumer(consumerQueue.getRegion(), queueName, consumerQueue.isAutoAck(), conn, mc, consumerQueue.isAutoCallBack(), autoCallBackProductor);
            consumer.ierpStart();
        }
        catch (Exception e) {
            logger.error((Object)("the consumer deal with MQ message failed ! exception info:" + e));
            throw new RuntimeException("the consumer deal with MQ message failed.", e);
        }
    }
}

