/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.productor.mqfactory;

import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.isc.rabbitmq.connection.ChannelFactory;
import kd.isc.rabbitmq.consumer.QueueManager;
import kd.isc.rabbitmq.entity.ConnectionEntity;
import kd.isc.rabbitmq.entity.ExtendEntity;
import kd.isc.rabbitmq.entity.ProductorEntity;
import kd.isc.rabbitmq.entity.PublisherEntity;
import kd.isc.rabbitmq.entity.QueueDef;
import kd.isc.rabbitmq.entity.RegionDef;
import kd.isc.rabbitmq.initialize.InitQueue;
import kd.isc.rabbitmq.productor.mqfactory.MQFactory;
import kd.isc.rabbitmq.productor.publish.MessagePublisher;
import kd.isc.rabbitmq.productor.publish.RabbitMQPublisher;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class RabbitMQFactory
extends MQFactory {
    private static Logger logger = Logger.getLogger((String)RabbitMQFactory.class.getName());
    private Map<String, Boolean> delcareQueueMap = new ConcurrentHashMap<String, Boolean>();
    private boolean needCallBack = false;
    private String region;
    private String queueName;
    private String callbackClass;

    @Override
    public MessagePublisher createSimplePublisher(String region, String queueName, String callbackClass) {
        this.callbackClass = callbackClass;
        this.region = region;
        this.queueName = queueName;
        this.needCallBack = StringUtils.isNotEmpty(callbackClass);
        ConnectionEntity conn = this.getConnection();
        if (conn == null) {
            logger.error((Object)"the productor connection information is null.");
            throw new RuntimeException("the productor connection information is null.");
        }
        String realQueueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), region, queueName, false);
        Channel channel = ChannelFactory.getChannel(region, conn);
        String key = QueueManager.makeKey(conn.getUserName(), region, realQueueName);
        try {
            if (!this.delcareQueueMap.containsKey(key)) {
                channel.queueDeclare(realQueueName, false, false, false, null);
                this.delcareQueueMap.put(key, Boolean.TRUE);
            }
        }
        catch (IOException e) {
            logger.error((Object)"other system create productor publisher failed.");
            throw new RuntimeException("other system create productor publisher failed.", e);
        }
        if (this.needCallBack) {
            this.createSimpleConsumer(conn);
        }
        ProductorEntity productor = this.getProductor();
        JSONObject extendsData = null;
        if (!StringUtils.isNullObj(productor)) {
            ExtendEntity extendEntity = productor.getExtend();
            extendsData = extendEntity.getExtendData();
        }
        return new RabbitMQPublisher(realQueueName, channel, extendsData);
    }

    @Override
    public List<MessagePublisher> createSimplePublisher() {
        PublisherEntity publisher = this.getPublisherEntity();
        if (publisher == null) {
            logger.error((Object)"read xml config file,the publisher node info is null.");
            return null;
        }
        ArrayList<MessagePublisher> publishList = new ArrayList<MessagePublisher>();
        MessagePublisher msgPublisher = null;
        String region = null;
        for (RegionDef r : publisher.getRegionDefs()) {
            region = r.getName();
            for (QueueDef q : r.getQueues()) {
                msgPublisher = this.createSimplePublisher(region, q.getName(), q.getAutoSubscribeClass());
                publishList.add(msgPublisher);
            }
        }
        return publishList;
    }

    @Override
    protected MessagePublisher createSimplePublisher(String region, String queueName, String consumerClass, ConnectionEntity mqConn, JSONObject productorExt) {
        this.callbackClass = consumerClass;
        this.region = region;
        this.queueName = queueName;
        this.needCallBack = StringUtils.isNotEmpty(consumerClass);
        if (mqConn == null) {
            logger.error((Object)"IERP sytem the productor connection information is null.");
            throw new RuntimeException("IERP sytem the productor connection information is null.");
        }
        String realQueueName = QueueManager.getRealQueueName(mqConn.getUserName(), mqConn.getPassword(), region, queueName, false);
        Channel channel = ChannelFactory.getChannel(region, mqConn);
        String key = QueueManager.makeKey(mqConn.getUserName(), region, realQueueName);
        try {
            if (!this.delcareQueueMap.containsKey(key)) {
                channel.queueDeclare(realQueueName, false, false, false, null);
                this.delcareQueueMap.put(key, Boolean.TRUE);
            }
        }
        catch (IOException e) {
            logger.error((Object)"IERP system create productor publisher failed.");
            throw new RuntimeException("IERP system create productor publisher failed.", e);
        }
        if (this.needCallBack) {
            this.createSimpleConsumer(mqConn);
        }
        return new RabbitMQPublisher(realQueueName, channel, productorExt);
    }

    private void createSimpleConsumer(ConnectionEntity conn) {
        if (StringUtils.isNullObj(conn)) {
            logger.error((Object)"productor auto subscribe message,MQ connection is not exist.");
            return;
        }
        String realQueueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), this.region, this.queueName, true);
        InitQueue.initConsumer(this.region, realQueueName, this.callbackClass, false, conn, false, null);
    }
}

