/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.asn1.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.BERSequence;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;

public class CompressedData
extends ASN1Encodable {
    private DERInteger version;
    private AlgorithmIdentifier compressionAlgorithm;
    private ContentInfo encapContentInfo;

    public CompressedData(AlgorithmIdentifier compressionAlgorithm, ContentInfo encapContentInfo) {
        this.version = new DERInteger(0);
        this.compressionAlgorithm = compressionAlgorithm;
        this.encapContentInfo = encapContentInfo;
    }

    public CompressedData(ASN1Sequence seq) {
        this.version = (DERInteger)seq.getObjectAt(0);
        this.compressionAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.encapContentInfo = ContentInfo.getInstance(seq.getObjectAt(2));
    }

    public static CompressedData getInstance(ASN1TaggedObject _ato, boolean _explicit) {
        return CompressedData.getInstance(ASN1Sequence.getInstance(_ato, _explicit));
    }

    public static CompressedData getInstance(Object _obj) {
        if (_obj == null || _obj instanceof CompressedData) {
            return (CompressedData)_obj;
        }
        if (_obj instanceof ASN1Sequence) {
            return new CompressedData((ASN1Sequence)_obj);
        }
        throw new IllegalArgumentException("Invalid CompressedData: " + _obj.getClass().getName());
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getCompressionAlgorithmIdentifier() {
        return this.compressionAlgorithm;
    }

    public ContentInfo getEncapContentInfo() {
        return this.encapContentInfo;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.compressionAlgorithm);
        v.add(this.encapContentInfo);
        return new BERSequence(v);
    }
}

