/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert.cmp;

import cn.tca.TopBasicCrypto.asn1.cmp.CertStatus;
import cn.tca.TopBasicCrypto.asn1.cmp.PKIStatusInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cert.cmp.CMPException;
import cn.tca.TopBasicCrypto.cert.cmp.CMPUtil;
import cn.tca.TopBasicCrypto.operator.DigestAlgorithmIdentifierFinder;
import cn.tca.TopBasicCrypto.operator.DigestCalculator;
import cn.tca.TopBasicCrypto.operator.DigestCalculatorProvider;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.util.Arrays;
import java.math.BigInteger;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder certHolder, DigestCalculatorProvider digesterProvider) throws CMPException {
        DigestCalculator digester;
        AlgorithmIdentifier digAlg = this.digestAlgFinder.find(certHolder.toASN1Structure().getSignatureAlgorithm());
        if (digAlg == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digester = digesterProvider.get(digAlg);
        }
        catch (OperatorCreationException e) {
            throw new CMPException("unable to create digester: " + e.getMessage(), e);
        }
        CMPUtil.derEncodeToStream(certHolder.toASN1Structure(), digester.getOutputStream());
        return Arrays.areEqual(this.certStatus.getCertHash().getOctets(), digester.getDigest());
    }
}

