/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms;

import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.cms.KeyTransRecipientInfo;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientInfo;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.RecipientInfoGenerator;
import cn.tca.TopBasicCrypto.operator.AsymmetricKeyWrapper;
import cn.tca.TopBasicCrypto.operator.GenericKey;
import cn.tca.TopBasicCrypto.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerial, AsymmetricKeyWrapper wrapper) {
        this.issuerAndSerial = issuerAndSerial;
        this.wrapper = wrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, AsymmetricKeyWrapper wrapper) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.wrapper = wrapper;
    }

    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        byte[] encryptedKeyBytes;
        try {
            encryptedKeyBytes = this.wrapper.generateWrappedKey(contentEncryptionKey);
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
        RecipientIdentifier recipId = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipId, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(encryptedKeyBytes)));
    }
}

