/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms.jcajce;

import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.RecipientOperator;
import cn.tca.TopBasicCrypto.cms.jcajce.JceKEKRecipient;
import cn.tca.TopBasicCrypto.jcajce.io.MacOutputStream;
import cn.tca.TopBasicCrypto.operator.GenericKey;
import cn.tca.TopBasicCrypto.operator.MacCalculator;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class JceKEKAuthenticatedRecipient
extends JceKEKRecipient {
    public JceKEKAuthenticatedRecipient(SecretKey recipientKey) {
        super(recipientKey);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentMacAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        final Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentMacAlgorithm, encryptedContentEncryptionKey);
        final Mac dataMac = this.contentHelper.createContentMac(secretKey, contentMacAlgorithm);
        return new RecipientOperator(new MacCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentMacAlgorithm;
            }

            public GenericKey getKey() {
                return new GenericKey(secretKey);
            }

            public OutputStream getOutputStream() {
                return new MacOutputStream(dataMac);
            }

            public byte[] getMac() {
                return dataMac.doFinal();
            }
        });
    }
}

