/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.agreement.kdf;

import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.crypto.DataLengthException;
import cn.tca.TopBasicCrypto.crypto.DerivationFunction;
import cn.tca.TopBasicCrypto.crypto.DerivationParameters;
import cn.tca.TopBasicCrypto.crypto.Digest;
import cn.tca.TopBasicCrypto.crypto.agreement.kdf.DHKDFParameters;
import cn.tca.TopBasicCrypto.crypto.generators.KDF2BytesGenerator;
import cn.tca.TopBasicCrypto.crypto.params.KDFParameters;

public class ECDHKEKGenerator
implements DerivationFunction {
    private DerivationFunction kdf;
    private DERObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    public void init(DerivationParameters param) {
        DHKDFParameters params = (DHKDFParameters)param;
        this.algorithm = params.getAlgorithm();
        this.keySize = params.getKeySize();
        this.z = params.getZ();
    }

    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new AlgorithmIdentifier(this.algorithm, new DERNull()));
        v.add(new DERTaggedObject(true, 2, new DEROctetString(this.integerToBytes(this.keySize))));
        this.kdf.init(new KDFParameters(this.z, new DERSequence(v).getDEREncoded()));
        return this.kdf.generateBytes(out, outOff, len);
    }

    private byte[] integerToBytes(int keySize) {
        byte[] val = new byte[]{(byte)(keySize >> 24), (byte)(keySize >> 16), (byte)(keySize >> 8), (byte)keySize};
        return val;
    }
}

