/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.generators;

import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPair;
import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.KeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.DSAKeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.DSAParameters;
import cn.tca.TopBasicCrypto.crypto.params.DSAPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.DSAPublicKeyParameters;
import cn.tca.TopBasicCrypto.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        return BigIntegers.createRandomInRange(ONE, q.subtract(ONE), random);
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

