/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.generators;

import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPair;
import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.KeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.GOST3410KeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.GOST3410Parameters;
import cn.tca.TopBasicCrypto.crypto.params.GOST3410PrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.GOST3410PublicKeyParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GOST3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private GOST3410KeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (GOST3410KeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x;
        GOST3410Parameters GOST3410Params2 = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q = GOST3410Params2.getQ();
        BigInteger p = GOST3410Params2.getP();
        BigInteger a = GOST3410Params2.getA();
        while ((x = new BigInteger(256, random)).equals(ZERO) || x.compareTo(q) >= 0) {
        }
        BigInteger y = a.modPow(x, p);
        return new AsymmetricCipherKeyPair(new GOST3410PublicKeyParameters(y, GOST3410Params2), new GOST3410PrivateKeyParameters(x, GOST3410Params2));
    }
}

