/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider;

import cn.tca.TopBasicCrypto.crypto.BlockCipher;
import cn.tca.TopBasicCrypto.crypto.CipherParameters;
import cn.tca.TopBasicCrypto.crypto.Mac;
import cn.tca.TopBasicCrypto.crypto.digests.MD2Digest;
import cn.tca.TopBasicCrypto.crypto.digests.MD4Digest;
import cn.tca.TopBasicCrypto.crypto.digests.MD5Digest;
import cn.tca.TopBasicCrypto.crypto.digests.RIPEMD128Digest;
import cn.tca.TopBasicCrypto.crypto.digests.RIPEMD160Digest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA1Digest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA224Digest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA256Digest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA384Digest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA512Digest;
import cn.tca.TopBasicCrypto.crypto.digests.TigerDigest;
import cn.tca.TopBasicCrypto.crypto.engines.DESEngine;
import cn.tca.TopBasicCrypto.crypto.engines.RC2Engine;
import cn.tca.TopBasicCrypto.crypto.macs.CBCBlockCipherMac;
import cn.tca.TopBasicCrypto.crypto.macs.CFBBlockCipherMac;
import cn.tca.TopBasicCrypto.crypto.macs.GOST28147Mac;
import cn.tca.TopBasicCrypto.crypto.macs.HMac;
import cn.tca.TopBasicCrypto.crypto.macs.ISO9797Alg3Mac;
import cn.tca.TopBasicCrypto.crypto.macs.OldHMac;
import cn.tca.TopBasicCrypto.crypto.paddings.ISO7816d4Padding;
import cn.tca.TopBasicCrypto.crypto.params.KeyParameter;
import cn.tca.TopBasicCrypto.crypto.params.ParametersWithIV;
import cn.tca.TopBasicCrypto.jce.provider.JCEPBEKey;
import cn.tca.TopBasicCrypto.jce.provider.PBE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class JCEMac
extends MacSpi
implements PBE {
    private Mac macEngine;
    private int pbeType = 2;
    private int pbeHash = 1;
    private int keySize = 160;

    protected JCEMac(Mac macEngine) {
        this.macEngine = macEngine;
    }

    protected JCEMac(Mac macEngine, int pbeType, int pbeHash, int keySize) {
        this.macEngine = macEngine;
        this.pbeType = pbeType;
        this.pbeHash = pbeHash;
        this.keySize = keySize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        if (key == null) {
            throw new InvalidKeyException("key is null");
        }
        if (key instanceof JCEPBEKey) {
            JCEPBEKey k = (JCEPBEKey)key;
            if (k.getParam() != null) {
                param = k.getParam();
            } else {
                if (!(params instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                param = PBE.Util.makePBEMacParameters(k, params);
            }
        } else if (params instanceof IvParameterSpec) {
            param = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)params).getIV());
        } else {
            if (params != null) throw new InvalidAlgorithmParameterException("unknown parameter type.");
            param = new KeyParameter(key.getEncoded());
        }
        this.macEngine.init(param);
    }

    protected int engineGetMacLength() {
        return this.macEngine.getMacSize();
    }

    protected void engineReset() {
        this.macEngine.reset();
    }

    protected void engineUpdate(byte input) {
        this.macEngine.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.macEngine.update(input, offset, len);
    }

    protected byte[] engineDoFinal() {
        byte[] out = new byte[this.engineGetMacLength()];
        this.macEngine.doFinal(out, 0);
        return out;
    }

    public static class PBEWithTiger
    extends JCEMac {
        public PBEWithTiger() {
            super(new HMac(new TigerDigest()), 2, 3, 192);
        }
    }

    public static class PBEWithSHA
    extends JCEMac {
        public PBEWithSHA() {
            super(new HMac(new SHA1Digest()), 2, 1, 160);
        }
    }

    public static class PBEWithRIPEMD160
    extends JCEMac {
        public PBEWithRIPEMD160() {
            super(new HMac(new RIPEMD160Digest()), 2, 2, 160);
        }
    }

    public static class Tiger
    extends JCEMac {
        public Tiger() {
            super(new HMac(new TigerDigest()));
        }
    }

    public static class RIPEMD160
    extends JCEMac {
        public RIPEMD160() {
            super(new HMac(new RIPEMD160Digest()));
        }
    }

    public static class RIPEMD128
    extends JCEMac {
        public RIPEMD128() {
            super(new HMac(new RIPEMD128Digest()));
        }
    }

    public static class OldSHA512
    extends JCEMac {
        public OldSHA512() {
            super(new OldHMac(new SHA512Digest()));
        }
    }

    public static class SHA512
    extends JCEMac {
        public SHA512() {
            super(new HMac(new SHA512Digest()));
        }
    }

    public static class OldSHA384
    extends JCEMac {
        public OldSHA384() {
            super(new OldHMac(new SHA384Digest()));
        }
    }

    public static class SHA384
    extends JCEMac {
        public SHA384() {
            super(new HMac(new SHA384Digest()));
        }
    }

    public static class SHA256
    extends JCEMac {
        public SHA256() {
            super(new HMac(new SHA256Digest()));
        }
    }

    public static class SHA224
    extends JCEMac {
        public SHA224() {
            super(new HMac(new SHA224Digest()));
        }
    }

    public static class SHA1
    extends JCEMac {
        public SHA1() {
            super(new HMac(new SHA1Digest()));
        }
    }

    public static class MD5
    extends JCEMac {
        public MD5() {
            super(new HMac(new MD5Digest()));
        }
    }

    public static class MD4
    extends JCEMac {
        public MD4() {
            super(new HMac(new MD4Digest()));
        }
    }

    public static class MD2
    extends JCEMac {
        public MD2() {
            super(new HMac(new MD2Digest()));
        }
    }

    public static class DES9797Alg3
    extends JCEMac {
        public DES9797Alg3() {
            super(new ISO9797Alg3Mac(new DESEngine()));
        }
    }

    public static class DES9797Alg3with7816d4
    extends JCEMac {
        public DES9797Alg3with7816d4() {
            super(new ISO9797Alg3Mac((BlockCipher)new DESEngine(), new ISO7816d4Padding()));
        }
    }

    public static class RC2CFB8
    extends JCEMac {
        public RC2CFB8() {
            super(new CFBBlockCipherMac(new RC2Engine()));
        }
    }

    public static class DESCFB8
    extends JCEMac {
        public DESCFB8() {
            super(new CFBBlockCipherMac(new DESEngine()));
        }
    }

    public static class GOST28147
    extends JCEMac {
        public GOST28147() {
            super(new GOST28147Mac());
        }
    }

    public static class RC2
    extends JCEMac {
        public RC2() {
            super(new CBCBlockCipherMac(new RC2Engine()));
        }
    }

    public static class DES
    extends JCEMac {
        public DES() {
            super(new CBCBlockCipherMac(new DESEngine()));
        }
    }
}

