/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider.symmetric;

import cn.tca.TopBasicCrypto.asn1.nist.NISTObjectIdentifiers;
import cn.tca.TopBasicCrypto.crypto.BufferedBlockCipher;
import cn.tca.TopBasicCrypto.crypto.CipherKeyGenerator;
import cn.tca.TopBasicCrypto.crypto.engines.AESFastEngine;
import cn.tca.TopBasicCrypto.crypto.engines.AESWrapEngine;
import cn.tca.TopBasicCrypto.crypto.engines.RFC3211WrapEngine;
import cn.tca.TopBasicCrypto.crypto.macs.CMac;
import cn.tca.TopBasicCrypto.crypto.modes.CBCBlockCipher;
import cn.tca.TopBasicCrypto.crypto.modes.CFBBlockCipher;
import cn.tca.TopBasicCrypto.crypto.modes.OFBBlockCipher;
import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher;
import cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JCEMac;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters;
import cn.tca.TopBasicCrypto.jce.provider.WrapCipherSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.spec.IvParameterSpec;

public final class AES {
    private AES() {
    }

    public static class Mappings
    extends HashMap {
        private static final String wrongAES128 = "2.16.840.1.101.3.4.2";
        private static final String wrongAES192 = "2.16.840.1.101.3.4.22";
        private static final String wrongAES256 = "2.16.840.1.101.3.4.42";

        public Mappings() {
            this.put("AlgorithmParameters.AES", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$AlgParams");
            this.put("Alg.Alias.AlgorithmParameters.2.16.840.1.101.3.4.2", "AES");
            this.put("Alg.Alias.AlgorithmParameters.2.16.840.1.101.3.4.22", "AES");
            this.put("Alg.Alias.AlgorithmParameters.2.16.840.1.101.3.4.42", "AES");
            this.put("Alg.Alias.AlgorithmParameters." + NISTObjectIdentifiers.id_aes128_CBC, "AES");
            this.put("Alg.Alias.AlgorithmParameters." + NISTObjectIdentifiers.id_aes192_CBC, "AES");
            this.put("Alg.Alias.AlgorithmParameters." + NISTObjectIdentifiers.id_aes256_CBC, "AES");
            this.put("AlgorithmParameterGenerator.AES", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$AlgParamGen");
            this.put("Alg.Alias.AlgorithmParameterGenerator.2.16.840.1.101.3.4.2", "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator.2.16.840.1.101.3.4.22", "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator.2.16.840.1.101.3.4.42", "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + NISTObjectIdentifiers.id_aes128_CBC, "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + NISTObjectIdentifiers.id_aes192_CBC, "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + NISTObjectIdentifiers.id_aes256_CBC, "AES");
            this.put("Cipher.AES", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$ECB");
            this.put("Alg.Alias.Cipher.2.16.840.1.101.3.4.2", "AES");
            this.put("Alg.Alias.Cipher.2.16.840.1.101.3.4.22", "AES");
            this.put("Alg.Alias.Cipher.2.16.840.1.101.3.4.42", "AES");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes128_ECB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$ECB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes192_ECB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$ECB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes256_ECB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$ECB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes128_CBC, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$CBC");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes192_CBC, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$CBC");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes256_CBC, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$CBC");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes128_OFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$OFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes192_OFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$OFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes256_OFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$OFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes128_CFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$CFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes192_CFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$CFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes256_CFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$CFB");
            this.put("Cipher.AESWRAP", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$Wrap");
            this.put("Alg.Alias.Cipher." + NISTObjectIdentifiers.id_aes128_wrap, "AESWRAP");
            this.put("Alg.Alias.Cipher." + NISTObjectIdentifiers.id_aes192_wrap, "AESWRAP");
            this.put("Alg.Alias.Cipher." + NISTObjectIdentifiers.id_aes256_wrap, "AESWRAP");
            this.put("Cipher.AESRFC3211WRAP", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$RFC3211Wrap");
            this.put("KeyGenerator.AES", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen");
            this.put("KeyGenerator.2.16.840.1.101.3.4.2", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator.2.16.840.1.101.3.4.22", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator.2.16.840.1.101.3.4.42", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_ECB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_CBC, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_OFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_CFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_ECB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_CBC, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_OFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_CFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_ECB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_CBC, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_OFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_CFB, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator.AESWRAP", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_wrap, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_wrap, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_wrap, "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$KeyGen256");
            this.put("Mac.AESCMAC", "cn.tca.TopBasicCrypto.jce.provider.symmetric.AES$AESCMAC");
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "AES IV";
        }
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("AES", BouncyCastleProvider.PROVIDER_NAME);
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen256
    extends KeyGen {
        public KeyGen256() {
            super(256);
        }
    }

    public static class KeyGen192
    extends KeyGen {
        public KeyGen192() {
            super(192);
        }
    }

    public static class KeyGen128
    extends KeyGen {
        public KeyGen128() {
            super(128);
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            this(192);
        }

        public KeyGen(int keySize) {
            super("AES", keySize, new CipherKeyGenerator());
        }
    }

    public static class RFC3211Wrap
    extends WrapCipherSpi {
        public RFC3211Wrap() {
            super(new RFC3211WrapEngine(new AESFastEngine()), 16);
        }
    }

    public static class Wrap
    extends WrapCipherSpi {
        public Wrap() {
            super(new AESWrapEngine());
        }
    }

    public static class AESCMAC
    extends JCEMac {
        public AESCMAC() {
            super(new CMac(new AESFastEngine()));
        }
    }

    public static class OFB
    extends JCEBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new AESFastEngine(), 128)), 128);
        }
    }

    public static class CFB
    extends JCEBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new AESFastEngine(), 128)), 128);
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new AESFastEngine()), 128);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new AESFastEngine());
        }
    }
}

