/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider.symmetric;

import cn.tca.TopBasicCrypto.crypto.CipherKeyGenerator;
import cn.tca.TopBasicCrypto.crypto.engines.NoekeonEngine;
import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher;
import cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.spec.IvParameterSpec;

public final class Noekeon {
    private Noekeon() {
    }

    public static class Mappings
    extends HashMap {
        public Mappings() {
            this.put("AlgorithmParameters.NOEKEON", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Noekeon$AlgParams");
            this.put("AlgorithmParameterGenerator.NOEKEON", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Noekeon$AlgParamGen");
            this.put("Cipher.NOEKEON", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Noekeon$ECB");
            this.put("KeyGenerator.NOEKEON", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Noekeon$KeyGen");
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "Noekeon IV";
        }
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for Noekeon parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("Noekeon", BouncyCastleProvider.PROVIDER_NAME);
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            super("Noekeon", 128, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new NoekeonEngine());
        }
    }
}

