/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider.symmetric;

import cn.tca.TopBasicCrypto.crypto.BufferedBlockCipher;
import cn.tca.TopBasicCrypto.crypto.CipherKeyGenerator;
import cn.tca.TopBasicCrypto.crypto.engines.RC6Engine;
import cn.tca.TopBasicCrypto.crypto.modes.CBCBlockCipher;
import cn.tca.TopBasicCrypto.crypto.modes.CFBBlockCipher;
import cn.tca.TopBasicCrypto.crypto.modes.OFBBlockCipher;
import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher;
import cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.spec.IvParameterSpec;

public final class RC6 {
    private RC6() {
    }

    public static class Mappings
    extends HashMap {
        public Mappings() {
            this.put("Cipher.RC6", "cn.tca.TopBasicCrypto.jce.provider.symmetric.RC6$ECB");
            this.put("KeyGenerator.RC6", "cn.tca.TopBasicCrypto.jce.provider.symmetric.RC6$KeyGen");
            this.put("AlgorithmParameters.RC6", "cn.tca.TopBasicCrypto.jce.provider.symmetric.RC6$AlgParams");
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "RC6 IV";
        }
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for RC6 parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("RC6", BouncyCastleProvider.PROVIDER_NAME);
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            super("RC6", 256, new CipherKeyGenerator());
        }
    }

    public static class OFB
    extends JCEBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new RC6Engine(), 128)), 128);
        }
    }

    public static class CFB
    extends JCEBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new RC6Engine(), 128)), 128);
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new RC6Engine()), 128);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new RC6Engine());
        }
    }
}

