/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.bcpg.Packet;
import cn.tca.TopBasicCrypto.bcpg.SignaturePacket;
import cn.tca.TopBasicCrypto.bcpg.TrustPacket;
import cn.tca.TopBasicCrypto.bcpg.UserAttributePacket;
import cn.tca.TopBasicCrypto.bcpg.UserIDPacket;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPUserAttributeSubpacketVector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class PGPKeyRing {
    PGPKeyRing() {
    }

    static BCPGInputStream wrap(InputStream in) {
        if (in instanceof BCPGInputStream) {
            return (BCPGInputStream)in;
        }
        return new BCPGInputStream(in);
    }

    static TrustPacket readOptionalTrustPacket(BCPGInputStream pIn) throws IOException {
        return pIn.nextPacketTag() == 12 ? (TrustPacket)pIn.readPacket() : null;
    }

    static List readSignaturesAndTrust(BCPGInputStream pIn) throws IOException {
        try {
            ArrayList<PGPSignature> sigList = new ArrayList<PGPSignature>();
            while (pIn.nextPacketTag() == 2) {
                SignaturePacket signaturePacket = (SignaturePacket)pIn.readPacket();
                TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(pIn);
                sigList.add(new PGPSignature(signaturePacket, trustPacket));
            }
            return sigList;
        }
        catch (PGPException e) {
            throw new IOException("can't create signature object: " + e.getMessage() + ", cause: " + e.getUnderlyingException().toString());
        }
    }

    static void readUserIDs(BCPGInputStream pIn, List ids, List idTrusts, List idSigs) throws IOException {
        while (pIn.nextPacketTag() == 13 || pIn.nextPacketTag() == 17) {
            Packet obj = pIn.readPacket();
            if (obj instanceof UserIDPacket) {
                UserIDPacket id = (UserIDPacket)obj;
                ids.add(id.getID());
            } else {
                UserAttributePacket user = (UserAttributePacket)obj;
                ids.add(new PGPUserAttributeSubpacketVector(user.getSubpackets()));
            }
            idTrusts.add(PGPKeyRing.readOptionalTrustPacket(pIn));
            idSigs.add(PGPKeyRing.readSignaturesAndTrust(pIn));
        }
    }
}

