/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.openpgp.PGPCompressedData;
import cn.tca.TopBasicCrypto.openpgp.PGPEncryptedDataList;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPLiteralData;
import cn.tca.TopBasicCrypto.openpgp.PGPMarker;
import cn.tca.TopBasicCrypto.openpgp.PGPOnePassSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPOnePassSignatureList;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKeyRing;
import cn.tca.TopBasicCrypto.openpgp.PGPSecretKeyRing;
import cn.tca.TopBasicCrypto.openpgp.PGPSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPSignatureList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class PGPObjectFactory {
    BCPGInputStream in;

    public PGPObjectFactory(InputStream in) {
        this.in = new BCPGInputStream(in);
    }

    public PGPObjectFactory(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public Object nextObject() throws IOException {
        switch (this.in.nextPacketTag()) {
            case -1: {
                return null;
            }
            case 2: {
                ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
                while (this.in.nextPacketTag() == 2) {
                    try {
                        l.add(new PGPSignature(this.in));
                    }
                    catch (PGPException e) {
                        throw new IOException("can't create signature object: " + e);
                    }
                }
                return new PGPSignatureList(l.toArray(new PGPSignature[l.size()]));
            }
            case 5: {
                try {
                    return new PGPSecretKeyRing(this.in);
                }
                catch (PGPException e) {
                    throw new IOException("can't create secret key object: " + e);
                }
            }
            case 6: {
                return new PGPPublicKeyRing(this.in);
            }
            case 14: {
                return PGPPublicKeyRing.readSubkey(this.in);
            }
            case 8: {
                return new PGPCompressedData(this.in);
            }
            case 11: {
                return new PGPLiteralData(this.in);
            }
            case 1: 
            case 3: {
                return new PGPEncryptedDataList(this.in);
            }
            case 4: {
                ArrayList<PGPOnePassSignature> l = new ArrayList<PGPOnePassSignature>();
                while (this.in.nextPacketTag() == 4) {
                    try {
                        l.add(new PGPOnePassSignature(this.in));
                    }
                    catch (PGPException e) {
                        throw new IOException("can't create one pass signature object: " + e);
                    }
                }
                return new PGPOnePassSignatureList(l.toArray(new PGPOnePassSignature[l.size()]));
            }
            case 10: {
                return new PGPMarker(this.in);
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.in.readPacket();
            }
        }
        throw new IOException("unknown object in stream: " + this.in.nextPacketTag());
    }
}

