/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.bcpg.InputStreamPacket;
import cn.tca.TopBasicCrypto.bcpg.SymmetricEncIntegrityPacket;
import cn.tca.TopBasicCrypto.bcpg.SymmetricKeyEncSessionPacket;
import cn.tca.TopBasicCrypto.openpgp.PGPDataValidationException;
import cn.tca.TopBasicCrypto.openpgp.PGPEncryptedData;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import java.io.EOFException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PGPPBEEncryptedData
extends PGPEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    public InputStream getInputStream() {
        return this.encData.getInputStream();
    }

    public InputStream getDataStream(char[] passPhrase, String provider) throws PGPException, NoSuchProviderException {
        return this.getDataStream(passPhrase, PGPUtil.getProvider(provider));
    }

    public InputStream getDataStream(char[] passPhrase, Provider provider) throws PGPException {
        try {
            boolean zeroesCheckPassed;
            int keyAlgorithm = this.keyData.getEncAlgorithm();
            SecretKey key = PGPUtil.makeKeyFromPassPhrase(keyAlgorithm, this.keyData.getS2K(), passPhrase, provider);
            byte[] secKeyData = this.keyData.getSecKeyData();
            if (secKeyData != null && secKeyData.length > 0) {
                Cipher keyCipher = Cipher.getInstance(PGPUtil.getSymmetricCipherName(keyAlgorithm) + "/CFB/NoPadding", provider);
                keyCipher.init(2, (Key)key, new IvParameterSpec(new byte[keyCipher.getBlockSize()]));
                byte[] keyBytes = keyCipher.doFinal(secKeyData);
                keyAlgorithm = keyBytes[0];
                key = new SecretKeySpec(keyBytes, 1, keyBytes.length - 1, PGPUtil.getSymmetricCipherName(keyAlgorithm));
            }
            Cipher c = this.createStreamCipher(keyAlgorithm, provider);
            byte[] iv = new byte[c.getBlockSize()];
            c.init(2, (Key)key, new IvParameterSpec(iv));
            this.encStream = new BCPGInputStream(new CipherInputStream(this.encData.getInputStream(), c));
            if (this.encData instanceof SymmetricEncIntegrityPacket) {
                this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                String digestName = PGPUtil.getDigestName(2);
                MessageDigest digest = MessageDigest.getInstance(digestName, provider);
                this.encStream = new DigestInputStream(this.truncStream, digest);
            }
            for (int i = 0; i != iv.length; ++i) {
                int ch = this.encStream.read();
                if (ch < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                iv[i] = (byte)ch;
            }
            int v1 = this.encStream.read();
            int v2 = this.encStream.read();
            if (v1 < 0 || v2 < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            boolean repeatCheckPassed = iv[iv.length - 2] == (byte)v1 && iv[iv.length - 1] == (byte)v2;
            boolean bl = zeroesCheckPassed = v1 == 0 && v2 == 0;
            if (!repeatCheckPassed && !zeroesCheckPassed) {
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    private Cipher createStreamCipher(int keyAlgorithm, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, PGPException {
        String mode = this.encData instanceof SymmetricEncIntegrityPacket ? "CFB" : "OpenPGPCFB";
        String cName = PGPUtil.getSymmetricCipherName(keyAlgorithm) + "/" + mode + "/NoPadding";
        return Cipher.getInstance(cName, provider);
    }
}

