/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGKey;
import cn.tca.TopBasicCrypto.bcpg.BCPGObject;
import cn.tca.TopBasicCrypto.bcpg.BCPGOutputStream;
import cn.tca.TopBasicCrypto.bcpg.ContainedPacket;
import cn.tca.TopBasicCrypto.bcpg.DSAPublicBCPGKey;
import cn.tca.TopBasicCrypto.bcpg.ElGamalPublicBCPGKey;
import cn.tca.TopBasicCrypto.bcpg.MPInteger;
import cn.tca.TopBasicCrypto.bcpg.PublicKeyAlgorithmTags;
import cn.tca.TopBasicCrypto.bcpg.PublicKeyPacket;
import cn.tca.TopBasicCrypto.bcpg.RSAPublicBCPGKey;
import cn.tca.TopBasicCrypto.bcpg.TrustPacket;
import cn.tca.TopBasicCrypto.bcpg.UserAttributePacket;
import cn.tca.TopBasicCrypto.bcpg.UserIDPacket;
import cn.tca.TopBasicCrypto.jce.interfaces.ElGamalPublicKey;
import cn.tca.TopBasicCrypto.jce.spec.ElGamalParameterSpec;
import cn.tca.TopBasicCrypto.jce.spec.ElGamalPublicKeySpec;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPSignatureSubpacketVector;
import cn.tca.TopBasicCrypto.openpgp.PGPUserAttributeSubpacketVector;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import cn.tca.TopBasicCrypto.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private static final int[] MASTER_KEY_CERTIFICATION_TYPES = new int[]{19, 18, 17, 16};
    PublicKeyPacket publicPk;
    TrustPacket trustPk;
    List keySigs = new ArrayList();
    List ids = new ArrayList();
    List idTrusts = new ArrayList();
    List idSigs = new ArrayList();
    List subSigs = null;
    private long keyID;
    private byte[] fingerprint;
    private int keyStrength;

    private void init() throws IOException {
        BCPGKey key = this.publicPk.getKey();
        if (this.publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rK = (RSAPublicBCPGKey)key;
            this.keyID = rK.getModulus().longValue();
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] bytes = new MPInteger(rK.getModulus()).getEncoded();
                digest.update(bytes, 2, bytes.length - 2);
                bytes = new MPInteger(rK.getPublicExponent()).getEncoded();
                digest.update(bytes, 2, bytes.length - 2);
                this.fingerprint = digest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("can't find MD5");
            }
            this.keyStrength = rK.getModulus().bitLength();
        } else {
            byte[] kBytes = this.publicPk.getEncodedContents();
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA1");
                digest.update((byte)-103);
                digest.update((byte)(kBytes.length >> 8));
                digest.update((byte)kBytes.length);
                digest.update(kBytes);
                this.fingerprint = digest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("can't find SHA1");
            }
            this.keyID = (long)(this.fingerprint[this.fingerprint.length - 8] & 0xFF) << 56 | (long)(this.fingerprint[this.fingerprint.length - 7] & 0xFF) << 48 | (long)(this.fingerprint[this.fingerprint.length - 6] & 0xFF) << 40 | (long)(this.fingerprint[this.fingerprint.length - 5] & 0xFF) << 32 | (long)(this.fingerprint[this.fingerprint.length - 4] & 0xFF) << 24 | (long)(this.fingerprint[this.fingerprint.length - 3] & 0xFF) << 16 | (long)(this.fingerprint[this.fingerprint.length - 2] & 0xFF) << 8 | (long)(this.fingerprint[this.fingerprint.length - 1] & 0xFF);
            if (key instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)key).getModulus().bitLength();
            } else if (key instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)key).getP().bitLength();
            } else if (key instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)key).getP().bitLength();
            }
        }
    }

    public PGPPublicKey(int algorithm, PublicKey pubKey, Date time, String provider) throws PGPException, NoSuchProviderException {
        this(algorithm, pubKey, time);
    }

    public PGPPublicKey(int algorithm, PublicKey pubKey, Date time) throws PGPException {
        BCPGObject bcpgKey;
        if (pubKey instanceof RSAPublicKey) {
            RSAPublicKey rK = (RSAPublicKey)pubKey;
            bcpgKey = new RSAPublicBCPGKey(rK.getModulus(), rK.getPublicExponent());
        } else if (pubKey instanceof DSAPublicKey) {
            DSAPublicKey dK = (DSAPublicKey)pubKey;
            DSAParams dP = dK.getParams();
            bcpgKey = new DSAPublicBCPGKey(dP.getP(), dP.getQ(), dP.getG(), dK.getY());
        } else if (pubKey instanceof ElGamalPublicKey) {
            ElGamalPublicKey eK = (ElGamalPublicKey)pubKey;
            ElGamalParameterSpec eS = eK.getParameters();
            bcpgKey = new ElGamalPublicBCPGKey(eS.getP(), eS.getG(), eK.getY());
        } else {
            throw new PGPException("unknown key class");
        }
        this.publicPk = new PublicKeyPacket(algorithm, time, (BCPGKey)((Object)bcpgKey));
        this.ids = new ArrayList();
        this.idSigs = new ArrayList();
        try {
            this.init();
        }
        catch (IOException e) {
            throw new PGPException("exception calculating keyID", e);
        }
    }

    PGPPublicKey(PublicKeyPacket publicPk, TrustPacket trustPk, List sigs) throws IOException {
        this.publicPk = publicPk;
        this.trustPk = trustPk;
        this.subSigs = sigs;
        this.init();
    }

    PGPPublicKey(PGPPublicKey key, TrustPacket trust, List subSigs) {
        this.publicPk = key.publicPk;
        this.trustPk = trust;
        this.subSigs = subSigs;
        this.fingerprint = key.fingerprint;
        this.keyID = key.keyID;
        this.keyStrength = key.keyStrength;
    }

    PGPPublicKey(PGPPublicKey pubKey) {
        int i;
        this.publicPk = pubKey.publicPk;
        this.keySigs = new ArrayList(pubKey.keySigs);
        this.ids = new ArrayList(pubKey.ids);
        this.idTrusts = new ArrayList(pubKey.idTrusts);
        this.idSigs = new ArrayList(pubKey.idSigs.size());
        for (i = 0; i != pubKey.idSigs.size(); ++i) {
            this.idSigs.add(new ArrayList((ArrayList)pubKey.idSigs.get(i)));
        }
        if (pubKey.subSigs != null) {
            this.subSigs = new ArrayList(pubKey.subSigs.size());
            for (i = 0; i != pubKey.subSigs.size(); ++i) {
                this.subSigs.add(pubKey.subSigs.get(i));
            }
        }
        this.fingerprint = pubKey.fingerprint;
        this.keyID = pubKey.keyID;
        this.keyStrength = pubKey.keyStrength;
    }

    PGPPublicKey(PublicKeyPacket publicPk, TrustPacket trustPk, List keySigs, List ids, List idTrusts, List idSigs) throws IOException {
        this.publicPk = publicPk;
        this.trustPk = trustPk;
        this.keySigs = keySigs;
        this.ids = ids;
        this.idTrusts = idTrusts;
        this.idSigs = idSigs;
        this.init();
    }

    PGPPublicKey(PublicKeyPacket publicPk, List ids, List idSigs) throws IOException {
        this.publicPk = publicPk;
        this.ids = ids;
        this.idSigs = idSigs;
        this.init();
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        if (this.publicPk.getVersion() > 3) {
            return (int)(this.getValidSeconds() / 86400L);
        }
        return this.publicPk.getValidDays();
    }

    public byte[] getTrustData() {
        if (this.trustPk == null) {
            return null;
        }
        return Arrays.clone(this.trustPk.getLevelAndTrustAmount());
    }

    public long getValidSeconds() {
        if (this.publicPk.getVersion() > 3) {
            if (this.isMasterKey()) {
                for (int i = 0; i != MASTER_KEY_CERTIFICATION_TYPES.length; ++i) {
                    long seconds = this.getExpirationTimeFromSig(true, MASTER_KEY_CERTIFICATION_TYPES[i]);
                    if (seconds < 0L) continue;
                    return seconds;
                }
            } else {
                long seconds = this.getExpirationTimeFromSig(false, 24);
                if (seconds >= 0L) {
                    return seconds;
                }
            }
            return 0L;
        }
        return (long)this.publicPk.getValidDays() * 24L * 60L * 60L;
    }

    private long getExpirationTimeFromSig(boolean selfSigned, int signatureType) {
        Iterator signatures = this.getSignaturesOfType(signatureType);
        if (signatures.hasNext()) {
            PGPSignature sig = (PGPSignature)signatures.next();
            if (!selfSigned || sig.getKeyID() == this.getKeyID()) {
                PGPSignatureSubpacketVector hashed = sig.getHashedSubPackets();
                if (hashed != null) {
                    return hashed.getKeyExpirationTime();
                }
                return 0L;
            }
        }
        return -1L;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        byte[] tmp = new byte[this.fingerprint.length];
        System.arraycopy(this.fingerprint, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public boolean isEncryptionKey() {
        int algorithm = this.publicPk.getAlgorithm();
        return algorithm == 1 || algorithm == 2 || algorithm == 16 || algorithm == 20;
    }

    public boolean isMasterKey() {
        return this.subSigs == null;
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public PublicKey getKey(String provider) throws PGPException, NoSuchProviderException {
        return this.getKey(PGPUtil.getProvider(provider));
    }

    public PublicKey getKey(Provider provider) throws PGPException {
        try {
            switch (this.publicPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaK = (RSAPublicBCPGKey)this.publicPk.getKey();
                    RSAPublicKeySpec rsaSpec = new RSAPublicKeySpec(rsaK.getModulus(), rsaK.getPublicExponent());
                    KeyFactory fact = KeyFactory.getInstance("RSA", provider);
                    return fact.generatePublic(rsaSpec);
                }
                case 17: {
                    DSAPublicBCPGKey dsaK = (DSAPublicBCPGKey)this.publicPk.getKey();
                    DSAPublicKeySpec dsaSpec = new DSAPublicKeySpec(dsaK.getY(), dsaK.getP(), dsaK.getQ(), dsaK.getG());
                    KeyFactory fact = KeyFactory.getInstance("DSA", provider);
                    return fact.generatePublic(dsaSpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elK = (ElGamalPublicBCPGKey)this.publicPk.getKey();
                    ElGamalPublicKeySpec elSpec = new ElGamalPublicKeySpec(elK.getY(), new ElGamalParameterSpec(elK.getP(), elK.getG()));
                    KeyFactory fact = KeyFactory.getInstance("ElGamal", provider);
                    return fact.generatePublic(elSpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception constructing public key", e);
        }
    }

    public Iterator getUserIDs() {
        ArrayList temp = new ArrayList();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof String)) continue;
            temp.add(this.ids.get(i));
        }
        return temp.iterator();
    }

    public Iterator getUserAttributes() {
        ArrayList temp = new ArrayList();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof PGPUserAttributeSubpacketVector)) continue;
            temp.add(this.ids.get(i));
        }
        return temp.iterator();
    }

    public Iterator getSignaturesForID(String id) {
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!id.equals(this.ids.get(i))) continue;
            return ((ArrayList)this.idSigs.get(i)).iterator();
        }
        return null;
    }

    public Iterator getSignaturesForUserAttribute(PGPUserAttributeSubpacketVector userAttributes) {
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!userAttributes.equals(this.ids.get(i))) continue;
            return ((ArrayList)this.idSigs.get(i)).iterator();
        }
        return null;
    }

    public Iterator getSignaturesOfType(int signatureType) {
        ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
        Iterator it = this.getSignatures();
        while (it.hasNext()) {
            PGPSignature sig = (PGPSignature)it.next();
            if (sig.getSignatureType() != signatureType) continue;
            l.add(sig);
        }
        return l.iterator();
    }

    public Iterator getSignatures() {
        if (this.subSigs == null) {
            ArrayList sigs = new ArrayList();
            sigs.addAll(this.keySigs);
            for (int i = 0; i != this.idSigs.size(); ++i) {
                sigs.addAll((Collection)this.idSigs.get(i));
            }
            return sigs.iterator();
        }
        return this.subSigs.iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.publicPk);
        if (this.trustPk != null) {
            out.writePacket(this.trustPk);
        }
        if (this.subSigs == null) {
            int i;
            for (i = 0; i != this.keySigs.size(); ++i) {
                ((PGPSignature)this.keySigs.get(i)).encode(out);
            }
            for (i = 0; i != this.ids.size(); ++i) {
                if (this.ids.get(i) instanceof String) {
                    String id = (String)this.ids.get(i);
                    out.writePacket(new UserIDPacket(id));
                } else {
                    PGPUserAttributeSubpacketVector v = (PGPUserAttributeSubpacketVector)this.ids.get(i);
                    out.writePacket(new UserAttributePacket(v.toSubpacketArray()));
                }
                if (this.idTrusts.get(i) != null) {
                    out.writePacket((ContainedPacket)this.idTrusts.get(i));
                }
                List sigs = (List)this.idSigs.get(i);
                for (int j = 0; j != sigs.size(); ++j) {
                    ((PGPSignature)sigs.get(j)).encode(out);
                }
            }
        } else {
            for (int j = 0; j != this.subSigs.size(); ++j) {
                ((PGPSignature)this.subSigs.get(j)).encode(out);
            }
        }
    }

    public boolean isRevoked() {
        int ns = 0;
        boolean revoked = false;
        if (this.isMasterKey()) {
            while (!revoked && ns < this.keySigs.size()) {
                if (((PGPSignature)this.keySigs.get(ns++)).getSignatureType() != 32) continue;
                revoked = true;
            }
        } else {
            while (!revoked && ns < this.subSigs.size()) {
                if (((PGPSignature)this.subSigs.get(ns++)).getSignatureType() != 40) continue;
                revoked = true;
            }
        }
        return revoked;
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, String id, PGPSignature certification) {
        return PGPPublicKey.addCert(key, id, certification);
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes, PGPSignature certification) {
        return PGPPublicKey.addCert(key, userAttributes, certification);
    }

    private static PGPPublicKey addCert(PGPPublicKey key, Object id, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        List<PGPSignature> sigList = null;
        for (int i = 0; i != returnKey.ids.size(); ++i) {
            if (!id.equals(returnKey.ids.get(i))) continue;
            sigList = (List)returnKey.idSigs.get(i);
        }
        if (sigList != null) {
            sigList.add(certification);
        } else {
            sigList = new ArrayList<PGPSignature>();
            sigList.add(certification);
            returnKey.ids.add(id);
            returnKey.idTrusts.add(null);
            returnKey.idSigs.add(sigList);
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes) {
        return PGPPublicKey.removeCert(key, userAttributes);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, String id) {
        return PGPPublicKey.removeCert(key, id);
    }

    private static PGPPublicKey removeCert(PGPPublicKey key, Object id) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = false;
        for (int i = 0; i < returnKey.ids.size(); ++i) {
            if (!id.equals(returnKey.ids.get(i))) continue;
            found = true;
            returnKey.ids.remove(i);
            returnKey.idTrusts.remove(i);
            returnKey.idSigs.remove(i);
        }
        if (!found) {
            return null;
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, String id, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, id, certification);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, userAttributes, certification);
    }

    private static PGPPublicKey removeCert(PGPPublicKey key, Object id, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = false;
        for (int i = 0; i < returnKey.ids.size(); ++i) {
            if (!id.equals(returnKey.ids.get(i))) continue;
            found = ((List)returnKey.idSigs.get(i)).remove(certification);
        }
        if (!found) {
            return null;
        }
        return returnKey;
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, PGPSignature certification) {
        if (key.isMasterKey()) {
            if (certification.getSignatureType() == 40) {
                throw new IllegalArgumentException("signature type incorrect for master key revocation.");
            }
        } else if (certification.getSignatureType() == 32) {
            throw new IllegalArgumentException("signature type incorrect for sub-key revocation.");
        }
        PGPPublicKey returnKey = new PGPPublicKey(key);
        if (returnKey.subSigs != null) {
            returnKey.subSigs.add(certification);
        } else {
            returnKey.keySigs.add(certification);
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = returnKey.subSigs != null ? returnKey.subSigs.remove(certification) : returnKey.keySigs.remove(certification);
        if (!found) {
            Iterator sIt;
            Object id;
            Iterator it = key.getUserIDs();
            while (it.hasNext()) {
                id = (String)it.next();
                sIt = key.getSignaturesForID((String)id);
                while (sIt.hasNext()) {
                    if (certification != sIt.next()) continue;
                    found = true;
                    returnKey = PGPPublicKey.removeCertification(returnKey, (String)id, certification);
                }
            }
            if (!found) {
                it = key.getUserAttributes();
                while (it.hasNext()) {
                    id = (PGPUserAttributeSubpacketVector)it.next();
                    sIt = key.getSignaturesForUserAttribute((PGPUserAttributeSubpacketVector)id);
                    while (sIt.hasNext()) {
                        if (certification != sIt.next()) continue;
                        found = true;
                        returnKey = PGPPublicKey.removeCertification(returnKey, (PGPUserAttributeSubpacketVector)id, certification);
                    }
                }
            }
        }
        return returnKey;
    }
}

