/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.bcpg.InputStreamPacket;
import cn.tca.TopBasicCrypto.bcpg.PublicKeyEncSessionPacket;
import cn.tca.TopBasicCrypto.bcpg.SymmetricEncIntegrityPacket;
import cn.tca.TopBasicCrypto.jce.interfaces.ElGamalKey;
import cn.tca.TopBasicCrypto.openpgp.PGPEncryptedData;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPKeyValidationException;
import cn.tca.TopBasicCrypto.openpgp.PGPPrivateKey;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import java.io.EOFException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    private static Cipher getKeyCipher(int algorithm, Provider provider) throws PGPException {
        try {
            switch (algorithm) {
                case 1: 
                case 2: {
                    return Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
                }
                case 16: 
                case 20: {
                    return Cipher.getInstance("ElGamal/ECB/PKCS1Padding", provider);
                }
            }
            throw new PGPException("unknown asymmetric algorithm: " + algorithm);
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    private boolean confirmCheckSum(byte[] sessionInfo) {
        int check = 0;
        for (int i = 1; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        return sessionInfo[sessionInfo.length - 2] == (byte)(check >> 8) && sessionInfo[sessionInfo.length - 1] == (byte)check;
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public int getSymmetricAlgorithm(PGPPrivateKey privKey, String provider) throws PGPException, NoSuchProviderException {
        return this.getSymmetricAlgorithm(privKey, PGPUtil.getProvider(provider));
    }

    public int getSymmetricAlgorithm(PGPPrivateKey privKey, Provider provider) throws PGPException, NoSuchProviderException {
        byte[] plain = this.fetchSymmetricKeyData(privKey, provider);
        return plain[0];
    }

    public InputStream getDataStream(PGPPrivateKey privKey, String provider) throws PGPException, NoSuchProviderException {
        return this.getDataStream(privKey, provider, provider);
    }

    public InputStream getDataStream(PGPPrivateKey privKey, Provider provider) throws PGPException {
        return this.getDataStream(privKey, provider, provider);
    }

    public InputStream getDataStream(PGPPrivateKey privKey, String asymProvider, String provider) throws PGPException, NoSuchProviderException {
        return this.getDataStream(privKey, PGPUtil.getProvider(asymProvider), PGPUtil.getProvider(provider));
    }

    public InputStream getDataStream(PGPPrivateKey privKey, Provider asymProvider, Provider provider) throws PGPException {
        Cipher c2;
        byte[] plain = this.fetchSymmetricKeyData(privKey, asymProvider);
        try {
            c2 = this.encData instanceof SymmetricEncIntegrityPacket ? Cipher.getInstance(PGPUtil.getSymmetricCipherName(plain[0]) + "/CFB/NoPadding", provider) : Cipher.getInstance(PGPUtil.getSymmetricCipherName(plain[0]) + "/OpenPGPCFB/NoPadding", provider);
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception creating cipher", e);
        }
        if (c2 != null) {
            try {
                SecretKeySpec key = new SecretKeySpec(plain, 1, plain.length - 3, PGPUtil.getSymmetricCipherName(plain[0]));
                byte[] iv = new byte[c2.getBlockSize()];
                c2.init(2, (Key)key, new IvParameterSpec(iv));
                this.encStream = new BCPGInputStream(new CipherInputStream(this.encData.getInputStream(), c2));
                if (this.encData instanceof SymmetricEncIntegrityPacket) {
                    this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                    this.encStream = new DigestInputStream(this.truncStream, MessageDigest.getInstance(PGPUtil.getDigestName(2), provider));
                }
                for (int i = 0; i != iv.length; ++i) {
                    int ch = this.encStream.read();
                    if (ch < 0) {
                        throw new EOFException("unexpected end of stream.");
                    }
                    iv[i] = (byte)ch;
                }
                int v1 = this.encStream.read();
                int v2 = this.encStream.read();
                if (v1 < 0 || v2 < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                return this.encStream;
            }
            catch (PGPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PGPException("Exception starting decryption", e);
            }
        }
        return this.encData.getInputStream();
    }

    private byte[] fetchSymmetricKeyData(PGPPrivateKey privKey, Provider asymProvider) throws PGPException {
        byte[] plain;
        Cipher c1 = PGPPublicKeyEncryptedData.getKeyCipher(this.keyData.getAlgorithm(), asymProvider);
        try {
            c1.init(2, privKey.getKey());
        }
        catch (InvalidKeyException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
        BigInteger[] keyD = this.keyData.getEncSessionKey();
        if (this.keyData.getAlgorithm() == 2 || this.keyData.getAlgorithm() == 1) {
            byte[] bi = keyD[0].toByteArray();
            if (bi[0] == 0) {
                c1.update(bi, 1, bi.length - 1);
            } else {
                c1.update(bi);
            }
        } else {
            ElGamalKey k = (ElGamalKey)((Object)privKey.getKey());
            int size = (k.getParameters().getP().bitLength() + 7) / 8;
            byte[] tmp = new byte[size];
            byte[] bi = keyD[0].toByteArray();
            if (bi.length > size) {
                c1.update(bi, 1, bi.length - 1);
            } else {
                System.arraycopy(bi, 0, tmp, tmp.length - bi.length, bi.length);
                c1.update(tmp);
            }
            bi = keyD[1].toByteArray();
            for (int i = 0; i != tmp.length; ++i) {
                tmp[i] = 0;
            }
            if (bi.length > size) {
                c1.update(bi, 1, bi.length - 1);
            } else {
                System.arraycopy(bi, 0, tmp, tmp.length - bi.length, bi.length);
                c1.update(tmp);
            }
        }
        try {
            plain = c1.doFinal();
        }
        catch (Exception e) {
            throw new PGPException("exception decrypting secret key", e);
        }
        if (!this.confirmCheckSum(plain)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        return plain;
    }
}

