/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.MPInteger;
import cn.tca.TopBasicCrypto.bcpg.OnePassSignaturePacket;
import cn.tca.TopBasicCrypto.bcpg.SignaturePacket;
import cn.tca.TopBasicCrypto.bcpg.SignatureSubpacket;
import cn.tca.TopBasicCrypto.bcpg.UserAttributeSubpacket;
import cn.tca.TopBasicCrypto.bcpg.sig.IssuerKeyID;
import cn.tca.TopBasicCrypto.bcpg.sig.SignatureCreationTime;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPOnePassSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPPrivateKey;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKey;
import cn.tca.TopBasicCrypto.openpgp.PGPSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPSignatureSubpacketVector;
import cn.tca.TopBasicCrypto.openpgp.PGPUserAttributeSubpacketVector;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import cn.tca.TopBasicCrypto.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;

public class PGPSignatureGenerator {
    private int keyAlgorithm;
    private int hashAlgorithm;
    private PGPPrivateKey privKey;
    private Signature sig;
    private MessageDigest dig;
    private int signatureType;
    private byte lastb;
    SignatureSubpacket[] unhashed = new SignatureSubpacket[0];
    SignatureSubpacket[] hashed = new SignatureSubpacket[0];

    public PGPSignatureGenerator(int keyAlgorithm, int hashAlgorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this(keyAlgorithm, provider, hashAlgorithm, provider);
    }

    public PGPSignatureGenerator(int keyAlgorithm, int hashAlgorithm, Provider provider) throws NoSuchAlgorithmException, PGPException {
        this(keyAlgorithm, provider, hashAlgorithm, provider);
    }

    public PGPSignatureGenerator(int keyAlgorithm, String sigProvider, int hashAlgorithm, String digProvider) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this(keyAlgorithm, PGPUtil.getProvider(sigProvider), hashAlgorithm, PGPUtil.getProvider(digProvider));
    }

    public PGPSignatureGenerator(int keyAlgorithm, Provider sigProvider, int hashAlgorithm, Provider digProvider) throws NoSuchAlgorithmException, PGPException {
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.dig = PGPUtil.getDigestInstance(PGPUtil.getDigestName(hashAlgorithm), digProvider);
        this.sig = Signature.getInstance(PGPUtil.getSignatureName(keyAlgorithm, hashAlgorithm), sigProvider);
    }

    public void initSign(int signatureType, PGPPrivateKey key) throws PGPException {
        this.initSign(signatureType, key, null);
    }

    public void initSign(int signatureType, PGPPrivateKey key, SecureRandom random) throws PGPException {
        this.privKey = key;
        this.signatureType = signatureType;
        try {
            if (random == null) {
                this.sig.initSign(key.getKey());
            } else {
                this.sig.initSign(key.getKey(), random);
            }
        }
        catch (InvalidKeyException e) {
            throw new PGPException("invalid key.", e);
        }
        this.dig.reset();
        this.lastb = 0;
    }

    public void update(byte b) throws SignatureException {
        if (this.signatureType == 1) {
            if (b == 13) {
                this.sig.update((byte)13);
                this.sig.update((byte)10);
                this.dig.update((byte)13);
                this.dig.update((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.sig.update((byte)13);
                    this.sig.update((byte)10);
                    this.dig.update((byte)13);
                    this.dig.update((byte)10);
                }
            } else {
                this.sig.update(b);
                this.dig.update(b);
            }
            this.lastb = b;
        } else {
            this.sig.update(b);
            this.dig.update(b);
        }
    }

    public void update(byte[] b) throws SignatureException {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int off, int len) throws SignatureException {
        if (this.signatureType == 1) {
            int finish = off + len;
            for (int i = off; i != finish; ++i) {
                this.update(b[i]);
            }
        } else {
            this.sig.update(b, off, len);
            this.dig.update(b, off, len);
        }
    }

    public void setHashedSubpackets(PGPSignatureSubpacketVector hashedPcks) {
        if (hashedPcks == null) {
            this.hashed = new SignatureSubpacket[0];
            return;
        }
        this.hashed = hashedPcks.toSubpacketArray();
    }

    public void setUnhashedSubpackets(PGPSignatureSubpacketVector unhashedPcks) {
        if (unhashedPcks == null) {
            this.unhashed = new SignatureSubpacket[0];
            return;
        }
        this.unhashed = unhashedPcks.toSubpacketArray();
    }

    public PGPOnePassSignature generateOnePassVersion(boolean isNested) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.signatureType, this.hashAlgorithm, this.keyAlgorithm, this.privKey.getKeyID(), isNested));
    }

    public PGPSignature generate() throws PGPException, SignatureException {
        int version = 4;
        ByteArrayOutputStream sOut = new ByteArrayOutputStream();
        SignatureSubpacket[] hPkts = !this.packetPresent(this.hashed, 2) ? this.insertSubpacket(this.hashed, new SignatureCreationTime(false, new Date())) : this.hashed;
        SignatureSubpacket[] unhPkts = !this.packetPresent(this.hashed, 16) && !this.packetPresent(this.unhashed, 16) ? this.insertSubpacket(this.unhashed, new IssuerKeyID(false, this.privKey.getKeyID())) : this.unhashed;
        try {
            sOut.write((byte)version);
            sOut.write((byte)this.signatureType);
            sOut.write((byte)this.keyAlgorithm);
            sOut.write((byte)this.hashAlgorithm);
            ByteArrayOutputStream hOut = new ByteArrayOutputStream();
            for (int i = 0; i != hPkts.length; ++i) {
                hPkts[i].encode(hOut);
            }
            byte[] data = hOut.toByteArray();
            sOut.write((byte)(data.length >> 8));
            sOut.write((byte)data.length);
            sOut.write(data);
        }
        catch (IOException e) {
            throw new PGPException("exception encoding hashed data.", e);
        }
        byte[] hData = sOut.toByteArray();
        sOut.write((byte)version);
        sOut.write(-1);
        sOut.write((byte)(hData.length >> 24));
        sOut.write((byte)(hData.length >> 16));
        sOut.write((byte)(hData.length >> 8));
        sOut.write((byte)hData.length);
        byte[] trailer = sOut.toByteArray();
        this.sig.update(trailer);
        this.dig.update(trailer);
        MPInteger[] sigValues = this.keyAlgorithm == 3 || this.keyAlgorithm == 1 ? new MPInteger[]{new MPInteger(new BigInteger(1, this.sig.sign()))} : PGPUtil.dsaSigToMpi(this.sig.sign());
        byte[] digest = this.dig.digest();
        byte[] fingerPrint = new byte[]{digest[0], digest[1]};
        return new PGPSignature(new SignaturePacket(this.signatureType, this.privKey.getKeyID(), this.keyAlgorithm, this.hashAlgorithm, hPkts, unhPkts, fingerPrint, sigValues));
    }

    public PGPSignature generateCertification(String id, PGPPublicKey pubKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pubKey);
        this.updateWithIdData(180, Strings.toByteArray(id));
        return this.generate();
    }

    public PGPSignature generateCertification(PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey pubKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pubKey);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            UserAttributeSubpacket[] packets = userAttributes.toSubpacketArray();
            for (int i = 0; i != packets.length; ++i) {
                packets[i].encode(bOut);
            }
            this.updateWithIdData(209, bOut.toByteArray());
        }
        catch (IOException e) {
            throw new PGPException("cannot encode subpacket array", e);
        }
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey masterKey, PGPPublicKey pubKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(masterKey);
        this.updateWithPublicKey(pubKey);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pubKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pubKey);
        return this.generate();
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pubKey) throws PGPException {
        byte[] keyBytes;
        try {
            keyBytes = pubKey.publicPk.getEncodedContents();
        }
        catch (IOException e) {
            throw new PGPException("exception preparing key.", e);
        }
        return keyBytes;
    }

    private boolean packetPresent(SignatureSubpacket[] packets, int type) {
        for (int i = 0; i != packets.length; ++i) {
            if (packets[i].getType() != type) continue;
            return true;
        }
        return false;
    }

    private SignatureSubpacket[] insertSubpacket(SignatureSubpacket[] packets, SignatureSubpacket subpacket) {
        SignatureSubpacket[] tmp = new SignatureSubpacket[packets.length + 1];
        tmp[0] = subpacket;
        System.arraycopy(packets, 0, tmp, 1, packets.length);
        return tmp;
    }

    private void updateWithIdData(int header, byte[] idBytes) throws SignatureException {
        this.update((byte)header);
        this.update((byte)(idBytes.length >> 24));
        this.update((byte)(idBytes.length >> 16));
        this.update((byte)(idBytes.length >> 8));
        this.update((byte)idBytes.length);
        this.update(idBytes);
    }

    private void updateWithPublicKey(PGPPublicKey key) throws PGPException, SignatureException {
        byte[] keyBytes = this.getEncodedPublicKey(key);
        this.update((byte)-103);
        this.update((byte)(keyBytes.length >> 8));
        this.update((byte)keyBytes.length);
        this.update(keyBytes);
    }
}

