/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.bcpg.ArmoredInputStream;
import cn.tca.TopBasicCrypto.bcpg.HashAlgorithmTags;
import cn.tca.TopBasicCrypto.bcpg.MPInteger;
import cn.tca.TopBasicCrypto.bcpg.S2K;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPLiteralDataGenerator;
import cn.tca.TopBasicCrypto.util.encoders.Base64;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PGPUtil
implements HashAlgorithmTags {
    private static String defProvider = "BC";
    private static final int READ_AHEAD = 60;

    public static String getDefaultProvider() {
        return defProvider;
    }

    public static void setDefaultProvider(String provider) {
        defProvider = provider;
    }

    static MPInteger[] dsaSigToMpi(byte[] encoding) throws PGPException {
        DERInteger i2;
        DERInteger i1;
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        try {
            ASN1Sequence s = (ASN1Sequence)aIn.readObject();
            i1 = (DERInteger)s.getObjectAt(0);
            i2 = (DERInteger)s.getObjectAt(1);
        }
        catch (IOException e) {
            throw new PGPException("exception encoding signature", e);
        }
        MPInteger[] values = new MPInteger[]{new MPInteger(i1.getValue()), new MPInteger(i2.getValue())};
        return values;
    }

    static String getDigestName(int hashAlgorithm) throws PGPException {
        switch (hashAlgorithm) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + hashAlgorithm);
    }

    static String getSignatureName(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        String encAlg;
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                encAlg = "RSA";
                break;
            }
            case 17: {
                encAlg = "DSA";
                break;
            }
            case 16: 
            case 20: {
                encAlg = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + keyAlgorithm);
            }
        }
        return PGPUtil.getDigestName(hashAlgorithm) + "with" + encAlg;
    }

    static String getSymmetricCipherName(int algorithm) throws PGPException {
        switch (algorithm) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES";
            }
            case 8: {
                return "AES";
            }
            case 9: {
                return "AES";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new PGPException("unknown symmetric algorithm: " + algorithm);
    }

    public static SecretKey makeRandomKey(int algorithm, SecureRandom random) throws PGPException {
        String algName = null;
        int keySize = 0;
        switch (algorithm) {
            case 2: {
                keySize = 192;
                algName = "DES_EDE";
                break;
            }
            case 1: {
                keySize = 128;
                algName = "IDEA";
                break;
            }
            case 3: {
                keySize = 128;
                algName = "CAST5";
                break;
            }
            case 4: {
                keySize = 128;
                algName = "Blowfish";
                break;
            }
            case 5: {
                keySize = 128;
                algName = "SAFER";
                break;
            }
            case 6: {
                keySize = 64;
                algName = "DES";
                break;
            }
            case 7: {
                keySize = 128;
                algName = "AES";
                break;
            }
            case 8: {
                keySize = 192;
                algName = "AES";
                break;
            }
            case 9: {
                keySize = 256;
                algName = "AES";
                break;
            }
            case 10: {
                keySize = 256;
                algName = "Twofish";
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + algorithm);
            }
        }
        byte[] keyBytes = new byte[(keySize + 7) / 8];
        random.nextBytes(keyBytes);
        return new SecretKeySpec(keyBytes, algName);
    }

    public static SecretKey makeKeyFromPassPhrase(int algorithm, char[] passPhrase, String provider) throws NoSuchProviderException, PGPException {
        return PGPUtil.makeKeyFromPassPhrase(algorithm, null, passPhrase, provider);
    }

    public static SecretKey makeKeyFromPassPhrase(int algorithm, S2K s2k, char[] passPhrase, String provider) throws PGPException, NoSuchProviderException {
        Provider prov = PGPUtil.getProvider(provider);
        return PGPUtil.makeKeyFromPassPhrase(algorithm, s2k, passPhrase, prov);
    }

    public static SecretKey makeKeyFromPassPhrase(int algorithm, S2K s2k, char[] passPhrase, Provider provider) throws PGPException, NoSuchProviderException {
        String algName = null;
        int keySize = 0;
        switch (algorithm) {
            case 2: {
                keySize = 192;
                algName = "DES_EDE";
                break;
            }
            case 1: {
                keySize = 128;
                algName = "IDEA";
                break;
            }
            case 3: {
                keySize = 128;
                algName = "CAST5";
                break;
            }
            case 4: {
                keySize = 128;
                algName = "Blowfish";
                break;
            }
            case 5: {
                keySize = 128;
                algName = "SAFER";
                break;
            }
            case 6: {
                keySize = 64;
                algName = "DES";
                break;
            }
            case 7: {
                keySize = 128;
                algName = "AES";
                break;
            }
            case 8: {
                keySize = 192;
                algName = "AES";
                break;
            }
            case 9: {
                keySize = 256;
                algName = "AES";
                break;
            }
            case 10: {
                keySize = 256;
                algName = "Twofish";
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + algorithm);
            }
        }
        byte[] pBytes = new byte[passPhrase.length];
        for (int i = 0; i != passPhrase.length; ++i) {
            pBytes[i] = (byte)passPhrase[i];
        }
        byte[] keyBytes = new byte[(keySize + 7) / 8];
        int generatedBytes = 0;
        int loopCount = 0;
        while (generatedBytes < keyBytes.length) {
            MessageDigest digest;
            block32: {
                block31: {
                    if (s2k == null) break block31;
                    String digestName = PGPUtil.getDigestName(s2k.getHashAlgorithm());
                    try {
                        digest = PGPUtil.getDigestInstance(digestName, provider);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new PGPException("can't find S2K digest", e);
                    }
                    for (int i = 0; i != loopCount; ++i) {
                        digest.update((byte)0);
                    }
                    byte[] iv = s2k.getIV();
                    block14 : switch (s2k.getType()) {
                        case 0: {
                            digest.update(pBytes);
                            break;
                        }
                        case 1: {
                            digest.update(iv);
                            digest.update(pBytes);
                            break;
                        }
                        case 3: {
                            long count = s2k.getIterationCount();
                            digest.update(iv);
                            digest.update(pBytes);
                            count -= (long)(iv.length + pBytes.length);
                            while (count > 0L) {
                                if (count < (long)iv.length) {
                                    digest.update(iv, 0, (int)count);
                                    break block14;
                                }
                                digest.update(iv);
                                if ((count -= (long)iv.length) < (long)pBytes.length) {
                                    digest.update(pBytes, 0, (int)count);
                                    count = 0L;
                                    continue;
                                }
                                digest.update(pBytes);
                                count -= (long)pBytes.length;
                            }
                            break block32;
                        }
                        default: {
                            throw new PGPException("unknown S2K type: " + s2k.getType());
                        }
                    }
                    break block32;
                }
                try {
                    digest = PGPUtil.getDigestInstance("MD5", provider);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new PGPException("can't find MD5 digest", e);
                }
                for (int i = 0; i != loopCount; ++i) {
                    digest.update((byte)0);
                }
                digest.update(pBytes);
            }
            byte[] dig = digest.digest();
            if (dig.length > keyBytes.length - generatedBytes) {
                System.arraycopy(dig, 0, keyBytes, generatedBytes, keyBytes.length - generatedBytes);
            } else {
                System.arraycopy(dig, 0, keyBytes, generatedBytes, dig.length);
            }
            generatedBytes += dig.length;
            ++loopCount;
        }
        for (int i = 0; i != pBytes.length; ++i) {
            pBytes[i] = 0;
        }
        return new SecretKeySpec(keyBytes, algName);
    }

    static MessageDigest getDigestInstance(String digestName, Provider provider) throws NoSuchAlgorithmException {
        try {
            return MessageDigest.getInstance(digestName, provider);
        }
        catch (NoSuchAlgorithmException e) {
            return MessageDigest.getInstance(digestName);
        }
    }

    public static void writeFileToLiteralData(OutputStream out, char fileType, File file) throws IOException {
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(out, fileType, file.getName(), file.length(), new Date(file.lastModified()));
        PGPUtil.pipeFileContents(file, pOut, 4096);
    }

    public static void writeFileToLiteralData(OutputStream out, char fileType, File file, byte[] buffer) throws IOException {
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(out, fileType, file.getName(), new Date(file.lastModified()), buffer);
        PGPUtil.pipeFileContents(file, pOut, buffer.length);
    }

    private static void pipeFileContents(File file, OutputStream pOut, int bufSize) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(file);
        byte[] buf = new byte[bufSize];
        while ((len = in.read(buf)) > 0) {
            pOut.write(buf, 0, len);
        }
        pOut.close();
        in.close();
    }

    private static boolean isPossiblyBase64(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 43 || ch == 47 || ch == 13 || ch == 10;
    }

    public static InputStream getDecoderStream(InputStream in) throws IOException {
        int count;
        if (!in.markSupported()) {
            in = new BufferedInputStreamExt(in);
        }
        in.mark(60);
        int ch = in.read();
        if ((ch & 0x80) != 0) {
            in.reset();
            return in;
        }
        if (!PGPUtil.isPossiblyBase64(ch)) {
            in.reset();
            return new ArmoredInputStream(in);
        }
        byte[] buf = new byte[60];
        int index = 1;
        buf[0] = (byte)ch;
        for (count = 1; count != 60 && (ch = in.read()) >= 0; ++count) {
            if (!PGPUtil.isPossiblyBase64(ch)) {
                in.reset();
                return new ArmoredInputStream(in);
            }
            if (ch == 10 || ch == 13) continue;
            buf[index++] = (byte)ch;
        }
        in.reset();
        if (count < 4) {
            return new ArmoredInputStream(in);
        }
        byte[] firstBlock = new byte[8];
        System.arraycopy(buf, 0, firstBlock, 0, firstBlock.length);
        byte[] decoded = Base64.decode(firstBlock);
        if ((decoded[0] & 0x80) != 0) {
            return new ArmoredInputStream(in, false);
        }
        return new ArmoredInputStream(in);
    }

    static Provider getProvider(String providerName) throws NoSuchProviderException {
        Provider prov = Security.getProvider(providerName);
        if (prov == null) {
            throw new NoSuchProviderException("provider " + providerName + " not found.");
        }
        return prov;
    }

    static class BufferedInputStreamExt
    extends BufferedInputStream {
        BufferedInputStreamExt(InputStream input) {
            super(input);
        }

        public synchronized int available() throws IOException {
            int result = super.available();
            if (result < 0) {
                result = Integer.MAX_VALUE;
            }
            return result;
        }
    }
}

