/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.operator.bc;

import cn.tca.TopBasicCrypto.asn1.nist.NISTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.oiw.OIWObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.crypto.Digest;
import cn.tca.TopBasicCrypto.crypto.ExtendedDigest;
import cn.tca.TopBasicCrypto.crypto.digests.MD4Digest;
import cn.tca.TopBasicCrypto.crypto.digests.MD5Digest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA1Digest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA224Digest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA256Digest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA384Digest;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;

class BcUtil {
    BcUtil() {
    }

    static Digest createDigest(AlgorithmIdentifier digAlg) throws OperatorCreationException {
        ExtendedDigest dig;
        if (digAlg.getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
            dig = new SHA1Digest();
        } else if (digAlg.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
            dig = new SHA224Digest();
        } else if (digAlg.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
            dig = new SHA256Digest();
        } else if (digAlg.getAlgorithm().equals(NISTObjectIdentifiers.id_sha384)) {
            dig = new SHA384Digest();
        } else if (digAlg.getAlgorithm().equals(NISTObjectIdentifiers.id_sha512)) {
            dig = new SHA384Digest();
        } else if (digAlg.getAlgorithm().equals(PKCSObjectIdentifiers.md5)) {
            dig = new MD5Digest();
        } else if (digAlg.getAlgorithm().equals(PKCSObjectIdentifiers.md4)) {
            dig = new MD4Digest();
        } else {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return dig;
    }
}

