/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.bc.cms;

import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.cert.X509CRLHolder;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cert.jcajce.JcaCRLStore;
import cn.tca.TopBasicCrypto.cert.jcajce.JcaCertStore;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSProcessableByteArray;
import cn.tca.TopBasicCrypto.cms.CMSSignedData;
import cn.tca.TopBasicCrypto.cms.CMSSignedDataGenerator;
import cn.tca.TopBasicCrypto.cms.SignerInformation;
import cn.tca.TopBasicCrypto.cms.SignerInformationStore;
import cn.tca.TopBasicCrypto.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import cn.tca.TopBasicCrypto.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.operator.ContentSigner;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.operator.jcajce.JcaContentSignerBuilder;
import cn.tca.TopBasicCrypto.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import cn.tca.TopBasicCrypto.util.Store;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CMSSignedDataUtil {
    private static Provider provider = Security.getProvider("BC");

    public static CMSSignedData genCMSSignedDate(byte[] plaintext, String signAlgorithm, PrivateKey privateKey, Certificate signCert, Certificate[] certChain, CRL[] crls, Provider provider) throws CertificateEncodingException, IOException, OperatorCreationException, CMSException, CRLException {
        if (provider == null) {
            provider = CMSSignedDataUtil.provider;
        }
        ArrayList<X509CertificateHolder> certList = new ArrayList<X509CertificateHolder>();
        if (plaintext == null) {
            plaintext = new byte[]{};
        }
        CMSProcessableByteArray msg = new CMSProcessableByteArray(plaintext);
        X509CertificateHolder signCertHolder = new X509CertificateHolder(signCert.getEncoded());
        certList.add(signCertHolder);
        if (certChain != null) {
            for (int i = 0; i < certChain.length; ++i) {
                certList.add(new X509CertificateHolder(certChain[i].getEncoded()));
            }
        }
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner signer = null;
        if (privateKey != null) {
            signer = new JcaContentSignerBuilder(signAlgorithm).setProvider(provider).build(privateKey);
        }
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(provider).build()).build(signer, signCertHolder));
        gen.addCertificates(certs);
        if (crls != null) {
            ArrayList<X509CRLHolder> crlList = new ArrayList<X509CRLHolder>();
            for (int i = 0; i < crls.length; ++i) {
                crlList.add(new X509CRLHolder(((X509CRL)crls[i]).getEncoded()));
            }
            JcaCRLStore crlstore = new JcaCRLStore(crlList);
            gen.addCRLs(crlstore);
        }
        return gen.generate(msg, false);
    }

    public static void verifyCMSSignedData(byte[] plaintext, CMSSignedData data, Provider provider) throws OperatorCreationException, CertificateException, CMSException {
        ContentInfo contentInfo = data.getContentInfo();
        DEREncodable dEREncodable = contentInfo.getContent();
        if (dEREncodable != null) {
            DEROctetString dEROctetString = (DEROctetString)dEREncodable;
            plaintext = dEROctetString.getOctets();
        }
        System.out.println(new String("plaintext"));
        if (provider == null) {
            provider = CMSSignedDataUtil.provider;
        }
        Store certStore = data.getCertificates();
        SignerInformationStore signers = data.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        int count = 0;
        int verified = 0;
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(provider).build(cert))) {
                ++verified;
            }
            ++count;
        }
        if (verified != count) {
            throw new CMSException(count + " signer found, but " + verified + " is verified.");
        }
    }

    static {
        if (provider == null) {
            provider = new BouncyCastleProvider();
        }
        if (provider.getVersion() != 1.46) {
            throw new RuntimeException("needs bouncy castale v1.46");
        }
        Security.addProvider(provider);
    }
}

