/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.pkcs11.P11Key;
import cn.topca.security.pkcs11.P11KeyGenerator;
import cn.topca.security.pkcs11.Session;
import cn.topca.security.pkcs11.Token;
import cn.topca.security.pkcs11.jna.CK_ATTRIBUTE;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class P11SecretKeyFactory
extends SecretKeyFactorySpi {
    private final Token token;
    private final String algorithm;
    private static final Map<String, Long> keyTypes = new HashMap<String, Long>();

    P11SecretKeyFactory(Token token, String algorithm) {
        this.token = token;
        this.algorithm = algorithm;
    }

    private static void addKeyType(String name, long id) {
        Long l = id;
        keyTypes.put(name, l);
        keyTypes.put(name.toUpperCase(Locale.ENGLISH), l);
    }

    static long getKeyType(String algorithm) {
        Long l = keyTypes.get(algorithm);
        if (l == null && (l = keyTypes.get(algorithm = algorithm.toUpperCase(Locale.ENGLISH))) == null) {
            if (algorithm.startsWith("HMAC")) {
                return 2147483427L;
            }
            if (algorithm.startsWith("SSLMAC")) {
                return 2147483428L;
            }
        }
        return l != null ? l : -1L;
    }

    public static P11Key convertKey(Token token, Key key, String algo) throws InvalidKeyException {
        return P11SecretKeyFactory.convertKey(token, key, algo, null);
    }

    public static P11Key convertKey(Token token, Key key, String algo, CK_ATTRIBUTE[] extraAttrs) throws InvalidKeyException {
        P11Key p11Key;
        long algoType;
        token.ensureValid();
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key must be a SecretKey");
        }
        if (algo == null) {
            algo = key.getAlgorithm();
            algoType = P11SecretKeyFactory.getKeyType(algo);
        } else {
            long keyAlgorithmType;
            algoType = P11SecretKeyFactory.getKeyType(algo);
            if (algoType != (keyAlgorithmType = P11SecretKeyFactory.getKeyType(key.getAlgorithm())) && algoType != 2147483427L && algoType != 2147483428L) {
                throw new InvalidKeyException("Key algorithm must be " + algo);
            }
        }
        if (key instanceof P11Key) {
            P11Key p11Key2 = (P11Key)key;
            if (p11Key2.token == token) {
                if (extraAttrs != null) {
                    Session session = null;
                    try {
                        session = token.getObjSession();
                        long newKeyID = token.p11.C_CopyObject(session.id(), p11Key2.keyID, extraAttrs);
                        p11Key2 = (P11Key)((Object)P11Key.secretKey(session, newKeyID, p11Key2.algorithm, p11Key2.keyLength, extraAttrs));
                    }
                    catch (PKCS11Exception p11e) {
                        throw new InvalidKeyException("Cannot duplicate the PKCS11 key", p11e);
                    }
                    finally {
                        token.releaseSession(session);
                    }
                }
                return p11Key2;
            }
        }
        if ((p11Key = token.secretCache.get(key)) != null) {
            return p11Key;
        }
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Encoded format must be RAW");
        }
        byte[] encoded = key.getEncoded();
        p11Key = P11SecretKeyFactory.createKey(token, encoded, algo, algoType, extraAttrs);
        token.secretCache.put(key, p11Key);
        return p11Key;
    }

    static void fixDESParity(byte[] key, int offset) {
        for (int i = 0; i < 8; ++i) {
            int b = key[offset] & 0xFE;
            b |= Integer.bitCount(b) & 1 ^ 1;
            key[offset++] = (byte)b;
        }
    }

    private static P11Key createKey(Token token, byte[] encoded, String algorithm, long keyType, CK_ATTRIBUTE[] extraAttrs) throws InvalidKeyException {
        P11Key p11Key;
        int n;
        int keyLength = n = encoded.length << 3;
        try {
            switch ((int)keyType) {
                case 19: {
                    keyLength = P11KeyGenerator.checkKeySize(288L, n, token);
                    P11SecretKeyFactory.fixDESParity(encoded, 0);
                    break;
                }
                case 21: {
                    keyLength = P11KeyGenerator.checkKeySize(305L, n, token);
                    P11SecretKeyFactory.fixDESParity(encoded, 0);
                    P11SecretKeyFactory.fixDESParity(encoded, 8);
                    if (keyLength == 112) {
                        keyType = 20L;
                        break;
                    }
                    keyType = 21L;
                    P11SecretKeyFactory.fixDESParity(encoded, 16);
                    break;
                }
                case 31: {
                    keyLength = P11KeyGenerator.checkKeySize(4224L, n, token);
                    break;
                }
                case 18: {
                    keyLength = P11KeyGenerator.checkKeySize(272L, n, token);
                    break;
                }
                case 32: {
                    keyLength = P11KeyGenerator.checkKeySize(4240L, n, token);
                    break;
                }
                case -2147483645: {
                    keyLength = P11KeyGenerator.checkKeySize(2147512321L, n, token);
                    break;
                }
                case -2147483642: {
                    keyLength = P11KeyGenerator.checkKeySize(2147524609L, n, token);
                    break;
                }
                case 16: 
                case 2147483429: 
                case 2147483430: 
                case 0x7FFFFF27: {
                    keyType = 16L;
                    break;
                }
                case 2147483427: 
                case 2147483428: {
                    if (n == 0) {
                        throw new InvalidKeyException("MAC keys must not be empty");
                    }
                    keyType = 16L;
                    break;
                }
                default: {
                    throw new InvalidKeyException("Unknown algorithm " + algorithm);
                }
            }
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidKeyException("Invalid key for " + algorithm, iape);
        }
        catch (ProviderException pe) {
            throw new InvalidKeyException("Could not create key", pe);
        }
        Session session = null;
        try {
            P11Key p11Key2;
            CK_ATTRIBUTE[] attributes;
            if (extraAttrs != null) {
                attributes = new CK_ATTRIBUTE[3 + extraAttrs.length];
                System.arraycopy(extraAttrs, 0, attributes, 3, extraAttrs.length);
            } else {
                attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, keyType), new CK_ATTRIBUTE(17L, encoded)};
            }
            attributes = token.getAttributes("import", 4L, keyType, attributes);
            session = token.getObjSession();
            long keyID = token.p11.C_CreateObject(session.id(), attributes);
            p11Key = p11Key2 = (P11Key)((Object)P11Key.secretKey(session, keyID, algorithm, keyLength, attributes));
            token.releaseSession(session);
        }
        catch (PKCS11Exception e) {
            try {
                throw new InvalidKeyException("Could not create key", e);
            }
            catch (Throwable throwable) {
                token.releaseSession(session);
                throw throwable;
            }
        }
        return p11Key;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec == null) {
            throw new InvalidKeySpecException("KeySpec must not be null");
        }
        if (keySpec instanceof SecretKeySpec) {
            try {
                P11Key key = P11SecretKeyFactory.convertKey(this.token, (SecretKey)((Object)keySpec), this.algorithm);
                return (SecretKey)((Object)key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        if (this.algorithm.equalsIgnoreCase("DES")) {
            if (keySpec instanceof DESKeySpec) {
                byte[] keyBytes = ((DESKeySpec)keySpec).getKey();
                keySpec = new SecretKeySpec(keyBytes, "DES");
                return this.engineGenerateSecret(keySpec);
            }
        } else if (this.algorithm.equalsIgnoreCase("DESede") && keySpec instanceof DESedeKeySpec) {
            byte[] keyBytes = ((DESedeKeySpec)keySpec).getKey();
            keySpec = new SecretKeySpec(keyBytes, "DESede");
            return this.engineGenerateSecret(keySpec);
        }
        throw new InvalidKeySpecException("Unsupported spec: " + keySpec.getClass().getName());
    }

    private byte[] getKeyBytes(SecretKey key) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
            if (!"RAW".equalsIgnoreCase(key.getFormat())) {
                throw new InvalidKeySpecException("Could not obtain key bytes");
            }
            byte[] k = key.getEncoded();
            return k;
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        block10: {
            this.token.ensureValid();
            if (key == null || keySpec == null) {
                throw new InvalidKeySpecException("key and keySpec must not be null");
            }
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(this.getKeyBytes(key), this.algorithm);
            }
            if (this.algorithm.equalsIgnoreCase("DES")) {
                try {
                    if (DESKeySpec.class.isAssignableFrom(keySpec)) {
                        return new DESKeySpec(this.getKeyBytes(key));
                    }
                    break block10;
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            if (this.algorithm.equalsIgnoreCase("DESede")) {
                try {
                    if (DESedeKeySpec.class.isAssignableFrom(keySpec)) {
                        return new DESedeKeySpec(this.getKeyBytes(key));
                    }
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
        }
        throw new InvalidKeySpecException("Unsupported spec: " + keySpec.getName());
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        return (SecretKey)((Object)P11SecretKeyFactory.convertKey(this.token, key, this.algorithm));
    }

    static {
        P11SecretKeyFactory.addKeyType("RC4", 18L);
        P11SecretKeyFactory.addKeyType("ARCFOUR", 18L);
        P11SecretKeyFactory.addKeyType("DES", 19L);
        P11SecretKeyFactory.addKeyType("DESede", 21L);
        P11SecretKeyFactory.addKeyType("AES", 31L);
        P11SecretKeyFactory.addKeyType("SM4", 0x80000006L);
        P11SecretKeyFactory.addKeyType("SM1", 0x80000003L);
        P11SecretKeyFactory.addKeyType("Blowfish", 32L);
        P11SecretKeyFactory.addKeyType("RC2", 17L);
        P11SecretKeyFactory.addKeyType("IDEA", 26L);
        P11SecretKeyFactory.addKeyType("TlsPremasterSecret", 2147483429L);
        P11SecretKeyFactory.addKeyType("TlsRsaPremasterSecret", 2147483430L);
        P11SecretKeyFactory.addKeyType("TlsMasterSecret", 0x7FFFFF27L);
        P11SecretKeyFactory.addKeyType("Generic", 16L);
    }
}

