/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;

public final class P11Util {
    public static final long NULLSESSION = -1L;
    private static Object LOCK = new Object();
    private static volatile Provider topSMProvider;
    private static final char[] hexDigits;

    private P11Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getProvider(Provider p, String providerName, String className) {
        if (p != null) {
            return p;
        }
        p = Security.getProvider(providerName);
        if (p == null) {
            Object object = LOCK;
            synchronized (object) {
                try {
                    Class<?> clazz = Class.forName(className);
                    p = (Provider)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new ProviderException("Could not find provider " + providerName);
                }
            }
        }
        return p;
    }

    static byte[] convert(byte[] input, int offset, int len) {
        if (offset == 0 && len == input.length) {
            return input;
        }
        byte[] t = new byte[len];
        System.arraycopy(input, offset, t, 0, len);
        return t;
    }

    static byte[] subarray(byte[] b, int ofs, int len) {
        byte[] out = new byte[len];
        System.arraycopy(b, ofs, out, 0, len);
        return out;
    }

    static byte[] concat(byte[] b1, byte[] b2) {
        byte[] b = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, b, 0, b1.length);
        System.arraycopy(b2, 0, b, b1.length, b2.length);
        return b;
    }

    static long[] concat(long[] b1, long[] b2) {
        if (b1.length == 0) {
            return b2;
        }
        long[] b = new long[b1.length + b2.length];
        System.arraycopy(b1, 0, b, 0, b1.length);
        System.arraycopy(b2, 0, b, b1.length, b2.length);
        return b;
    }

    static byte[] trimZeroes(byte[] b) {
        int i;
        for (i = 0; i < b.length - 1 && b[i] == 0; ++i) {
        }
        if (i == 0) {
            return b;
        }
        byte[] t = new byte[b.length - i];
        System.arraycopy(b, i, t, 0, t.length);
        return t;
    }

    public static byte[] getMagnitude(BigInteger bi) {
        byte[] b = bi.toByteArray();
        if (b.length > 1 && b[0] == 0) {
            int n = b.length - 1;
            byte[] newarray = new byte[n];
            System.arraycopy(b, 1, newarray, 0, n);
            b = newarray;
        }
        return b;
    }

    static byte[] getBytesUTF8(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] sha1(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(data);
            return md.digest();
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e.getMessage());
        }
    }

    static String toString(byte[] b) {
        if (b == null) {
            return "(null)";
        }
        StringBuffer sb = new StringBuffer(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            int k = b[i] & 0xFF;
            if (i != 0) {
                sb.append(':');
            }
            sb.append(hexDigits[k >>> 4]);
            sb.append(hexDigits[k & 0xF]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Provider getTopSMProvider() {
        Provider p = topSMProvider;
        if (p == null) {
            Object object = LOCK;
            synchronized (object) {
                topSMProvider = p = P11Util.getProvider(topSMProvider, "TopSM", "cn.topca.security.sm.TopSMProvider");
            }
        }
        return p;
    }

    static {
        hexDigits = "0123456789abcdef".toCharArray();
    }
}

