/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11.jna;

import cn.topca.security.pkcs11.P11Util;
import cn.topca.security.pkcs11.jna.Functions;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.NativeLongByReference;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class CK_ATTRIBUTE
extends Structure {
    public static final CK_ATTRIBUTE TOKEN_FALSE = new CK_ATTRIBUTE(1L, false);
    public static final CK_ATTRIBUTE SENSITIVE_FALSE = new CK_ATTRIBUTE(259L, false);
    public static final CK_ATTRIBUTE EXTRACTABLE_TRUE = new CK_ATTRIBUTE(354L, true);
    public static final CK_ATTRIBUTE ENCRYPT_TRUE = new CK_ATTRIBUTE(260L, true);
    public static final CK_ATTRIBUTE DECRYPT_TRUE = new CK_ATTRIBUTE(261L, true);
    public static final CK_ATTRIBUTE WRAP_TRUE = new CK_ATTRIBUTE(262L, true);
    public static final CK_ATTRIBUTE UNWRAP_TRUE = new CK_ATTRIBUTE(263L, true);
    public static final CK_ATTRIBUTE SIGN_TRUE = new CK_ATTRIBUTE(264L, true);
    public static final CK_ATTRIBUTE VERIFY_TRUE = new CK_ATTRIBUTE(266L, true);
    public static final CK_ATTRIBUTE SIGN_RECOVER_TRUE = new CK_ATTRIBUTE(265L, true);
    public static final CK_ATTRIBUTE VERIFY_RECOVER_TRUE = new CK_ATTRIBUTE(267L, true);
    public static final CK_ATTRIBUTE DERIVE_TRUE = new CK_ATTRIBUTE(268L, true);
    public static final CK_ATTRIBUTE ENCRYPT_NULL = new CK_ATTRIBUTE(260L);
    public static final CK_ATTRIBUTE DECRYPT_NULL = new CK_ATTRIBUTE(261L);
    public static final CK_ATTRIBUTE WRAP_NULL = new CK_ATTRIBUTE(262L);
    public static final CK_ATTRIBUTE UNWRAP_NULL = new CK_ATTRIBUTE(263L);
    public static final CK_ATTRIBUTE ATTR_CLASS_CERT = new CK_ATTRIBUTE(0L, 1L);
    public static final CK_ATTRIBUTE ATTR_CLASS_PKEY = new CK_ATTRIBUTE(0L, 3L);
    public static final CK_ATTRIBUTE ATTR_CLASS_PUBLICKEY = new CK_ATTRIBUTE(0L, 2L);
    public static final CK_ATTRIBUTE ATTR_CLASS_SKEY = new CK_ATTRIBUTE(0L, 4L);
    public static final CK_ATTRIBUTE ATTR_X509_CERT_TYPE = new CK_ATTRIBUTE(128L, 0L);
    public static final CK_ATTRIBUTE ATTR_TOKEN_TRUE = new CK_ATTRIBUTE(1L, true);
    public static final CK_ATTRIBUTE ATTR_TOKEN_FALSE = new CK_ATTRIBUTE(1L, false);
    public static final CK_ATTRIBUTE ATTR_TRUSTED_TRUE = new CK_ATTRIBUTE(134L, true);
    public static final CK_ATTRIBUTE ATTR_PRIVATE_TRUE = new CK_ATTRIBUTE(2L, true);
    public NativeLong type;
    public Pointer pValue;
    public NativeLong ulValueLen;

    public CK_ATTRIBUTE() {
    }

    protected List getFieldOrder() {
        return Arrays.asList("type", "pValue", "ulValueLen");
    }

    public CK_ATTRIBUTE(long type) {
        if (this.type == null) {
            this.type = new NativeLong(0L);
        }
        this.type.setValue(type);
    }

    public CK_ATTRIBUTE(long type, boolean value) {
        this.type.setValue(type);
        this.pValue = new Memory(1L);
        this.pValue.setByte(0L, (byte)(value ? 1 : 0));
        this.ulValueLen.setValue(1L);
    }

    public CK_ATTRIBUTE(long type, long value) {
        this.type.setValue(type);
        this.pValue = new NativeLongByReference(new NativeLong(value)).getPointer();
        this.ulValueLen.setValue((long)NativeLong.SIZE);
    }

    public CK_ATTRIBUTE(long type, BigInteger value) {
        this.type.setValue(type);
        byte[] dataBytes = P11Util.getMagnitude(value);
        this.pValue = new Memory((long)dataBytes.length);
        this.pValue.write(0L, dataBytes, 0, dataBytes.length);
        this.ulValueLen.setValue((long)dataBytes.length);
    }

    public CK_ATTRIBUTE(long type, byte[] value) {
        this.type.setValue(type);
        this.pValue = new Memory((long)value.length);
        this.pValue.write(0L, value, 0, value.length);
        this.ulValueLen.setValue((long)value.length);
    }

    public CK_ATTRIBUTE(long type, String value) {
        this.type.setValue(type);
        byte[] dataBytes = Functions.jCharArrayToCKCharArray(value.toCharArray());
        this.pValue = new Memory((long)dataBytes.length);
        this.pValue.write(0L, dataBytes, 0, dataBytes.length);
        this.ulValueLen.setValue((long)dataBytes.length);
    }

    public BigInteger getBigInteger() {
        if (this.pValue == null) {
            return null;
        }
        return new BigInteger(1, this.getByteArray());
    }

    public boolean getBoolean() {
        return this.pValue.getByte(0L) != 0;
    }

    public char[] getCharArray() {
        if (this.pValue == null) {
            return null;
        }
        return Functions.ckCharArrayTojCharArray(this.getByteArray());
    }

    public byte[] getByteArray() {
        if (this.pValue == null) {
            return null;
        }
        return this.pValue.getByteArray(0L, this.ulValueLen.intValue());
    }

    public long getLong() {
        try {
            if (this.pValue == null) {
                return 0L;
            }
            return Functions.ckUlongTojLong(this.pValue.getNativeLong(0L));
        }
        catch (Exception e) {
            return Functions.ckUlongTojLong(new NativeLong((long)this.pValue.getInt(0L)));
        }
    }

    public String toString() {
        String prefix = Functions.getAttributeName(Functions.ckUlongTojLong(this.type)) + " = ";
        if (Functions.ckUlongTojLong(this.type) == 0L) {
            return prefix + Functions.getObjectClassName(this.getLong());
        }
        if (Functions.ckUlongTojLong(this.type) == 256L) {
            return prefix + Functions.getKeyName(this.getLong());
        }
        if (this.pValue == null) {
            return prefix + " null";
        }
        return prefix + Functions.toHexString(this.pValue.getByteArray(0L, (int)Functions.ckUlongTojLong(this.ulValueLen)));
    }
}

