/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11.jna;

import cn.topca.security.pkcs11.jna.CK_VERSION;
import cn.topca.security.pkcs11.jna.Constants;
import cn.topca.security.pkcs11.jna.Functions;
import cn.topca.security.pkcs11.jna.ItrusStructure;
import com.sun.jna.NativeLong;
import java.io.UnsupportedEncodingException;

public class CK_TOKEN_INFO
extends ItrusStructure {
    public byte[] label = new byte[32];
    public byte[] manufacturerID = new byte[32];
    public byte[] model = new byte[16];
    public byte[] serialNumber = new byte[16];
    public NativeLong flags;
    public NativeLong ulMaxSessionCount;
    public NativeLong ulSessionCount;
    public NativeLong ulMaxRwSessionCount;
    public NativeLong ulRwSessionCount;
    public NativeLong ulMaxPinLen;
    public NativeLong ulMinPinLen;
    public NativeLong ulTotalPublicMemory;
    public NativeLong ulFreePublicMemory;
    public NativeLong ulTotalPrivateMemory;
    public NativeLong ulFreePrivateMemory;
    public CK_VERSION hardwareVersion;
    public CK_VERSION firmwareVersion;
    public byte[] utcTime = new byte[16];

    public CK_TOKEN_INFO(char[] label, char[] vendor, char[] model, char[] serialNo, long flags, long sessionMax, long session, long rwSessionMax, long rwSession, long pinLenMax, long pinLenMin, long totalPubMem, long freePubMem, long totalPrivMem, long freePrivMem, CK_VERSION hwVer, CK_VERSION fwVer, char[] utcTime) {
        this.label = Functions.jCharArrayToCKCharArray(label, this.label.length);
        this.manufacturerID = Functions.jCharArrayToCKCharArray(vendor, this.manufacturerID.length);
        this.model = Functions.jCharArrayToCKCharArray(model, this.model.length);
        this.serialNumber = Functions.jCharArrayToCKCharArray(serialNo, this.serialNumber.length);
        this.flags = Functions.jLongToCKULong(flags);
        this.ulMaxSessionCount = Functions.jLongToCKULong(sessionMax);
        this.ulSessionCount = Functions.jLongToCKULong(session);
        this.ulMaxRwSessionCount = Functions.jLongToCKULong(rwSessionMax);
        this.ulRwSessionCount = Functions.jLongToCKULong(rwSession);
        this.ulMaxPinLen = Functions.jLongToCKULong(pinLenMax);
        this.ulMinPinLen = Functions.jLongToCKULong(pinLenMin);
        this.ulTotalPublicMemory = Functions.jLongToCKULong(totalPubMem);
        this.ulFreePublicMemory = Functions.jLongToCKULong(freePubMem);
        this.ulTotalPrivateMemory = Functions.jLongToCKULong(totalPrivMem);
        this.ulFreePrivateMemory = Functions.jLongToCKULong(freePrivMem);
        this.hardwareVersion = hwVer;
        this.firmwareVersion = fwVer;
        this.utcTime = Functions.jCharArrayToCKCharArray(utcTime, this.utcTime.length);
    }

    public CK_TOKEN_INFO() {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  ");
        buffer.append("label: ");
        try {
            buffer.append(new String(this.label, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            buffer.append("0h" + Functions.toHexString(this.label));
            e.printStackTrace();
        }
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("manufacturerID: ");
        try {
            buffer.append(new String(this.manufacturerID, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            buffer.append("0h" + Functions.toHexString(this.manufacturerID));
            e.printStackTrace();
        }
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("model: ");
        try {
            buffer.append(new String(this.model, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            buffer.append("0h" + Functions.toHexString(this.model));
            e.printStackTrace();
        }
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("serialNumber: ");
        try {
            buffer.append(new String(this.serialNumber, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            buffer.append("0h" + Functions.toHexString(this.serialNumber));
            e.printStackTrace();
        }
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("flags: ");
        buffer.append(Functions.tokenInfoFlagsToString(Functions.ckUlongTojLong(this.flags)));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulMaxSessionCount: ");
        buffer.append(Functions.ckUlongTojLong(this.ulMaxSessionCount) == 0L ? "CK_EFFECTIVELY_INFINITE" : (Functions.ckUlongTojLong(this.ulMaxSessionCount) == -1L ? "CK_UNAVAILABLE_INFORMATION" : String.valueOf(this.ulMaxSessionCount)));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulSessionCount: ");
        buffer.append(Functions.ckUlongTojLong(this.ulSessionCount) == -1L ? "CK_UNAVAILABLE_INFORMATION" : String.valueOf(this.ulSessionCount));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulMaxRwSessionCount: ");
        buffer.append(Functions.ckUlongTojLong(this.ulMaxRwSessionCount) == 0L ? "CK_EFFECTIVELY_INFINITE" : (Functions.ckUlongTojLong(this.ulMaxRwSessionCount) == -1L ? "CK_UNAVAILABLE_INFORMATION" : String.valueOf(this.ulMaxRwSessionCount)));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulRwSessionCount: ");
        buffer.append(Functions.ckUlongTojLong(this.ulRwSessionCount) == -1L ? "CK_UNAVAILABLE_INFORMATION" : String.valueOf(this.ulRwSessionCount));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulMaxPinLen: ");
        buffer.append(String.valueOf(this.ulMaxPinLen));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulMinPinLen: ");
        buffer.append(String.valueOf(this.ulMinPinLen));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulTotalPublicMemory: ");
        buffer.append(Functions.ckUlongTojLong(this.ulTotalPublicMemory) == -1L ? "CK_UNAVAILABLE_INFORMATION" : String.valueOf(this.ulTotalPublicMemory));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulFreePublicMemory: ");
        buffer.append(Functions.ckUlongTojLong(this.ulFreePublicMemory) == -1L ? "CK_UNAVAILABLE_INFORMATION" : String.valueOf(this.ulFreePublicMemory));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulTotalPrivateMemory: ");
        buffer.append(Functions.ckUlongTojLong(this.ulTotalPrivateMemory) == -1L ? "CK_UNAVAILABLE_INFORMATION" : String.valueOf(this.ulTotalPrivateMemory));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulFreePrivateMemory: ");
        buffer.append(Functions.ckUlongTojLong(this.ulFreePrivateMemory) == -1L ? "CK_UNAVAILABLE_INFORMATION" : String.valueOf(this.ulFreePrivateMemory));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("hardwareVersion: ");
        buffer.append(this.hardwareVersion.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("firmwareVersion: ");
        buffer.append(this.firmwareVersion.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("utcTime: ");
        try {
            buffer.append(new String(this.utcTime, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            buffer.append("0h" + Functions.toHexString(this.utcTime));
            e.printStackTrace();
        }
        return buffer.toString();
    }
}

