/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11.jna;

import cn.topca.commons.TopSystem;
import cn.topca.security.pkcs11.jna.CK_ATTRIBUTE;
import cn.topca.security.pkcs11.jna.CK_C_INITIALIZE_ARGS;
import cn.topca.security.pkcs11.jna.CK_FUNCTION_LIST;
import cn.topca.security.pkcs11.jna.CK_INFO;
import cn.topca.security.pkcs11.jna.CK_MECHANISM;
import cn.topca.security.pkcs11.jna.CK_MECHANISM_INFO;
import cn.topca.security.pkcs11.jna.CK_NOTIFY;
import cn.topca.security.pkcs11.jna.CK_SESSION_INFO;
import cn.topca.security.pkcs11.jna.CK_SLOT_INFO;
import cn.topca.security.pkcs11.jna.CK_TOKEN_INFO;
import cn.topca.security.pkcs11.jna.Functions;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PKCS11 {
    private static final long[] LONG0 = new long[0];
    private static final Log log = LogFactory.getLog((String)"TopP11-PKCS11");
    private static final Map<String, PKCS11> moduleMap = new HashMap<String, PKCS11>();
    private final String pkcs11Module;
    private final ModuleData pNativeData;
    private static final int MAX_DIGEST_LEN = 64;
    public static final String DEFAULT_FUNCTION_LIST_NAME = "C_GetFunctionList";

    public static void loadNative() {
    }

    PKCS11(String pkcs11Module, String[] searchPaths, String functionListName) throws IOException {
        try {
            this.pNativeData = this.connect(pkcs11Module, searchPaths, functionListName);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.pkcs11Module = pkcs11Module;
    }

    public static synchronized PKCS11 getInstance(String pkcs11Module, String functionListName, CK_C_INITIALIZE_ARGS pInitArgs, boolean omitInitialize) throws IOException, PKCS11Exception {
        return PKCS11.getInstance(pkcs11Module, null, functionListName, pInitArgs, omitInitialize);
    }

    public static synchronized PKCS11 getInstance(String pkcs11Module, String[] searchPaths, String functionListName, CK_C_INITIALIZE_ARGS pInitArgs, boolean omitInitialize) throws IOException, PKCS11Exception {
        PKCS11 pkcs11 = moduleMap.get(pkcs11Module);
        if (pkcs11 == null) {
            block4: {
                pkcs11 = pInitArgs != null && (Functions.ckUlongTojLong(pInitArgs.flags) & 2L) != 0L ? new PKCS11(pkcs11Module, searchPaths, functionListName) : new PKCS11(pkcs11Module, searchPaths, functionListName);
                if (!omitInitialize) {
                    try {
                        pkcs11.C_Initialize((Object)pInitArgs);
                    }
                    catch (PKCS11Exception e) {
                        if (e.getErrorCode() == 401L) break block4;
                        throw e;
                    }
                }
            }
            moduleMap.put(pkcs11Module, pkcs11);
        }
        return pkcs11;
    }

    private ModuleData connect(String pkcs11Module, String[] searchPaths, String functionListName) throws IOException {
        ModuleData moduleData;
        try {
            File libFile = new File(pkcs11Module);
            libFile = libFile.getCanonicalFile();
            log.debug((Object)("java.library.path:" + System.getProperty("java.library.path")));
            log.debug((Object)("jni.library.path:" + System.getenv("jni.library.path")));
            NativeLibrary.addSearchPath((String)libFile.getName(), (String)libFile.getParent());
            log.debug((Object)("Added search path " + libFile.getParent()));
            if (searchPaths != null && searchPaths.length > 0) {
                for (String searchPath : searchPaths) {
                    searchPath = new File(searchPath).getAbsolutePath();
                    NativeLibrary.addSearchPath((String)libFile.getName(), (String)searchPath);
                    log.debug((Object)("Added search path " + searchPath));
                }
            }
            NativeLibrary hModule = NativeLibrary.getInstance((String)libFile.getName());
            log.info((Object)("Connects PKCS#11 library " + hModule.getName()));
            log.info((Object)("PKCS#11 library file " + hModule.getFile().getAbsolutePath()));
            Function CK_C_GetFunctionList2 = hModule.getFunction(functionListName);
            PointerByReference pFunctionList = new PointerByReference();
            NativeLong rv = (NativeLong)CK_C_GetFunctionList2.invoke(NativeLong.class, new Object[]{pFunctionList});
            this.ckAssertReturnValueOK(rv);
            log.info((Object)("OS is " + TopSystem.OS_NAME));
            CK_FUNCTION_LIST C_GetFunctionList = TopSystem.OS_NAME.matches("[W|w]indows.*") ? new CK_FUNCTION_LIST(pFunctionList.getValue()) : new CK_FUNCTION_LIST(pFunctionList.getValue(), 0);
            log.debug((Object)("C_GetFunctionList: " + (Object)((Object)C_GetFunctionList)));
            moduleData = new ModuleData(hModule, C_GetFunctionList, null);
            log.debug((Object)("connect " + hModule.getName() + " success!"));
        }
        catch (Throwable e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return moduleData;
    }

    public CK_FUNCTION_LIST C_GetFunctionList(String pkcs11Module, String functionListName) throws Exception {
        return this.getFunctionList();
    }

    private void disconnect() {
        this.pNativeData.hModule.dispose();
    }

    /*
     * Enabled aggressive block sorting
     */
    void C_Initialize(Object pInitArgs) throws PKCS11Exception {
        CK_C_INITIALIZE_ARGS ckpInitArgs;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        if (pInitArgs != null) {
            if (!(pInitArgs instanceof CK_C_INITIALIZE_ARGS)) {
                log.error((Object)"pInitArgs must be the CK_C_INITIALIZE_ARGS objcet");
                throw new PKCS11Exception(7L);
            }
            ckpInitArgs = (CK_C_INITIALIZE_ARGS)((Object)pInitArgs);
        } else {
            ckpInitArgs = null;
        }
        log.debug((Object)("C_Initialize invoke,args:" + (Object)((Object)ckpInitArgs)));
        NativeLong rv = ckpFunctions.C_Initialize(ckpInitArgs);
        log.debug((Object)"C_Initialize invoke success!");
        this.free((Object)ckpInitArgs);
        log.debug((Object)("free args:" + (Object)((Object)ckpInitArgs)));
        ckpInitArgs = null;
        this.ckAssertReturnValue(rv, 401L);
    }

    public void C_Finalize(Object pReserved) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        if (pReserved != null) {
            throw new RuntimeException("pReserved is reserved. Should be null");
        }
        Pointer ckpReserved = null;
        NativeLong rv = ckpFunctions.C_Finalize(ckpReserved);
        this.ckAssertReturnValueOK(rv);
    }

    public CK_INFO C_GetInfo() throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        CK_INFO ckLibInfo = new CK_INFO();
        NativeLong rv = ckpFunctions.C_GetInfo(ckLibInfo);
        this.ckAssertReturnValueOK(rv);
        return ckLibInfo;
    }

    public long[] C_GetSlotList(boolean tokenPresent) throws PKCS11Exception {
        long[] jSlotList = null;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        byte ckTokenPresent = Functions.jBooleanToCKBBool(tokenPresent);
        NativeLongByReference ckTokenCountRef = new NativeLongByReference();
        NativeLong rv = ckpFunctions.C_GetSlotList(ckTokenPresent, null, ckTokenCountRef);
        this.ckAssertReturnValueOK(rv);
        NativeLong ckTokenCount = ckTokenCountRef.getValue();
        if (Functions.ckUlongTojLong(ckTokenCount) > 0L) {
            NativeLong[] ckpSlotList = new NativeLong[(int)Functions.ckUlongTojLong(ckTokenCount)];
            rv = ckpFunctions.C_GetSlotList(ckTokenPresent, ckpSlotList, ckTokenCountRef);
            this.ckAssertReturnValueOK(rv);
            jSlotList = Functions.ckULongArrayToJLongArray(ckpSlotList);
        } else {
            jSlotList = new long[]{};
        }
        return jSlotList;
    }

    public CK_SLOT_INFO C_GetSlotInfo(long slotID) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSlotID = Functions.jLongToCKULong(slotID);
        CK_SLOT_INFO ckSlotInfo = new CK_SLOT_INFO();
        NativeLong rv = ckpFunctions.C_GetSlotInfo(ckSlotID, ckSlotInfo);
        this.ckAssertReturnValueOK(rv);
        return ckSlotInfo;
    }

    public CK_TOKEN_INFO C_GetTokenInfo(long slotID) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSlotID = Functions.jLongToCKULong(slotID);
        CK_TOKEN_INFO ckTokenInfo = new CK_TOKEN_INFO();
        NativeLong rv = ckpFunctions.C_GetTokenInfo(ckSlotID, ckTokenInfo);
        this.ckAssertReturnValueOK(rv);
        return ckTokenInfo;
    }

    public long[] C_GetMechanismList(long slotID) throws PKCS11Exception {
        NativeLong ckSlotID = null;
        NativeLong ckulCount = null;
        NativeLong[] ckpMechanismList = null;
        long[] jMechanismList = null;
        CK_FUNCTION_LIST ckpFunctions = null;
        ckpFunctions = this.getFunctionList();
        ckSlotID = Functions.jLongToCKULong(slotID);
        NativeLongByReference ckMechanismNumberRef = new NativeLongByReference();
        NativeLong rv = ckpFunctions.C_GetMechanismList(ckSlotID, null, ckMechanismNumberRef);
        this.ckAssertReturnValueOK(rv);
        ckulCount = ckMechanismNumberRef.getValue();
        if (Functions.ckUlongTojLong(ckulCount) > 0L) {
            ckpMechanismList = new NativeLong[(int)Functions.ckUlongTojLong(ckulCount)];
            rv = ckpFunctions.C_GetMechanismList(ckSlotID, ckpMechanismList, ckMechanismNumberRef);
            jMechanismList = Functions.ckULongArrayToJLongArray(ckpMechanismList, (int)Functions.ckUlongTojLong(ckulCount));
            this.free((T[])ckpMechanismList);
            ckpMechanismList = null;
            this.ckAssertReturnValueOK(rv);
        } else {
            jMechanismList = LONG0;
        }
        return jMechanismList;
    }

    public CK_MECHANISM_INFO C_GetMechanismInfo(long slotID, long type) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSlotID = Functions.jLongToCKULong(slotID);
        NativeLong ckMechanismType = Functions.jLongToCKULong(type);
        CK_MECHANISM_INFO ckMechanismInfo = new CK_MECHANISM_INFO();
        NativeLong rv = ckpFunctions.C_GetMechanismInfo(ckSlotID, ckMechanismType, ckMechanismInfo);
        this.ckAssertReturnValueOK(rv);
        return ckMechanismInfo;
    }

    public void C_InitToken(long slotID, char[] pPin, char[] pLabel) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSlotID = Functions.jLongToCKULong(slotID);
        byte[] buffer = Functions.jCharArrayToCKCharArray(pPin);
        int bufferLen = buffer.length;
        Memory pBuf = new Memory((long)bufferLen);
        pBuf.write(0L, buffer, 0, bufferLen);
        Memory ckpPin = pBuf;
        NativeLong ckPinLength = Functions.jLongToCKULong(bufferLen);
        buffer = null;
        bufferLen = 0;
        this.free(pBuf);
        pBuf = null;
        buffer = Functions.jCharArrayToCKCharArray(pLabel, 32);
        bufferLen = buffer.length;
        pBuf = new Memory((long)bufferLen);
        pBuf.write(0L, buffer, 0, bufferLen);
        Memory ckpLabel = pBuf;
        buffer = null;
        bufferLen = 0;
        this.free(pBuf);
        pBuf = null;
        NativeLong rv = ckpFunctions.C_InitToken(ckSlotID, (Pointer)ckpPin, ckPinLength, (Pointer)ckpLabel);
        this.free(ckpPin);
        ckpPin = null;
        this.free(ckpLabel);
        ckpLabel = null;
        this.ckAssertReturnValueOK(rv);
    }

    public void C_InitPIN(long hSession, char[] pPin) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        byte[] buffer = Functions.jCharArrayToCKCharArray(pPin);
        int bufferLen = buffer.length;
        Memory pBuf = new Memory((long)bufferLen);
        pBuf.write(0L, buffer, 0, bufferLen);
        Memory ckpPin = pBuf;
        NativeLong ckPinLength = Functions.jLongToCKULong(bufferLen);
        buffer = null;
        bufferLen = 0;
        this.free(pBuf);
        pBuf = null;
        NativeLong rv = ckpFunctions.C_InitPIN(ckSessionHandle, (Pointer)ckpPin, ckPinLength);
        this.free(ckpPin);
        ckpPin = null;
        this.ckAssertReturnValueOK(rv);
    }

    public void C_SetPIN(long hSession, char[] pOldPin, char[] pNewPin) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        byte[] buffer = Functions.jCharArrayToCKCharArray(pOldPin);
        int bufferLen = buffer.length;
        Memory pBuf = new Memory((long)bufferLen);
        pBuf.write(0L, buffer, 0, bufferLen);
        Memory ckpOldPin = pBuf;
        NativeLong ckOldPinLength = Functions.jLongToCKULong(bufferLen);
        buffer = null;
        bufferLen = 0;
        this.free(pBuf);
        pBuf = null;
        buffer = Functions.jCharArrayToCKCharArray(pNewPin);
        bufferLen = buffer.length;
        pBuf = new Memory((long)bufferLen);
        pBuf.write(0L, buffer, 0, bufferLen);
        Memory ckpNewPin = pBuf;
        NativeLong ckNewPinLength = Functions.jLongToCKULong(bufferLen);
        buffer = null;
        bufferLen = 0;
        this.free(pBuf);
        pBuf = null;
        NativeLong rv = ckpFunctions.C_SetPIN(ckSessionHandle, (Pointer)ckpOldPin, ckOldPinLength, (Pointer)ckpNewPin, ckNewPinLength);
        this.free(ckpOldPin);
        ckpOldPin = null;
        this.free(ckpNewPin);
        ckpNewPin = null;
        this.ckAssertReturnValueOK(rv);
    }

    public long C_OpenSession(long slotID, long flags, Object pApplication, CK_NOTIFY Notify) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSlotID = Functions.jLongToCKULong(slotID);
        NativeLong ckFlags = Functions.jLongToCKULong(flags);
        if (pApplication != null || Notify != null) {
            throw new PKCS11Exception(7L);
        }
        Pointer ckpApplication = null;
        CK_NOTIFY ckNotify = null;
        NativeLongByReference ckSessionHandleRef = new NativeLongByReference();
        NativeLong rv = ckpFunctions.C_OpenSession(ckSlotID, ckFlags, ckpApplication, ckNotify, ckSessionHandleRef);
        this.ckAssertReturnValueOK(rv);
        NativeLong ckSessionHandle = ckSessionHandleRef.getValue();
        long jSessionHandle = Functions.ckUlongTojLong(ckSessionHandle);
        return jSessionHandle;
    }

    public void C_CloseSession(long hSession) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong rv = ckpFunctions.C_CloseSession(ckSessionHandle);
        this.ckAssertReturnValueOK(rv);
    }

    public void C_CloseAllSessions(long slotID) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSlotID = Functions.jLongToCKULong(slotID);
        NativeLong rv = ckpFunctions.C_CloseAllSessions(ckSlotID);
        this.ckAssertReturnValueOK(rv);
    }

    public CK_SESSION_INFO C_GetSessionInfo(long hSession) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        CK_SESSION_INFO ckSessionInfo = new CK_SESSION_INFO();
        NativeLong rv = ckpFunctions.C_GetSessionInfo(ckSessionHandle, ckSessionInfo);
        this.ckAssertReturnValueOK(rv);
        CK_SESSION_INFO jSessionInfo = ckSessionInfo;
        return jSessionInfo;
    }

    public byte[] C_GetOperationState(long hSession) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLongByReference ckStateLengthRef = new NativeLongByReference();
        NativeLong rv = ckpFunctions.C_GetOperationState(ckSessionHandle, null, ckStateLengthRef);
        this.ckAssertReturnValueOK(rv);
        NativeLong ckStateLength = ckStateLengthRef.getValue();
        Memory ckpState = new Memory(Functions.ckUlongTojLong(ckStateLength));
        rv = ckpFunctions.C_GetOperationState(ckSessionHandle, (Pointer)ckpState, ckStateLengthRef);
        byte[] jState = ckpState.getByteArray(0L, (int)Functions.ckUlongTojLong(ckStateLength));
        this.free(ckpState);
        ckpState = null;
        this.ckAssertReturnValueOK(rv);
        return jState;
    }

    public void C_SetOperationState(long hSession, byte[] pOperationState, long hEncryptionKey, long hAuthenticationKey) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        int stateLen = pOperationState.length;
        Memory ckpState = new Memory((long)stateLen);
        ckpState.write(0L, pOperationState, 0, stateLen);
        NativeLong ckStateLength = Functions.jLongToCKULong(stateLen);
        NativeLong ckEncryptionKeyHandle = Functions.jLongToCKULong(hEncryptionKey);
        NativeLong ckAuthenticationKeyHandle = Functions.jLongToCKULong(hAuthenticationKey);
        NativeLong rv = ckpFunctions.C_SetOperationState(ckSessionHandle, (Pointer)ckpState, ckStateLength, ckEncryptionKeyHandle, ckAuthenticationKeyHandle);
        this.free(ckpState);
        ckpState = null;
        this.ckAssertReturnValueOK(rv);
    }

    public void C_Login(long hSession, long userType, char[] pPin) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckUserType = Functions.jLongToCKULong(userType);
        byte[] buffer = Functions.jCharArrayToCKCharArray(pPin);
        int bufferLen = buffer.length;
        Memory ckpPinArray = new Memory((long)(bufferLen + 1));
        ckpPinArray.write(0L, buffer, 0, bufferLen);
        ckpPinArray.setByte((long)bufferLen, (byte)0);
        NativeLong ckPinLength = Functions.jLongToCKULong(bufferLen);
        NativeLong rv = ckpFunctions.C_Login(ckSessionHandle, ckUserType, (Pointer)ckpPinArray, ckPinLength);
        this.free(ckpPinArray);
        ckpPinArray = null;
        this.ckAssertReturnValueOK(rv);
    }

    public void C_Logout(long hSession) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong rv = ckpFunctions.C_Logout(ckSessionHandle);
        this.ckAssertReturnValueOK(rv);
    }

    public long C_CreateObject(long hSession, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
        NativeLong rv;
        log.debug((Object)Arrays.toString((Object[])pTemplate));
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        CK_ATTRIBUTE[] ckpAttributes = Functions.jAttributeArrayToCKAttributeArray(pTemplate);
        NativeLong ckAttributesLength = Functions.jLongToCKULong(ckpAttributes.length);
        NativeLongByReference ckObjectHandleRef = new NativeLongByReference();
        try {
            rv = ckpFunctions.C_CreateObject(ckSessionHandle, ckpAttributes, ckAttributesLength, ckObjectHandleRef);
        }
        catch (Exception e) {
            e.printStackTrace();
            rv = new NativeLong(-1L);
        }
        NativeLong ckObjectHandle = ckObjectHandleRef.getValue();
        long jObjectHandle = Functions.ckUlongTojLong(ckObjectHandle);
        ckpAttributes = null;
        this.ckAssertReturnValueOK(rv);
        return jObjectHandle;
    }

    public long C_CopyObject(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckObjectHandle = Functions.jLongToCKULong(hObject);
        CK_ATTRIBUTE[] ckpAttributes = Functions.jAttributeArrayToCKAttributeArray(pTemplate);
        NativeLong ckAttributesLength = Functions.jLongToCKULong(ckpAttributes.length);
        NativeLongByReference ckNewObjectHandleRef = new NativeLongByReference();
        NativeLong rv = ckpFunctions.C_CopyObject(ckSessionHandle, ckObjectHandle, ckpAttributes, ckAttributesLength, ckNewObjectHandleRef);
        NativeLong ckNewObjectHandle = ckNewObjectHandleRef.getValue();
        long jNewObjectHandle = Functions.ckUlongTojLong(ckNewObjectHandle);
        ckpAttributes = null;
        this.ckAssertReturnValueOK(rv);
        return jNewObjectHandle;
    }

    public void C_DestroyObject(long hSession, long hObject) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckObjectHandle = Functions.jLongToCKULong(hObject);
        NativeLong rv = ckpFunctions.C_DestroyObject(ckSessionHandle, ckObjectHandle);
        this.ckAssertReturnValueOK(rv);
    }

    public long C_GetObjectSize(long hSession, long hObject) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckObjectHandle = Functions.jLongToCKULong(hObject);
        NativeLongByReference ckObjectSizeRef = new NativeLongByReference();
        NativeLong rv = ckpFunctions.C_GetObjectSize(ckSessionHandle, ckObjectHandle, ckObjectSizeRef);
        NativeLong ckObjectSize = ckObjectSizeRef.getValue();
        this.ckAssertReturnValueOK(rv);
        long jObjectSize = Functions.ckUlongTojLong(ckObjectSize);
        return jObjectSize;
    }

    public void C_GetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
        NativeLong ckBufferLength;
        int i;
        if (pTemplate != null) {
            for (int i2 = 0; i2 < pTemplate.length; ++i2) {
                CK_ATTRIBUTE attribute = pTemplate[i2];
                log.debug((Object)("GetAttribute\uff1a" + attribute.toString()));
            }
        }
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckObjectHandle = Functions.jLongToCKULong(hObject);
        CK_ATTRIBUTE[] ckpAttributes = Functions.jAttributeArrayToCKAttributeArray(pTemplate);
        NativeLong ckAttributesLength = Functions.jLongToCKULong(ckpAttributes.length);
        for (i = 0; i < (int)Functions.ckUlongTojLong(ckAttributesLength); ++i) {
            if (ckpAttributes[i].pValue == null) continue;
            this.free(ckpAttributes[i].pValue);
            ckpAttributes[i].pValue = null;
        }
        NativeLong rv = ckpFunctions.C_GetAttributeValue(ckSessionHandle, ckObjectHandle, ckpAttributes, ckAttributesLength);
        this.ckAssertReturnValueOK(rv);
        for (i = 0; i < (int)Functions.ckUlongTojLong(ckAttributesLength); ++i) {
            ckBufferLength = ckpAttributes[i].ulValueLen;
            if (ckBufferLength.longValue() <= 0L) continue;
            ckpAttributes[i].pValue = new Memory(Functions.ckUlongTojLong(ckBufferLength));
            ckpAttributes[i].ulValueLen = ckBufferLength;
        }
        rv = ckpFunctions.C_GetAttributeValue(ckSessionHandle, ckObjectHandle, ckpAttributes, ckAttributesLength);
        for (i = 0; i < (int)Functions.ckUlongTojLong(ckAttributesLength); ++i) {
            ckBufferLength = ckpAttributes[i].ulValueLen;
            if (ckBufferLength.longValue() <= 0L) continue;
            pTemplate[i].pValue = new Memory(Functions.ckUlongTojLong(ckBufferLength));
            pTemplate[i].pValue.write(0L, ckpAttributes[i].getByteArray(), 0, (int)Functions.ckUlongTojLong(ckBufferLength));
            pTemplate[i].ulValueLen = new NativeLong(Functions.ckUlongTojLong(ckBufferLength));
        }
        ckpAttributes = null;
        this.ckAssertReturnValueOK(rv);
    }

    public void C_SetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckObjectHandle = Functions.jLongToCKULong(hObject);
        CK_ATTRIBUTE[] ckpAttributes = Functions.jAttributeArrayToCKAttributeArray(pTemplate);
        NativeLong ckAttributesLength = Functions.jLongToCKULong(ckpAttributes.length);
        NativeLong rv = ckpFunctions.C_SetAttributeValue(ckSessionHandle, ckObjectHandle, ckpAttributes, ckAttributesLength);
        ckpAttributes = null;
        this.ckAssertReturnValueOK(rv);
    }

    public void C_FindObjectsInit(long hSession, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
        log.debug((Object)Arrays.toString((Object[])pTemplate));
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        CK_ATTRIBUTE[] ckpAttributes = Functions.jAttributeArrayToCKAttributeArray(pTemplate);
        NativeLong ckAttributesLength = Functions.jLongToCKULong(ckpAttributes.length);
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong rv = ckpFunctions.C_FindObjectsInit(ckSessionHandle, ckpAttributes, ckAttributesLength);
        ckpAttributes = null;
        this.ckAssertReturnValueOK(rv);
    }

    public long[] C_FindObjects(long hSession, long ulMaxObjectCount) throws PKCS11Exception {
        if (ulMaxObjectCount < 1L || ulMaxObjectCount > 4096L) {
            throw new PKCS11Exception(7L);
        }
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckMaxObjectLength = Functions.jLongToCKULong(ulMaxObjectCount);
        NativeLongByReference ckActualObjectCountRef = new NativeLongByReference();
        NativeLong[] ckpObjectHandleArray = new NativeLong[(int)Functions.ckUlongTojLong(ckMaxObjectLength)];
        NativeLong rv = ckpFunctions.C_FindObjects(ckSessionHandle, ckpObjectHandleArray, ckMaxObjectLength, ckActualObjectCountRef);
        NativeLong ckActualObjectCount = ckActualObjectCountRef.getValue();
        long[] jObjectHandleArray = Functions.ckULongArrayToJLongArray(ckpObjectHandleArray, (int)Functions.ckUlongTojLong(ckActualObjectCount));
        for (int i = 0; i < ckpObjectHandleArray.length; ++i) {
            this.free(ckpObjectHandleArray[i]);
            ckpObjectHandleArray[i] = null;
        }
        this.ckAssertReturnValueOK(rv);
        return jObjectHandleArray;
    }

    public void C_FindObjectsFinal(long hSession) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong rv = ckpFunctions.C_FindObjectsFinal(ckSessionHandle);
        this.ckAssertReturnValueOK(rv);
    }

    public void C_EncryptInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckKeyHandle = Functions.jLongToCKULong(hKey);
        CK_MECHANISM ckMechanism = pMechanism;
        NativeLong rv = ckpFunctions.C_EncryptInit(ckSessionHandle, ckMechanism, ckKeyHandle);
        ckMechanism = null;
        this.ckAssertReturnValueOK(rv);
    }

    public int C_Encrypt(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        Memory inBufP = inLen > 4096 ? new Memory((long)inLen) : new Memory(4096L);
        inBufP.write(0L, in, inOfs, inLen);
        NativeLong inBufPLen = Functions.jLongToCKULong(inLen);
        NativeLong ckEncryptedPartLen = new NativeLong((long)outLen);
        Memory outBufP = outLen > 4096 ? new Memory((long)outLen) : new Memory(4096L);
        NativeLongByReference ckEncryptedPartLenRef = new NativeLongByReference(ckEncryptedPartLen);
        NativeLong rv = ckpFunctions.C_Encrypt(ckSessionHandle, (Pointer)inBufP, inBufPLen, (Pointer)outBufP, ckEncryptedPartLenRef);
        if (Functions.ckUlongTojLong(rv) == 336L) {
            outBufP = new Memory(Functions.ckUlongTojLong(ckEncryptedPartLenRef.getValue()));
            rv = ckpFunctions.C_Encrypt(ckSessionHandle, (Pointer)inBufP, inBufPLen, (Pointer)outBufP, ckEncryptedPartLenRef);
        }
        ckEncryptedPartLen = ckEncryptedPartLenRef.getValue();
        int jEncryptedPartLen = (int)Functions.ckUlongTojLong(ckEncryptedPartLen);
        this.ckAssertReturnValueOK(rv);
        if (jEncryptedPartLen > 0) {
            outBufP.read(0L, out, outOfs, jEncryptedPartLen);
        }
        this.free(inBufP);
        inBufP = null;
        this.free(outBufP);
        outBufP = null;
        return jEncryptedPartLen;
    }

    public int C_EncryptUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Pointer inBufP;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        if (directIn != 0L) {
            inBufP = Pointer.createConstant((long)(directIn + (long)inOfs));
        } else {
            inBufP = inLen > 4096 ? new Memory((long)inLen) : new Memory(4096L);
            this.getByteArrayRegion(in, inOfs, inLen, inBufP);
        }
        NativeLong inBufPLen = Functions.jLongToCKULong(inLen);
        NativeLong ckEncryptedPartLen = new NativeLong((long)outLen);
        Object outBufP = directOut != 0L ? Pointer.createConstant((long)(directOut + (long)outOfs)) : (outLen > 4096 ? new Memory((long)outLen) : new Memory(4096L));
        NativeLongByReference ckEncryptedPartLenRef = new NativeLongByReference(ckEncryptedPartLen);
        NativeLong rv = ckpFunctions.C_EncryptUpdate(ckSessionHandle, inBufP, inBufPLen, (Pointer)outBufP, ckEncryptedPartLenRef);
        if (Functions.ckUlongTojLong(rv) == 336L) {
            outBufP = new Memory(Functions.ckUlongTojLong(ckEncryptedPartLenRef.getValue()));
            rv = ckpFunctions.C_Encrypt(ckSessionHandle, inBufP, inBufPLen, (Pointer)outBufP, ckEncryptedPartLenRef);
        }
        ckEncryptedPartLen = ckEncryptedPartLenRef.getValue();
        int jEncryptedPartLen = (int)Functions.ckUlongTojLong(ckEncryptedPartLen);
        this.ckAssertReturnValueOK(rv);
        if (jEncryptedPartLen > 0) {
            outBufP.read(0L, out, outOfs, jEncryptedPartLen);
        }
        this.free(inBufP);
        inBufP = null;
        this.free(outBufP);
        outBufP = null;
        return jEncryptedPartLen;
    }

    public int C_EncryptFinal(long hSession, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckLastEncryptedPartLen = new NativeLong((long)outLen);
        Object outBufP = directOut != 0L ? Pointer.createConstant((long)(directOut + (long)outOfs)) : new Memory(4096L);
        NativeLongByReference ckLastEncryptedPartLenRef = new NativeLongByReference(ckLastEncryptedPartLen);
        NativeLong rv = ckpFunctions.C_EncryptFinal(ckSessionHandle, (Pointer)outBufP, ckLastEncryptedPartLenRef);
        ckLastEncryptedPartLen = ckLastEncryptedPartLenRef.getValue();
        if (Functions.ckUlongTojLong(rv) == 336L) {
            outBufP = new Memory(Functions.ckUlongTojLong(ckLastEncryptedPartLenRef.getValue()));
            rv = ckpFunctions.C_EncryptFinal(ckSessionHandle, (Pointer)outBufP, ckLastEncryptedPartLenRef);
        }
        ckLastEncryptedPartLen = ckLastEncryptedPartLenRef.getValue();
        int jLastEncryptedPartLen = (int)Functions.ckUlongTojLong(ckLastEncryptedPartLen);
        this.ckAssertReturnValueOK(rv);
        if (directOut == 0L && jLastEncryptedPartLen > 0) {
            outBufP.read(0L, out, outOfs, jLastEncryptedPartLen);
        }
        if (directOut == 0L) {
            this.free(outBufP);
        }
        return jLastEncryptedPartLen;
    }

    public void C_DecryptInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckKeyHandle = Functions.jLongToCKULong(hKey);
        CK_MECHANISM ckMechanism = pMechanism;
        NativeLong rv = ckpFunctions.C_DecryptInit(ckSessionHandle, ckMechanism, ckKeyHandle);
        ckMechanism = null;
        this.ckAssertReturnValueOK(rv);
    }

    public int C_Decrypt(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        Memory inBufP = inLen > 4096 ? new Memory((long)inLen) : new Memory(4096L);
        inBufP.write(0L, in, inOfs, inLen);
        NativeLong inBufPLen = Functions.jLongToCKULong(inLen);
        NativeLong ckPartLen = new NativeLong((long)outLen);
        Memory outBufP = outLen > 4096 ? new Memory((long)outLen) : new Memory(4096L);
        NativeLongByReference ckPartLenRef = new NativeLongByReference(ckPartLen);
        NativeLong rv = ckpFunctions.C_Decrypt(ckSessionHandle, (Pointer)inBufP, inBufPLen, (Pointer)outBufP, ckPartLenRef);
        if (Functions.ckUlongTojLong(rv) == 336L) {
            outBufP = new Memory(Functions.ckUlongTojLong(ckPartLenRef.getValue()));
            rv = ckpFunctions.C_Decrypt(ckSessionHandle, (Pointer)inBufP, inBufPLen, (Pointer)outBufP, ckPartLenRef);
        }
        ckPartLen = ckPartLenRef.getValue();
        int jPartLen = (int)Functions.ckUlongTojLong(ckPartLen);
        this.ckAssertReturnValueOK(rv);
        if (jPartLen > 0) {
            outBufP.read(0L, out, outOfs, jPartLen);
        }
        this.free(inBufP);
        inBufP = null;
        this.free(outBufP);
        outBufP = null;
        return jPartLen;
    }

    public int C_DecryptUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Pointer inBufP;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        if (directIn != 0L) {
            inBufP = Pointer.createConstant((long)(directIn + (long)inOfs));
        } else {
            inBufP = inLen > 4096 ? new Memory((long)inLen) : new Memory(4096L);
            this.getByteArrayRegion(in, inOfs, inLen, inBufP);
        }
        NativeLong inBufPLen = Functions.jLongToCKULong(inLen);
        NativeLong ckPartLen = new NativeLong((long)outLen);
        Memory outBufP = outLen > 4096 ? new Memory((long)outLen) : new Memory(4096L);
        NativeLongByReference ckPartLenRef = new NativeLongByReference(ckPartLen);
        NativeLong rv = ckpFunctions.C_DecryptUpdate(ckSessionHandle, inBufP, inBufPLen, (Pointer)outBufP, ckPartLenRef);
        if (Functions.ckUlongTojLong(rv) == 336L) {
            outBufP = new Memory(Functions.ckUlongTojLong(ckPartLenRef.getValue()));
            rv = ckpFunctions.C_DecryptUpdate(ckSessionHandle, inBufP, inBufPLen, (Pointer)outBufP, ckPartLenRef);
        }
        ckPartLen = ckPartLenRef.getValue();
        int jPartLen = (int)Functions.ckUlongTojLong(ckPartLen);
        this.ckAssertReturnValueOK(rv);
        if (jPartLen > 0) {
            outBufP.read(0L, out, outOfs, jPartLen);
        }
        this.free(inBufP);
        inBufP = null;
        this.free(outBufP);
        outBufP = null;
        return jPartLen;
    }

    public int C_DecryptFinal(long hSession, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        NativeLong ckLastPartLen;
        NativeLongByReference ckLastPartLenRef;
        Object outBufP;
        NativeLong ckSessionHandle;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong rv = ckpFunctions.C_DecryptFinal(ckSessionHandle = Functions.jLongToCKULong(hSession), (Pointer)(outBufP = directOut != 0L ? Pointer.createConstant((long)(directOut + (long)outOfs)) : new Memory(4096L)), ckLastPartLenRef = new NativeLongByReference(ckLastPartLen = new NativeLong((long)outLen)));
        if (Functions.ckUlongTojLong(rv) == 336L) {
            outBufP = new Memory(Functions.ckUlongTojLong(ckLastPartLenRef.getValue()));
            rv = ckpFunctions.C_DecryptFinal(ckSessionHandle, (Pointer)outBufP, ckLastPartLenRef);
        }
        ckLastPartLen = ckLastPartLenRef.getValue();
        int jLastPartLen = (int)Functions.ckUlongTojLong(ckLastPartLen);
        this.ckAssertReturnValueOK(rv);
        if (directOut == 0L && jLastPartLen > 0) {
            outBufP.read(0L, out, outOfs, jLastPartLen);
        }
        if (directOut == 0L) {
            this.free(outBufP);
        }
        return jLastPartLen;
    }

    public void C_DigestInit(long hSession, CK_MECHANISM pMechanism) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        CK_MECHANISM ckMechanism = pMechanism;
        log.debug((Object)("mechanism:" + (Object)((Object)ckMechanism) + ";hex:" + Long.toHexString(ckMechanism.getMechanism())));
        NativeLong rv = ckpFunctions.C_DigestInit(ckSessionHandle, ckMechanism);
        ckMechanism = null;
        this.ckAssertReturnValueOK(rv);
    }

    public int C_DigestSingle(long hSession, CK_MECHANISM pMechanism, byte[] in, int inOfs, int inLen, byte[] digest, int digestOfs, int digestLen) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        CK_MECHANISM ckMechanism = pMechanism;
        log.debug((Object)("mechanism:" + (Object)((Object)ckMechanism) + ";hex:" + Long.toHexString(ckMechanism.getMechanism())));
        NativeLong rv = ckpFunctions.C_DigestInit(ckSessionHandle, ckMechanism);
        if (ckMechanism.pParameter != null) {
            this.free(ckMechanism.pParameter);
        }
        ckMechanism = null;
        this.ckAssertReturnValueOK(rv);
        Memory inBufP = inLen > 4096 ? new Memory((long)inLen) : new Memory(4096L);
        inBufP.write(0L, in, inOfs, inLen);
        NativeLong inBufPLen = Functions.jLongToCKULong(inLen);
        NativeLong ckDigestLen = new NativeLong((long)digestLen);
        Memory outBufP = digestLen > 64 ? new Memory((long)digestLen) : new Memory(64L);
        NativeLongByReference ckDigestLength = new NativeLongByReference(ckDigestLen);
        rv = ckpFunctions.C_Digest(ckSessionHandle, (Pointer)inBufP, inBufPLen, (Pointer)outBufP, ckDigestLength);
        if (Functions.ckUlongTojLong(rv) == 336L) {
            outBufP = new Memory(Functions.ckUlongTojLong(ckDigestLength.getValue()));
            rv = ckpFunctions.C_Digest(ckSessionHandle, (Pointer)inBufP, inBufPLen, (Pointer)outBufP, ckDigestLength);
        }
        ckDigestLen = ckDigestLength.getValue();
        int jDigestLen = (int)Functions.ckUlongTojLong(ckDigestLen);
        this.ckAssertReturnValueOK(rv);
        if (jDigestLen > 0) {
            outBufP.read(0L, digest, digestOfs, jDigestLen);
        }
        this.free(inBufP);
        inBufP = null;
        this.free(outBufP);
        outBufP = null;
        return jDigestLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void C_DigestUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        NativeLong ckSessionHandle;
        CK_FUNCTION_LIST ckpFunctions;
        Memory inBufP;
        block6: {
            inBufP = null;
            ckpFunctions = this.getFunctionList();
            ckSessionHandle = Functions.jLongToCKULong(hSession);
            if (directIn == 0L) break block6;
            NativeLong rv = ckpFunctions.C_DigestUpdate(ckSessionHandle, Pointer.createConstant((long)directIn), Functions.jLongToCKULong(inLen));
            this.ckAssertReturnValueOK(rv);
            this.free(inBufP);
            return;
        }
        try {
            NativeLong inBufPLen;
            if (inLen <= 4096) {
                inBufPLen = Functions.jLongToCKULong(4096L);
                inBufP = new Memory(4096L);
            } else {
                inBufPLen = Functions.jLongToCKULong(Math.min(65536, inLen));
                inBufP = new Memory(Functions.ckUlongTojLong(inBufPLen));
            }
            while (inLen > 0) {
                int chunkLen = (int)Math.min(Functions.ckUlongTojLong(inBufPLen), (long)inLen);
                this.getByteArrayRegion(in, inOfs, chunkLen, (Pointer)inBufP);
                NativeLong rv = ckpFunctions.C_DigestUpdate(ckSessionHandle, (Pointer)inBufP, Functions.jLongToCKULong(chunkLen));
                this.ckAssertReturnValueOK(rv);
                inOfs += chunkLen;
                inLen -= chunkLen;
            }
            this.free(inBufP);
        }
        catch (Throwable throwable) {
            this.free(inBufP);
            throw throwable;
        }
    }

    public void C_DigestKey(long hSession, long hKey) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckKeyHandle = Functions.jLongToCKULong(hKey);
        NativeLong rv = ckpFunctions.C_DigestKey(ckSessionHandle, ckKeyHandle);
        this.ckAssertReturnValueOK(rv);
    }

    public int C_DigestFinal(long hSession, byte[] pDigest, int digestOfs, int digestLen) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        Memory digestBufP = new Memory(64L);
        NativeLong ckDigestLength = Functions.jLongToCKULong(Math.min(64, digestLen));
        NativeLongByReference ckDigestLengthRef = new NativeLongByReference(ckDigestLength);
        NativeLong rv = ckpFunctions.C_DigestFinal(ckSessionHandle, (Pointer)digestBufP, ckDigestLengthRef);
        this.ckAssertReturnValueOK(rv);
        ckDigestLength = ckDigestLengthRef.getValue();
        this.setByteArrayRegion(pDigest, digestOfs, (int)Functions.ckUlongTojLong(ckDigestLength), (Pointer)digestBufP);
        return (int)Functions.ckUlongTojLong(ckDigestLength);
    }

    public void C_SignInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
        NativeLong ckSessionHandle = new NativeLong(hSession);
        CK_MECHANISM ckMechanism = pMechanism;
        NativeLong ckKeyHandle = new NativeLong(hKey);
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong rv = ckpFunctions.C_SignInit(ckSessionHandle, ckMechanism, ckKeyHandle);
        ckMechanism = null;
        this.ckAssertReturnValueOK(rv);
    }

    public byte[] C_Sign(long hSession, byte[] pData) throws PKCS11Exception {
        NativeLong ckSessionHandle = new NativeLong(hSession);
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        Memory ckpData = new Memory((long)pData.length);
        ckpData.write(0L, pData, 0, pData.length);
        NativeLong ckDataLength = new NativeLong((long)pData.length);
        NativeLongByReference ckSignatureLengthRef = new NativeLongByReference();
        NativeLong rv = ckpFunctions.C_Sign(ckSessionHandle, (Pointer)ckpData, ckDataLength, null, ckSignatureLengthRef);
        this.ckAssertReturnValueOK(rv);
        NativeLong ckSignatureLength = ckSignatureLengthRef.getValue();
        Memory ckpSignature = new Memory(Functions.ckUlongTojLong(ckSignatureLength));
        rv = ckpFunctions.C_Sign(ckSessionHandle, (Pointer)ckpData, ckDataLength, (Pointer)ckpSignature, ckSignatureLengthRef);
        ckSignatureLength = ckSignatureLengthRef.getValue();
        byte[] jSignature = ckpSignature.getByteArray(0L, (int)Functions.ckUlongTojLong(ckSignatureLength));
        this.free(ckpData);
        ckpData = null;
        this.free(ckpSignature);
        ckpSignature = null;
        this.ckAssertReturnValueOK(rv);
        return jSignature;
    }

    public void C_SignUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        NativeLong bufLen;
        NativeLong ckSessionHandle = new NativeLong(hSession);
        Memory bufP = new Memory(4096L);
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        ckSessionHandle = Functions.jLongToCKULong(hSession);
        if (directIn != 0L) {
            NativeLong rv = ckpFunctions.C_SignUpdate(ckSessionHandle, Pointer.createConstant((long)directIn), new NativeLong((long)inLen));
            this.ckAssertReturnValueOK(rv);
            return;
        }
        if (inLen <= 4096) {
            bufLen = new NativeLong(4096L);
            bufP = new Memory(Functions.ckUlongTojLong(bufLen));
        } else {
            bufLen = new NativeLong((long)Math.min(65536, inLen));
            bufP = new Memory(Functions.ckUlongTojLong(bufLen));
        }
        while (inLen > 0) {
            int chunkLen = Math.min((int)Functions.ckUlongTojLong(bufLen), inLen);
            bufP.write(0L, in, inOfs, chunkLen);
            NativeLong rv = ckpFunctions.C_SignUpdate(ckSessionHandle, (Pointer)bufP, new NativeLong((long)chunkLen));
            this.ckAssertReturnValueOK(rv);
            inOfs += chunkLen;
            inLen -= chunkLen;
        }
        this.free(bufP);
    }

    public byte[] C_SignFinal(long hSession, int expectedLen) throws PKCS11Exception {
        NativeLongByReference ckSignatureLengthRef;
        NativeLong rv;
        NativeLong ckSessionHandle = new NativeLong(hSession);
        byte[] jSignature = null;
        Memory bufP = new Memory(4096L);
        NativeLong ckSignatureLength = new NativeLong(4096L);
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        if (expectedLen > 0 && (long)expectedLen < Functions.ckUlongTojLong(ckSignatureLength)) {
            ckSignatureLength.setValue((long)expectedLen);
        }
        if (Functions.ckUlongTojLong(rv = ckpFunctions.C_SignFinal(ckSessionHandle, (Pointer)bufP, ckSignatureLengthRef = new NativeLongByReference(ckSignatureLength))) == 336L) {
            this.free(bufP);
            bufP = null;
            bufP = new Memory(Functions.ckUlongTojLong(ckSignatureLength));
            rv = ckpFunctions.C_SignFinal(ckSessionHandle, (Pointer)bufP, ckSignatureLengthRef);
        }
        this.ckAssertReturnValueOK(rv);
        ckSignatureLength = ckSignatureLengthRef.getValue();
        jSignature = bufP.getByteArray(0L, (int)Functions.ckUlongTojLong(ckSignatureLength));
        return jSignature;
    }

    public void C_SignRecoverInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
        throw new UnsupportedOperationException();
    }

    public int C_SignRecover(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOufs, int outLen) throws PKCS11Exception {
        throw new UnsupportedOperationException();
    }

    public void C_VerifyInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
        CK_MECHANISM ckMechanism = pMechanism;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckKeyHandle = Functions.jLongToCKULong(hKey);
        NativeLong rv = ckpFunctions.C_VerifyInit(ckSessionHandle, ckMechanism, ckKeyHandle);
        ckMechanism = null;
        this.ckAssertReturnValueOK(rv);
    }

    public void C_Verify(long hSession, byte[] pData, byte[] pSignature) throws PKCS11Exception {
        NativeLong rv;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong ckDataLength = Functions.jLongToCKULong(pData.length);
        Memory ckpData = new Memory(Functions.ckUlongTojLong(ckDataLength));
        ckpData.write(0L, pData, 0, (int)Functions.ckUlongTojLong(ckDataLength));
        NativeLong ckSignatureLength = Functions.jLongToCKULong(pSignature.length);
        Memory ckpSignature = new Memory(Functions.ckUlongTojLong(ckSignatureLength));
        ckpSignature.write(0L, pSignature, 0, (int)Functions.ckUlongTojLong(ckSignatureLength));
        try {
            rv = ckpFunctions.C_Verify(ckSessionHandle, (Pointer)ckpData, ckDataLength, (Pointer)ckpSignature, ckSignatureLength);
        }
        catch (Exception e) {
            rv = new NativeLong(-1L);
            e.printStackTrace();
        }
        this.free(ckpData);
        ckpData = null;
        this.free(ckpSignature);
        ckpSignature = null;
        this.ckAssertReturnValueOK(rv);
    }

    public void C_VerifyUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        Memory bufP;
        NativeLong bufLen;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        if (directIn != 0L) {
            NativeLong rv = ckpFunctions.C_VerifyUpdate(ckSessionHandle, Pointer.createConstant((long)directIn), new NativeLong((long)inLen));
            this.ckAssertReturnValueOK(rv);
            return;
        }
        if (inLen <= 4096) {
            bufLen = new NativeLong(4096L);
            bufP = new Memory(Functions.ckUlongTojLong(bufLen));
        } else {
            bufLen = new NativeLong((long)Math.min(65536, inLen));
            bufP = new Memory(Functions.ckUlongTojLong(bufLen));
        }
        while (inLen > 0) {
            int chunkLen = Math.min((int)Functions.ckUlongTojLong(bufLen), inLen);
            bufP.write(0L, in, inOfs, chunkLen);
            NativeLong rv = ckpFunctions.C_VerifyUpdate(ckSessionHandle, (Pointer)bufP, new NativeLong((long)chunkLen));
            this.ckAssertReturnValueOK(rv);
            inOfs += chunkLen;
            inLen -= chunkLen;
        }
        this.free(bufP);
    }

    public void C_VerifyFinal(long hSession, byte[] pSignature) throws PKCS11Exception {
        Memory ckpSignature = null;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        ckpSignature = new Memory((long)pSignature.length);
        ckpSignature.write(0L, pSignature, 0, pSignature.length);
        NativeLong ckSignatureLength = new NativeLong((long)pSignature.length);
        NativeLong rv = ckpFunctions.C_VerifyFinal(ckSessionHandle, (Pointer)ckpSignature, ckSignatureLength);
        this.ckAssertReturnValueOK(rv);
        this.free(ckpSignature);
    }

    public void C_VerifyRecoverInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
        throw new UnsupportedOperationException();
    }

    public int C_VerifyRecover(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOufs, int outLen) throws PKCS11Exception {
        throw new UnsupportedOperationException();
    }

    public long C_GenerateKey(long hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
        CK_ATTRIBUTE[] ckpAttributes = null;
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        CK_MECHANISM ckMechanism = pMechanism;
        ckpAttributes = Functions.jAttributeArrayToCKAttributeArray(pTemplate);
        NativeLong ckAttributesLength = new NativeLong((long)ckpAttributes.length);
        NativeLongByReference ckKeyHandleRef = new NativeLongByReference();
        NativeLong rv = ckpFunctions.C_GenerateKey(ckSessionHandle, ckMechanism, ckpAttributes, ckAttributesLength, ckKeyHandleRef);
        NativeLong ckKeyHandle = ckKeyHandleRef.getValue();
        long jKeyHandle = Functions.ckUlongTojLong(ckKeyHandle);
        ckMechanism = null;
        this.ckAssertReturnValueOK(rv);
        return jKeyHandle;
    }

    public long[] C_GenerateKeyPair(long hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pPublicKeyTemplate, CK_ATTRIBUTE[] pPrivateKeyTemplate) throws PKCS11Exception {
        log.debug((Object)Arrays.toString((Object[])pPublicKeyTemplate));
        log.debug((Object)Arrays.toString((Object[])pPrivateKeyTemplate));
        NativeLongByReference ckpPublicKeyHandleRef = new NativeLongByReference();
        NativeLongByReference ckpPrivateKeyHandleRef = new NativeLongByReference();
        long[] jKeyHandles = new long[2];
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        CK_ATTRIBUTE[] ckpPublicKeyAttributes = Functions.jAttributeArrayToCKAttributeArray(pPublicKeyTemplate);
        CK_ATTRIBUTE[] ckpPrivateKeyAttributes = Functions.jAttributeArrayToCKAttributeArray(pPrivateKeyTemplate);
        NativeLong ckPublicKeyAttributesLength = Functions.jLongToCKULong(ckpPublicKeyAttributes.length);
        NativeLong ckPrivateKeyAttributesLength = Functions.jLongToCKULong(ckpPrivateKeyAttributes.length);
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        CK_MECHANISM ckMechanism = pMechanism;
        NativeLong rv = ckpFunctions.C_GenerateKeyPair(ckSessionHandle, ckMechanism, ckpPublicKeyAttributes, ckPublicKeyAttributesLength, ckpPrivateKeyAttributes, ckPrivateKeyAttributesLength, ckpPublicKeyHandleRef, ckpPrivateKeyHandleRef);
        this.ckAssertReturnValueOK(rv);
        long publicId = Functions.ckUlongTojLong(ckpPublicKeyHandleRef.getValue());
        long privateId = Functions.ckUlongTojLong(ckpPrivateKeyHandleRef.getValue());
        jKeyHandles[0] = publicId;
        jKeyHandles[1] = privateId;
        ckMechanism = null;
        return jKeyHandles;
    }

    public byte[] C_WrapKey(long hSession, CK_MECHANISM pMechanism, long hWrappingKey, long hKey) throws PKCS11Exception {
        throw new UnsupportedOperationException();
    }

    public long C_UnwrapKey(long hSession, CK_MECHANISM pMechanism, long hUnwrappingKey, byte[] pWrappedKey, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
        throw new UnsupportedOperationException();
    }

    public long C_DeriveKey(long hSession, CK_MECHANISM pMechanism, long hBaseKey, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void C_SeedRandom(long hSession, byte[] pSeed) throws PKCS11Exception {
        Pointer ckpSeed = null;
        try {
            CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
            NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
            NativeLong ckSeedLength = Functions.jLongToCKULong(pSeed.length);
            ckpSeed = this.getByteArrayElements(pSeed, true);
            NativeLong rv = ckpFunctions.C_SeedRandom(ckSessionHandle, ckpSeed, ckSeedLength);
            this.ckAssertReturnValueOK(rv);
            this.releaseByteArrayElements(pSeed, ckpSeed, 0);
            this.free(ckpSeed);
        }
        catch (Throwable throwable) {
            this.free(ckpSeed);
            throw throwable;
        }
    }

    public void C_GenerateRandom(long hSession, byte[] randomData) throws PKCS11Exception {
        CK_FUNCTION_LIST ckpFunctions = this.getFunctionList();
        NativeLong ckSessionHandle = Functions.jLongToCKULong(hSession);
        NativeLong randomBufLength = Functions.jLongToCKULong(randomData.length);
        Pointer randomBufP = this.getByteArrayElements(randomData, false);
        NativeLong rv = ckpFunctions.C_GenerateRandom(ckSessionHandle, randomBufP, randomBufLength);
        this.releaseByteArrayElements(randomData, randomBufP, 0);
        this.ckAssertReturnValueOK(rv);
    }

    public String toString() {
        return "Module name: " + this.pkcs11Module;
    }

    public void finalize() throws Throwable {
        this.disconnect();
    }

    private void ckAssertReturnValue(NativeLong rv, long ckrValue) throws PKCS11Exception {
        long ret = Functions.ckUlongTojLong(rv);
        if (ret != 0L && ret != ckrValue) {
            throw new PKCS11Exception(ret);
        }
    }

    private void ckAssertReturnValueOK(NativeLong rv) throws PKCS11Exception {
        long ret = Functions.ckUlongTojLong(rv);
        if (ret != 0L) {
            throw new PKCS11Exception(ret);
        }
    }

    public CK_FUNCTION_LIST getFunctionList() {
        if (this.pNativeData.ckFunctionList == null) {
            log.error((Object)"failed getting module entry, CK_FUNCTION_LIST is null");
            throw new NullPointerException("CK_FUNCTION_LIST is null");
        }
        return this.pNativeData.ckFunctionList;
    }

    private final void free(Object p) {
        this.free(p, -1L);
    }

    private final void free(Object p, long size) {
        if (size < 1L) {
            size = 1L;
        }
        if (p instanceof Memory) {
            ((Memory)p).clear();
        } else if (p instanceof Structure) {
            ((Structure)p).clear();
        } else if (p instanceof Pointer) {
            ((Pointer)p).clear(size);
        } else if (p instanceof ByReference) {
            ((ByReference)p).getPointer().clear(size);
        }
    }

    private <T> void free(T[] p) {
        for (int i = 0; i < p.length; ++i) {
            this.free(p[i]);
            p[i] = null;
        }
    }

    private void getByteArrayRegion(byte[] array, int start, int length, Pointer bufPointer) {
        bufPointer.write(0L, array, start, length);
    }

    private Pointer getByteArrayElements(byte[] array, boolean isCopy) {
        Memory pointer = new Memory((long)array.length);
        if (isCopy) {
            this.getByteArrayRegion(array, 0, array.length, (Pointer)pointer);
        }
        return pointer;
    }

    private void setByteArrayRegion(byte[] array, int start, int length, Pointer bufPointer) {
        bufPointer.read(0L, array, start, length);
    }

    private void releaseByteArrayElements(byte[] array, Pointer elems, int mode) {
        this.setByteArrayRegion(array, 0, array.length, elems);
    }

    static class ModuleData {
        final NativeLibrary hModule;
        final CK_FUNCTION_LIST ckFunctionList;
        Object applicationMutexHandler;

        ModuleData(NativeLibrary hModule, CK_FUNCTION_LIST ckFunctionList, Object applicationMutexHandler) {
            this.hModule = hModule;
            this.ckFunctionList = ckFunctionList;
            this.applicationMutexHandler = applicationMutexHandler;
        }
    }

    static class SynchronizedPKCS11
    extends PKCS11 {
        SynchronizedPKCS11(String pkcs11ModulePath, String[] searchPaths, String functionListName) throws IOException {
            super(pkcs11ModulePath, searchPaths, functionListName);
        }

        @Override
        synchronized void C_Initialize(Object pInitArgs) throws PKCS11Exception {
            super.C_Initialize(pInitArgs);
        }

        @Override
        public synchronized void C_Finalize(Object pReserved) throws PKCS11Exception {
            super.C_Finalize(pReserved);
        }

        @Override
        public synchronized CK_INFO C_GetInfo() throws PKCS11Exception {
            return super.C_GetInfo();
        }

        @Override
        public synchronized long[] C_GetSlotList(boolean tokenPresent) throws PKCS11Exception {
            return super.C_GetSlotList(tokenPresent);
        }

        @Override
        public synchronized CK_SLOT_INFO C_GetSlotInfo(long slotID) throws PKCS11Exception {
            return super.C_GetSlotInfo(slotID);
        }

        @Override
        public synchronized CK_TOKEN_INFO C_GetTokenInfo(long slotID) throws PKCS11Exception {
            return super.C_GetTokenInfo(slotID);
        }

        @Override
        public synchronized long[] C_GetMechanismList(long slotID) throws PKCS11Exception {
            return super.C_GetMechanismList(slotID);
        }

        @Override
        public synchronized CK_MECHANISM_INFO C_GetMechanismInfo(long slotID, long type) throws PKCS11Exception {
            return super.C_GetMechanismInfo(slotID, type);
        }

        @Override
        public synchronized long C_OpenSession(long slotID, long flags, Object pApplication, CK_NOTIFY Notify) throws PKCS11Exception {
            return super.C_OpenSession(slotID, flags, pApplication, Notify);
        }

        @Override
        public synchronized void C_CloseSession(long hSession) throws PKCS11Exception {
            super.C_CloseSession(hSession);
        }

        @Override
        public synchronized CK_SESSION_INFO C_GetSessionInfo(long hSession) throws PKCS11Exception {
            return super.C_GetSessionInfo(hSession);
        }

        @Override
        public synchronized void C_Login(long hSession, long userType, char[] pPin) throws PKCS11Exception {
            super.C_Login(hSession, userType, pPin);
        }

        @Override
        public synchronized void C_Logout(long hSession) throws PKCS11Exception {
            super.C_Logout(hSession);
        }

        @Override
        public synchronized long C_CreateObject(long hSession, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_CreateObject(hSession, pTemplate);
        }

        @Override
        public synchronized long C_CopyObject(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_CopyObject(hSession, hObject, pTemplate);
        }

        @Override
        public synchronized void C_DestroyObject(long hSession, long hObject) throws PKCS11Exception {
            super.C_DestroyObject(hSession, hObject);
        }

        @Override
        public synchronized void C_GetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            super.C_GetAttributeValue(hSession, hObject, pTemplate);
        }

        @Override
        public synchronized void C_SetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            super.C_SetAttributeValue(hSession, hObject, pTemplate);
        }

        @Override
        public synchronized void C_FindObjectsInit(long hSession, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            super.C_FindObjectsInit(hSession, pTemplate);
        }

        @Override
        public synchronized long[] C_FindObjects(long hSession, long ulMaxObjectCount) throws PKCS11Exception {
            return super.C_FindObjects(hSession, ulMaxObjectCount);
        }

        @Override
        public synchronized void C_FindObjectsFinal(long hSession) throws PKCS11Exception {
            super.C_FindObjectsFinal(hSession);
        }

        @Override
        public synchronized void C_EncryptInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_EncryptInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized int C_Encrypt(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_Encrypt(hSession, in, inOfs, inLen, out, outOfs, outLen);
        }

        @Override
        public synchronized int C_EncryptUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_EncryptUpdate(hSession, directIn, in, inOfs, inLen, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized int C_EncryptFinal(long hSession, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_EncryptFinal(hSession, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized void C_DecryptInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_DecryptInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized int C_Decrypt(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_Decrypt(hSession, in, inOfs, inLen, out, outOfs, outLen);
        }

        @Override
        public synchronized int C_DecryptUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_DecryptUpdate(hSession, directIn, in, inOfs, inLen, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized int C_DecryptFinal(long hSession, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_DecryptFinal(hSession, directOut, out, outOfs, outLen);
        }

        @Override
        public synchronized void C_DigestInit(long hSession, CK_MECHANISM pMechanism) throws PKCS11Exception {
            super.C_DigestInit(hSession, pMechanism);
        }

        @Override
        public synchronized int C_DigestSingle(long hSession, CK_MECHANISM pMechanism, byte[] in, int inOfs, int inLen, byte[] digest, int digestOfs, int digestLen) throws PKCS11Exception {
            return super.C_DigestSingle(hSession, pMechanism, in, inOfs, inLen, digest, digestOfs, digestLen);
        }

        @Override
        public synchronized void C_DigestUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
            super.C_DigestUpdate(hSession, directIn, in, inOfs, inLen);
        }

        @Override
        public synchronized void C_DigestKey(long hSession, long hKey) throws PKCS11Exception {
            super.C_DigestKey(hSession, hKey);
        }

        @Override
        public synchronized int C_DigestFinal(long hSession, byte[] pDigest, int digestOfs, int digestLen) throws PKCS11Exception {
            return super.C_DigestFinal(hSession, pDigest, digestOfs, digestLen);
        }

        @Override
        public synchronized void C_SignInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_SignInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized byte[] C_Sign(long hSession, byte[] pData) throws PKCS11Exception {
            return super.C_Sign(hSession, pData);
        }

        @Override
        public synchronized void C_SignUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
            super.C_SignUpdate(hSession, directIn, in, inOfs, inLen);
        }

        @Override
        public synchronized byte[] C_SignFinal(long hSession, int expectedLen) throws PKCS11Exception {
            return super.C_SignFinal(hSession, expectedLen);
        }

        @Override
        public synchronized void C_SignRecoverInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_SignRecoverInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized int C_SignRecover(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOufs, int outLen) throws PKCS11Exception {
            return super.C_SignRecover(hSession, in, inOfs, inLen, out, outOufs, outLen);
        }

        @Override
        public synchronized void C_VerifyInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_VerifyInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized void C_Verify(long hSession, byte[] pData, byte[] pSignature) throws PKCS11Exception {
            super.C_Verify(hSession, pData, pSignature);
        }

        @Override
        public synchronized void C_VerifyUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
            super.C_VerifyUpdate(hSession, directIn, in, inOfs, inLen);
        }

        @Override
        public synchronized void C_VerifyFinal(long hSession, byte[] pSignature) throws PKCS11Exception {
            super.C_VerifyFinal(hSession, pSignature);
        }

        @Override
        public synchronized void C_VerifyRecoverInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_VerifyRecoverInit(hSession, pMechanism, hKey);
        }

        @Override
        public synchronized int C_VerifyRecover(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOufs, int outLen) throws PKCS11Exception {
            return super.C_VerifyRecover(hSession, in, inOfs, inLen, out, outOufs, outLen);
        }

        @Override
        public synchronized long C_GenerateKey(long hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_GenerateKey(hSession, pMechanism, pTemplate);
        }

        @Override
        public synchronized long[] C_GenerateKeyPair(long hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pPublicKeyTemplate, CK_ATTRIBUTE[] pPrivateKeyTemplate) throws PKCS11Exception {
            return super.C_GenerateKeyPair(hSession, pMechanism, pPublicKeyTemplate, pPrivateKeyTemplate);
        }

        @Override
        public synchronized byte[] C_WrapKey(long hSession, CK_MECHANISM pMechanism, long hWrappingKey, long hKey) throws PKCS11Exception {
            return super.C_WrapKey(hSession, pMechanism, hWrappingKey, hKey);
        }

        @Override
        public synchronized long C_UnwrapKey(long hSession, CK_MECHANISM pMechanism, long hUnwrappingKey, byte[] pWrappedKey, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_UnwrapKey(hSession, pMechanism, hUnwrappingKey, pWrappedKey, pTemplate);
        }

        @Override
        public synchronized long C_DeriveKey(long hSession, CK_MECHANISM pMechanism, long hBaseKey, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            return super.C_DeriveKey(hSession, pMechanism, hBaseKey, pTemplate);
        }

        @Override
        public synchronized void C_SeedRandom(long hSession, byte[] pSeed) throws PKCS11Exception {
            super.C_SeedRandom(hSession, pSeed);
        }

        @Override
        public synchronized void C_GenerateRandom(long hSession, byte[] randomData) throws PKCS11Exception {
            super.C_GenerateRandom(hSession, randomData);
        }
    }
}

