/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11.util;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class P11ConfigUtils {
    private static final File CONFIGFILE_FILE = new File("PKCS11Config.xml");
    private static Map<String, String> devices = new HashMap<String, String>();

    private static void parser() {
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(CONFIGFILE_FILE);
            List list = document.selectNodes("//p11Devices/device");
            for (Node node : list) {
                Node nameNode = (Node)node.selectObject("name");
                Node configFileNode = (Node)node.selectObject("configFile");
                devices.put(nameNode.getText(), configFileNode.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Set<String> devices() {
        return devices.keySet();
    }

    public static File getDeviceConfigFile(String deviceName) {
        String configFile = devices.get(deviceName);
        return new File(configFile);
    }

    static {
        P11ConfigUtils.parser();
    }
}

