/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.tsp;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DERBoolean;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extension;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extensions;
import cn.tca.TopBasicCrypto.tsp.TimeStampRequest;
import cn.topca.security.tsp.MessageImprint;
import cn.topca.security.tsp.TSAPolicyId;
import cn.topca.security.tsp.TSPExtensions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Vector;

public class TimeStampReq {
    public static final BigInteger V1 = BigInteger.ONE;
    private BigInteger version = V1;
    private MessageImprint messageImprint;
    private TSAPolicyId reqPolicy;
    private BigInteger nonce;
    private boolean certReq = false;
    private TSPExtensions extensions;

    public BigInteger getVersion() {
        return this.version;
    }

    public void setVersion(BigInteger version) {
        this.version = version;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public void setMessageImprint(MessageImprint messageImprint) {
        this.messageImprint = messageImprint;
    }

    public TSAPolicyId getReqPolicy() {
        return this.reqPolicy;
    }

    public void setReqPolicy(TSAPolicyId reqPolicy) {
        this.reqPolicy = reqPolicy;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public boolean isCertReq() {
        return this.certReq;
    }

    public void setCertReq(boolean certReq) {
        this.certReq = certReq;
    }

    public TSPExtensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(TSPExtensions extensions) {
        this.extensions = extensions;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public byte[] getEncoded() throws IOException {
        cn.tca.TopBasicCrypto.asn1.tsp.MessageImprint bcMsgImprint = null;
        DERObjectIdentifier derTSAPolicy = null;
        DERInteger derNonce = null;
        DERBoolean derCertReq = null;
        X509Extensions bcX509Extensions = null;
        bcMsgImprint = new cn.tca.TopBasicCrypto.asn1.tsp.MessageImprint(AlgorithmIdentifier.getInstance(this.messageImprint.getHashAlgorithm().toString()), this.messageImprint.getHashedMessage());
        if (this.reqPolicy != null) {
            derTSAPolicy = new DERObjectIdentifier(this.reqPolicy.toString());
        }
        if (this.nonce != null) {
            derNonce = new DERInteger(this.nonce);
        }
        derCertReq = new DERBoolean(this.certReq);
        if (this.extensions != null) {
            Vector<ASN1ObjectIdentifier> objectIDs = new Vector<ASN1ObjectIdentifier>();
            Vector<X509Extension> values = new Vector<X509Extension>();
            for (String oid : this.extensions.getCriticalExtensionOIDs()) {
                objectIDs.add(new ASN1ObjectIdentifier(oid));
                values.add(new X509Extension(true, (ASN1OctetString)new DEROctetString(this.extensions.getExtensionValue(oid))));
            }
            Iterator<String> it = null;
            for (String oid : this.extensions.getNonCriticalExtensionOIDs()) {
                objectIDs.add(new ASN1ObjectIdentifier(oid));
                values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString(this.extensions.getExtensionValue(oid))));
            }
            it = null;
            bcX509Extensions = new X509Extensions(objectIDs, values);
        }
        TimeStampRequest bcreq = new TimeStampRequest(new cn.tca.TopBasicCrypto.asn1.tsp.TimeStampReq(bcMsgImprint, derTSAPolicy, derNonce, derCertReq, bcX509Extensions));
        return bcreq.getEncoded();
    }

    public static TimeStampReq getInstance(byte[] bytes) throws IOException {
        return TimeStampReq.getInstance(new ByteArrayInputStream(bytes));
    }

    public static TimeStampReq getInstance(InputStream is) throws IOException {
        TimeStampReq req = new TimeStampReq();
        TimeStampRequest bcreq = new TimeStampRequest(is);
        req.messageImprint = new MessageImprint(bcreq.getMessageImprintAlgOID(), bcreq.getMessageImprintDigest());
        if (bcreq.getReqPolicy() != null) {
            req.reqPolicy = new TSAPolicyId(bcreq.getReqPolicy());
        }
        if (bcreq.getNonce() != null) {
            req.nonce = bcreq.getNonce();
        }
        req.certReq = bcreq.getCertReq();
        if (bcreq.hasExtensions()) {
            req.extensions = new TSPExtensions();
            for (String oid : bcreq.getCriticalExtensionOIDs()) {
                req.extensions.add(oid, bcreq.getExtensionValue(oid), true);
            }
            Iterator it = null;
            for (String oid : bcreq.getNonCriticalExtensionOIDs()) {
                req.extensions.add(oid, bcreq.getExtensionValue(oid), false);
            }
        }
        return req;
    }
}

