/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.tsp;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.DERBitString;
import cn.tca.TopBasicCrypto.asn1.DERUTF8String;
import cn.tca.TopBasicCrypto.tsp.TimeStampResponse;
import cn.topca.security.pkix.PKIFailureInfo;
import cn.topca.security.pkix.PKIFreeText;
import cn.topca.security.pkix.PKIStatus;
import cn.topca.security.pkix.PKIStatusInfo;
import cn.topca.security.tsp.TSPException;
import cn.topca.security.tsp.TimeStampToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TimeStampResp {
    private PKIStatusInfo status;
    private TimeStampToken timeStampToken;

    public TimeStampResp(PKIStatusInfo status, TimeStampToken timeStampToken) {
        this.status = status;
        this.timeStampToken = timeStampToken;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public byte[] getEncoded() throws IOException, TSPException {
        TimeStampResponse bcresp = null;
        try {
            cn.tca.TopBasicCrypto.asn1.cmp.PKIFreeText freeText = null;
            if (this.status.getStatusString() != null) {
                String[] strings = new String[this.status.getStatusString().size()];
                for (int i = 0; i < strings.length; ++i) {
                    strings[i] = this.status.getStatusString().getStringAt(i);
                }
                freeText = new cn.tca.TopBasicCrypto.asn1.cmp.PKIFreeText(strings);
            }
            cn.tca.TopBasicCrypto.asn1.cmp.PKIFailureInfo failureInfo = null;
            if (this.status.getFailInfo() != null) {
                failureInfo = new cn.tca.TopBasicCrypto.asn1.cmp.PKIFailureInfo(new DERBitString(this.status.getFailInfo().getDEREncoded()));
            }
            bcresp = new TimeStampResponse(new cn.tca.TopBasicCrypto.asn1.tsp.TimeStampResp(new cn.tca.TopBasicCrypto.asn1.cmp.PKIStatusInfo(this.status.getStatus().getValue().intValue(), freeText, failureInfo), this.timeStampToken.toCMSSignedData().getContentInfo()));
            return bcresp.getEncoded();
        }
        catch (cn.tca.TopBasicCrypto.tsp.TSPException e) {
            throw new TSPException(e.getMessage(), e);
        }
    }

    public static TimeStampResp getInstance(byte[] bytes) throws IOException, TSPException {
        return TimeStampResp.getInstance(new ByteArrayInputStream(bytes));
    }

    public static TimeStampResp getInstance(InputStream in) throws IOException, TSPException {
        TimeStampResp req = null;
        cn.tca.TopBasicCrypto.asn1.tsp.TimeStampResp bcresp = cn.tca.TopBasicCrypto.asn1.tsp.TimeStampResp.getInstance(new ASN1InputStream(in).readObject());
        try {
            PKIFreeText freeText = null;
            if (bcresp.getStatus().getStatusString() != null) {
                String[] strings = new String[bcresp.getStatus().getStatusString().size()];
                for (int i = 0; i < strings.length; ++i) {
                    DERUTF8String derUTF8String = bcresp.getStatus().getStatusString().getStringAt(i);
                    strings[i] = derUTF8String.getString();
                }
                freeText = new PKIFreeText(strings);
            }
            PKIFailureInfo failureInfo = null;
            if (bcresp.getStatus().getFailInfo() != null) {
                failureInfo = new PKIFailureInfo(bcresp.getStatus().getFailInfo().intValue());
            }
            req = new TimeStampResp(new PKIStatusInfo(new PKIStatus(bcresp.getStatus().getStatus()), freeText, failureInfo), new TimeStampToken(bcresp.getTimeStampToken()));
        }
        catch (cn.tca.TopBasicCrypto.tsp.TSPException e) {
            throw new TSPException(e.getMessage(), e);
        }
        return req;
    }
}

