/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.service;

import com.itrus.base.util.NetworkInfo;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.SignatureVerifyException;
import com.itrus.svm.SVM;
import com.itrus.util.DataUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeEnvCheck {
    private static final Logger log = Logger.getLogger(CodeEnvCheck.class);
    private static boolean envCheck = true;
    private static final String issueAccont = "IMOc5JE/ysUiS093VR3LgqR+BME=";

    public static boolean isEnvCheck() {
        log.info((Object)">>isEnvCheck()");
        log.info((Object)("isEnvCheck return [" + envCheck + "]"));
        return envCheck;
    }

    public static void setEnvCheck(boolean envCheck) {
        CodeEnvCheck.envCheck = envCheck;
    }

    private static String getLCR(String license) {
        StringBuilder sb = new StringBuilder(license);
        return sb.reverse().toString();
    }

    public static boolean check(String path, X509Certificate cert) throws IOException, NoSuchAlgorithmException {
        log.info((Object)">>check()");
        log.info((Object)"Begin Check CodeEnv>>");
        if (cert == null) {
            log.error((Object)"check license failed !!! \u83b7\u53d6\u7f51\u94f6\u901a\u8baf\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        FileInputStream in = new FileInputStream(path);
        byte[] b = new byte[((InputStream)in).available()];
        ((InputStream)in).read(b);
        ((InputStream)in).close();
        String codelicense = new String(b);
        codelicense = CodeEnvCheck.replaceBlank(codelicense);
        String[] str = codelicense.split("&");
        boolean flag = CodeEnvCheck.checkIssuer(str);
        if (flag) {
            if (str != null && str.length > 2 && str[2].equalsIgnoreCase("false")) {
                log.info((Object)"Check CodeEnv License be cancle!");
                envCheck = false;
                return true;
            }
            List<String> list = NetworkInfo.getMacAddress();
            String ebpath = CodeEnvCheck.getEBHomePath();
            log.info((Object)"\u5f00\u542flicense\u9a8c\u8bc1!");
            log.info((Object)("${eb_server}:[" + ebpath + "]"));
            String ebhome = CodeEnvCheck.genEBHomeFromCodeLicense(CodeEnvCheck.getLCR(str[1]));
            List<String> maclist = CodeEnvCheck.genMacListFromCodeLicense(CodeEnvCheck.getLCR(str[1]));
            boolean ret1 = CodeEnvCheck.checkEBHome(ebpath, ebhome);
            boolean ret2 = CodeEnvCheck.checMac(list, maclist);
            boolean ret3 = CodeEnvCheck.checkCert(maclist, cert);
            if (ret1 && ret2 && ret3) {
                log.info((Object)"check license success.license\u9a8c\u8bc1\u901a\u8fc7");
                return true;
            }
        } else {
            log.error((Object)"license \u6765\u6e90\u4e0d\u5408\u6cd5");
        }
        log.error((Object)"check license failed !!! license\u4e0e\u5f53\u524d\u94f6\u4f01\u670d\u52a1\u4e0d\u5339\u914d\uff0c\u8bf7\u7533\u8bf7\u5408\u6cd5license");
        return false;
    }

    private static boolean checkIssuer(String[] str) {
        log.info((Object)">>checkIssuer([]str)");
        log.debug((Object)Arrays.toString(str));
        try {
            X509Certificate x509cert = SVM.verifySignature(Base64.decode((String)CodeEnvCheck.getLCR(str[1])), str[0]);
            String issuerDN = x509cert.getIssuerDN().getName();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(issuerDN.getBytes());
            issuerDN = com.itrus.util.Base64.encode(md.digest());
            if (issuerDN.equals(issueAccont)) {
                log.info((Object)">>checkIssuer(..) return true");
                return true;
            }
        }
        catch (SignatureVerifyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CryptoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error((Object)"check license failed !!! license\u4e0e\u5f53\u524d\u94f6\u4f01\u670d\u52a1\u4e0d\u5339\u914d\uff0c\u8bf7\u7533\u8bf7\u5408\u6cd5license");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.warn((Object)">>checkIssuer(..) return true");
        return false;
    }

    private static String getEBHomePath() {
        log.info((Object)">>getEBHomePath()");
        try {
            String ebpath = System.getProperty("EAS_HOME");
            if (ebpath.endsWith("\\") || ebpath.endsWith("/")) {
                ebpath = ebpath.substring(0, ebpath.length() - 1);
            }
            return ebpath;
        }
        catch (Exception e) {
            log.info((Object)"\u83b7\u53d6ebhome\u76ee\u5f55\u9519\u8bef");
            throw new RuntimeException("\u83b7\u53d6ebhome\u76ee\u5f55\u9519\u8bef");
        }
    }

    private static List<String> genMacListFromCodeLicense(String codelicense) throws UnsupportedEncodingException {
        String[] str2;
        String lsrStr = new String(Base64.decode((String)codelicense), "UTF-8");
        ArrayList<String> macList = new ArrayList<String>();
        String[] str = lsrStr.split("&");
        String[] stringArray = str2 = str[0].split("@");
        int n = str2.length;
        int n2 = 0;
        while (n2 < n) {
            String mac = stringArray[n2];
            macList.add(mac);
            ++n2;
        }
        return macList;
    }

    private static String genEBHomeFromCodeLicense(String codelicense) throws UnsupportedEncodingException {
        String lsrStr = new String(Base64.decode((String)codelicense), "UTF-8");
        String[] str = lsrStr.split("&");
        return str[1];
    }

    private static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    private static boolean checkEBHome(String ebpath, String ebhome) {
        log.info((Object)">>checkEBHome()");
        log.debug((Object)("local easserver path[" + ebpath + "]"));
        if (ebhome.contains("/")) {
            ebhome = ebhome.replace('/', File.separatorChar);
        }
        if (ebhome.contains("\\")) {
            ebhome = ebhome.replace('\\', File.separatorChar);
        }
        if (ebpath.contains("/")) {
            ebpath = ebpath.replace('/', File.separatorChar);
        }
        if (ebpath.contains("\\")) {
            ebpath = ebpath.replace('\\', File.separatorChar);
        }
        log.debug((Object)("license easserver path[" + ebhome + "]"));
        if (ebpath != null && ebpath.equals(ebhome)) {
            log.info((Object)"checkEBHome  success.");
            return true;
        }
        log.info((Object)"checkEBHome  failed!!!");
        return false;
    }

    private static boolean checMac(List<String> list, List<String> maclist) {
        log.info((Object)">>checMac()");
        log.info((Object)">>\u62db\u5546\u5c40\u5b9a\u5236-\u4e0d\u9a8c\u8bc1mac");
        return true;
    }

    private static boolean checkCert(List<String> macs, X509Certificate cert) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        log.info((Object)">>checkCert(serverCert)");
        String subject = cert.getSubjectDN().getName();
        log.info((Object)("signer subject:[" + subject + "]"));
        Pattern pattern = Pattern.compile("(?<=OU\\s{0,1}=\\s{0,1}UID\\s{0,1}:\\s{0,1})[^,]+(?=\\s{0,1},{0,1})");
        Matcher matcher = pattern.matcher(subject);
        String certUid = "";
        if (!matcher.find(1)) {
            log.error((Object)"cerverCert without uid!checkCert(..) return false !");
            return false;
        }
        certUid = matcher.group(0);
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(macs.toString().getBytes());
        byte[] digest = md.digest();
        String UID = DataUtil.transformByteArrayToHexString(digest);
        if (UID.equals(certUid)) {
            log.info((Object)" checkCert(..) return true !");
            return true;
        }
        log.error((Object)"serverCert miss macth!checkCert(..) return false !");
        return false;
    }
}

