/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkInfo {
    private static final Logger log = Logger.getLogger(NetworkInfo.class);

    public static final List<String> getMacAddress() throws IOException {
        log.info((Object)">>getMacAddress()");
        String os = System.getProperty("os.name");
        log.info((Object)("os.name[" + os + "]"));
        try {
            if (os.startsWith("Windows")) {
                return NetworkInfo.parseMacAddress(NetworkInfo.windowsRunIpConfigCommand());
            }
            if (os.toLowerCase().startsWith("linux")) {
                return NetworkInfo.parseMacAddress(NetworkInfo.linuxRunIfConfigCommand());
            }
            return NetworkInfo.parseMacAddress(NetworkInfo.aixRunNetstatCommand());
        }
        catch (ParseException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    private static final List<String> parseMacAddress(String ipConfigResponse) throws ParseException {
        log.info((Object)">>parseMacAddress(.)");
        if (ipConfigResponse == null || ipConfigResponse == "") {
            log.info((Object)"ipConfigResponse is  null");
            throw new RuntimeException("ipConfigResponse is  null");
        }
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
            log.info((Object)("localHost[" + localHost + "]"));
        }
        catch (UnknownHostException ex) {
            log.info((Object)ex.getMessage(), (Throwable)ex);
            throw new ParseException(ex.getMessage(), 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String macAddress = null;
        ArrayList<String> macAddressList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if (line.indexOf("Virtual") != -1) {
                tokenizer.nextToken().trim();
                continue;
            }
            macAddress = NetworkInfo.getMacAddress(line);
            if (macAddress == null || (macAddress = macAddress.replaceAll("[:|-]", "")).equalsIgnoreCase("000000000000")) continue;
            macAddressList.add(macAddress);
        }
        if (macAddressList.isEmpty()) {
            throw new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        }
        return macAddressList;
    }

    private static final String getMacAddress(String line) {
        log.info((Object)(">>getMacAddress(" + line + ")"));
        String regex = "[0-9|A-F|a-f]{2}([-|:][0-9|A-F|a-f]{2}){5}";
        Pattern p = Pattern.compile(regex);
        Matcher match = p.matcher(line);
        if (match.find()) {
            return match.group();
        }
        return null;
    }

    private static final String windowsRunIpConfigCommand() throws IOException {
        int c;
        log.info((Object)">>windowsRunIpConfigCommand()");
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("ipconfig /all");
        }
        catch (IOException e) {
            log.info((Object)"\u7cfb\u7edf\u6267\u884c[ipconfig /all]\u9519\u8bef");
            log.info((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String linuxRunIfConfigCommand() throws IOException {
        int c;
        log.info((Object)">>linuxRunIfConfigCommand()");
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("ifconfig");
        }
        catch (IOException e) {
            log.info((Object)"\u7cfb\u7edf\u6267\u884c[ifconfig]\u9519\u8bef");
            log.info((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String aixRunNetstatCommand() throws IOException {
        int c;
        log.info((Object)">>aixRunNetstatCommand");
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("netstat -v");
        }
        catch (IOException e) {
            log.info((Object)"\u7cfb\u7edf\u6267\u884c[netstat -v]\u9519\u8bef");
            log.info((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    public static void main(String[] args) throws IOException, ParseException {
        System.out.println(NetworkInfo.parseMacAddress(NetworkInfo.windowsRunIpConfigCommand()));
    }
}

