/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cert;

import cn.tca.TopBasicCrypto.asn1.nist.NISTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x9.X9ObjectIdentifiers;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.cert.KeyPairType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SignatureType {
    public static final SignatureType MD2withRSA = new SignatureType("MD2withRSA", PKCSObjectIdentifiers.md2WithRSAEncryption.getId());
    public static final SignatureType MD5withRSA = new SignatureType("MD5withRSA", PKCSObjectIdentifiers.md5WithRSAEncryption.getId());
    public static final SignatureType SHA1withRSA = new SignatureType("SHA1withRSA", PKCSObjectIdentifiers.sha1WithRSAEncryption.getId());
    public static final SignatureType SHA224withRSA = new SignatureType("SHA224withRSA", PKCSObjectIdentifiers.sha224WithRSAEncryption.getId());
    public static final SignatureType SHA256withRSA = new SignatureType("SHA256withRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption.getId());
    public static final SignatureType SHA384withRSA = new SignatureType("SHA384withRSA", PKCSObjectIdentifiers.sha384WithRSAEncryption.getId());
    public static final SignatureType SHA512withRSA = new SignatureType("SHA512withRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption.getId());
    public static final SignatureType RIPEMD128withRSA = new SignatureType("RIPEMD128withRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128.getId());
    public static final SignatureType RIPEMD160withRSA = new SignatureType("RIPEMD160withRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160.getId());
    public static final SignatureType RIPEMD256withRSA = new SignatureType("RIPEMD256withRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256.getId());
    public static final SignatureType SHA1withDSA = new SignatureType("SHA1withDSA", X9ObjectIdentifiers.id_dsa_with_sha1.getId());
    public static final SignatureType SHA224withDSA = new SignatureType("SHA224withDSA", NISTObjectIdentifiers.dsa_with_sha224.getId());
    public static final SignatureType SHA256withDSA = new SignatureType("SHA256withDSA", NISTObjectIdentifiers.dsa_with_sha256.getId());
    public static final SignatureType SHA384withDSA = new SignatureType("SHA384withDSA", NISTObjectIdentifiers.dsa_with_sha384.getId());
    public static final SignatureType SHA512withDSA = new SignatureType("SHA512withDSA", NISTObjectIdentifiers.dsa_with_sha512.getId());
    public static final SignatureType SHA1withECDSA = new SignatureType("SHA1withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA1.getId());
    public static final SignatureType SHA224withECDSA = new SignatureType("SHA224withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA224.getId());
    public static final SignatureType SHA256withECDSA = new SignatureType("SHA256withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256.getId());
    public static final SignatureType SHA384withECDSA = new SignatureType("SHA384withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384.getId());
    public static final SignatureType SHA512withECDSA = new SignatureType("SHA512withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512.getId());
    public static final SignatureType SM3withSM2 = new SignatureType("SM3withSM2", AlgorithmId.SM3withSM2_oid.toString());
    private static final Map OID_MAP;
    private static final Map KEYPAIR_MAP;
    private final String oid;
    private final String name;

    private SignatureType(String name, String oid) {
        this.name = name;
        this.oid = oid;
    }

    public static Collection valuesFor(KeyPairType keyPairType) {
        Set values = (Set)KEYPAIR_MAP.get(keyPairType);
        if (values == null) {
            values = Collections.emptySet();
        }
        return values;
    }

    public static SignatureType defaultFor(KeyPairType keyPairType) {
        switch (keyPairType.value) {
            case 1: {
                return SHA1withRSA;
            }
            case 2: {
                return SHA1withDSA;
            }
            case 3: {
                return SHA1withECDSA;
            }
            case 4: {
                return SM3withSM2;
            }
        }
        return null;
    }

    public static SignatureType valueOfOid(String oid) {
        return (SignatureType)OID_MAP.get(oid);
    }

    public static String toString(String oid) {
        SignatureType type = SignatureType.valueOfOid(oid);
        if (type != null) {
            return type.toString();
        }
        return oid;
    }

    public String name() {
        return this.name;
    }

    static {
        HashMap<String, SignatureType> oidMap = new HashMap<String, SignatureType>();
        oidMap.put(SignatureType.MD2withRSA.oid, MD2withRSA);
        oidMap.put(SignatureType.MD5withRSA.oid, MD5withRSA);
        oidMap.put(SignatureType.SHA1withRSA.oid, SHA1withRSA);
        oidMap.put(SignatureType.SHA224withRSA.oid, SHA224withRSA);
        oidMap.put(SignatureType.SHA256withRSA.oid, SHA256withRSA);
        oidMap.put(SignatureType.SHA384withRSA.oid, SHA384withRSA);
        oidMap.put(SignatureType.SHA512withRSA.oid, SHA512withRSA);
        oidMap.put(SignatureType.RIPEMD128withRSA.oid, RIPEMD128withRSA);
        oidMap.put(SignatureType.RIPEMD160withRSA.oid, RIPEMD160withRSA);
        oidMap.put(SignatureType.RIPEMD256withRSA.oid, RIPEMD256withRSA);
        oidMap.put(SignatureType.SHA1withDSA.oid, SHA1withDSA);
        oidMap.put(SignatureType.SHA224withDSA.oid, SHA224withDSA);
        oidMap.put(SignatureType.SHA256withDSA.oid, SHA256withDSA);
        oidMap.put(SignatureType.SHA384withDSA.oid, SHA384withDSA);
        oidMap.put(SignatureType.SHA512withDSA.oid, SHA512withDSA);
        oidMap.put(SignatureType.SHA1withECDSA.oid, SHA1withECDSA);
        oidMap.put(SignatureType.SHA224withECDSA.oid, SHA224withECDSA);
        oidMap.put(SignatureType.SHA256withECDSA.oid, SHA256withECDSA);
        oidMap.put(SignatureType.SHA384withECDSA.oid, SHA384withECDSA);
        oidMap.put(SignatureType.SHA512withECDSA.oid, SHA512withECDSA);
        oidMap.put(SignatureType.SM3withSM2.oid, SM3withSM2);
        OID_MAP = Collections.unmodifiableMap(oidMap);
        HashMap kpMap = new HashMap();
        LinkedHashSet<SignatureType> dsaSet = new LinkedHashSet<SignatureType>();
        dsaSet.add(SHA1withDSA);
        dsaSet.add(SHA224withDSA);
        dsaSet.add(SHA256withDSA);
        kpMap.put(KeyPairType.DSA, Collections.unmodifiableSet(dsaSet));
        LinkedHashSet<SignatureType> rsaSet = new LinkedHashSet<SignatureType>();
        rsaSet.add(MD2withRSA);
        rsaSet.add(MD5withRSA);
        rsaSet.add(SHA1withRSA);
        rsaSet.add(SHA224withRSA);
        rsaSet.add(SHA256withRSA);
        rsaSet.add(SHA384withRSA);
        rsaSet.add(SHA512withRSA);
        rsaSet.add(RIPEMD128withRSA);
        rsaSet.add(RIPEMD160withRSA);
        rsaSet.add(RIPEMD256withRSA);
        kpMap.put(KeyPairType.RSA, rsaSet);
        LinkedHashSet<SignatureType> ecdsaSet = new LinkedHashSet<SignatureType>();
        ecdsaSet.add(SHA1withECDSA);
        ecdsaSet.add(SHA224withECDSA);
        ecdsaSet.add(SHA256withECDSA);
        ecdsaSet.add(SHA384withECDSA);
        ecdsaSet.add(SHA512withECDSA);
        kpMap.put(KeyPairType.ECDSA, ecdsaSet);
        LinkedHashSet<SignatureType> sm2Set = new LinkedHashSet<SignatureType>();
        sm2Set.add(SM3withSM2);
        kpMap.put(KeyPairType.SM2, sm2Set);
        KEYPAIR_MAP = Collections.unmodifiableMap(kpMap);
    }
}

