/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cert.util;

import cn.tca.TopBasicCrypto.crypto.params.AsymmetricKeyParameter;
import cn.tca.TopBasicCrypto.crypto.params.DHKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.DSAKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.RSAKeyParameters;
import com.itrus.cert.KeyPairType;
import com.itrus.cryptorole.CryptoException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import java.text.MessageFormat;
import javax.crypto.interfaces.DHKey;

public final class KeyPairUtils {
    private KeyPairUtils() {
    }

    public static KeyPair generateKeyPair(KeyPairType keyPairType, int iKeySize) throws CryptoException {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(keyPairType.name());
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            keyPairGen.initialize(iKeySize, rand);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            return keyPair;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptoException(MessageFormat.format("Could not generate " + keyPairType.name() + " key pair.", keyPairType), ex);
        }
        catch (InvalidParameterException ex) {
            throw new CryptoException(MessageFormat.format("Invalid parameter for a '" + iKeySize + "' key pair.", keyPairType), ex);
        }
    }

    public static int getKeyLength(PublicKey pubKey) throws CryptoException {
        if (pubKey instanceof RSAKey) {
            return ((RSAKey)((Object)pubKey)).getModulus().bitLength();
        }
        if (pubKey instanceof DSAKey) {
            return ((DSAKey)((Object)pubKey)).getParams().getP().bitLength();
        }
        if (pubKey instanceof DHKey) {
            return ((DHKey)((Object)pubKey)).getParams().getP().bitLength();
        }
        throw new CryptoException("Could not get public key size.");
    }

    public static int getKeyLength(AsymmetricKeyParameter keyParams) throws CryptoException {
        if (keyParams instanceof RSAKeyParameters) {
            return ((RSAKeyParameters)keyParams).getModulus().bitLength();
        }
        if (keyParams instanceof DSAKeyParameters) {
            return ((DSAKeyParameters)keyParams).getParameters().getP().bitLength();
        }
        if (keyParams instanceof DHKeyParameters) {
            return ((DHKeyParameters)keyParams).getParameters().getP().bitLength();
        }
        throw new CryptoException("Could not get public key size.");
    }
}

