/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cms.jcajce;

import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.cms.KeyTransRecipientInfo;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.RecipientInfoGenerator;
import cn.tca.TopBasicCrypto.operator.GenericKey;
import cn.topca.security.sm.CipherAgent;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.util.CertUtils;
import java.security.Key;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.crypto.spec.SecretKeySpec;

public class SM2RecipientInfoGenerator
implements RecipientInfoGenerator {
    private X509Certificate cert;

    public SM2RecipientInfoGenerator(X509Certificate x509certificate) {
        this.cert = x509certificate;
    }

    @Override
    public RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] encKeyBytes;
        IssuerAndSerialNumber issuerAndSerialNumber = CertUtils.getIssuerAndSerialNumber(this.cert);
        RecipientIdentifier recipientidentifier = new RecipientIdentifier(issuerAndSerialNumber);
        byte[] keyBytes = this.getKey(genericKey).getEncoded();
        try {
            CipherAgent cipher = CipherAgent.getInstance("SM2");
            cipher.init(1, this.cert);
            encKeyBytes = cipher.doFinal(keyBytes);
        }
        catch (Exception e) {
            throw new CMSException(e.getMessage(), e);
        }
        return new RecipientInfo(new KeyTransRecipientInfo(recipientidentifier, new AlgorithmIdentifier(new DERObjectIdentifier(AlgorithmId.SM2_oid.toString()), null), new DEROctetString(encKeyBytes)));
    }

    private Key getKey(GenericKey generickey) {
        if (generickey.getRepresentation() instanceof Key) {
            return (Key)generickey.getRepresentation();
        }
        if (generickey.getRepresentation() instanceof byte[]) {
            return new SecretKeySpec((byte[])generickey.getRepresentation(), "ENC");
        }
        throw new IllegalArgumentException("unknown generic key type");
    }

    static {
        if (Security.getProperty("TopSM") == null) {
            Security.addProvider(new TopSMProvider());
        }
    }
}

