/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cryptorole;

import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.NotSupportException;
import com.itrus.cryptorole.SignatureVerifyException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public abstract class Recipient {
    protected PrivateKey keyOfDecryptor;
    protected X509Certificate certOfDecryptor;
    protected String signAlgorithm = "SHA1withRSA";
    protected String notSupportMessage = "\u60a8\u8c03\u7528\u4e86\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff0c" + this.getClass().getName() + "\u4e2d\u5c1a\u672a\u91cd\u8f7d\u3002";
    protected String notInitializeKeyMessage = "\u672a\u6307\u5b9a\u63a5\u6536\u8005\uff08\u89e3\u5bc6\u8bc1\u4e66\uff09\uff0c\u8bf7\u5148\u8c03\u7528initCertWithKey\u65b9\u6cd5\u3002";

    public void initCertWithKey(String keyStoreFileName, char[] keyStorePassword, String keyAlias, char[] keyPassword) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void initCertWithKey(String pfxFileName, char[] keyPassword) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void initCertWithKey(String pemCertFileName, String pemKeyFileName, char[] keyPassword) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void initCertWithKey(String issuerDN, String serialNumber) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public X509Certificate getCertOfRecipent() {
        return this.certOfDecryptor;
    }

    public void setSignAlgorithm(String algorithmName) {
        this.signAlgorithm = algorithmName;
    }

    public boolean doVerify(byte[] originalMessage, byte[] encryptedDigest, X509Certificate signer, String signAlgorithm) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public X509Certificate verifySignature(byte[] originalMessage, byte[] signedData) throws NotSupportException, CryptoException, SignatureVerifyException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public X509Certificate verifySignatureIncludeOriginal(byte[] signedDataIncludeOriginal) throws NotSupportException, CryptoException, SignatureVerifyException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public byte[] decryptMessage(byte[] encryptedData) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public byte[] decryptMessageEx(byte[] encryptedData) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void decryptFile(String encryptedFileName, String destinationFileName) throws CryptoException, IOException, NotSupportException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void decryptFileEx(String encryptedFileName, String destinationFileName) throws CryptoException, NotSupportException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public byte[] decryptSignAndEnvelopMessage(byte[] signAndEnvelopData) throws CryptoException, NotSupportException {
        throw new NotSupportException(this.notSupportMessage);
    }
}

