/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.x509.X509CertificateStructure;
import cn.tca.TopBasicCrypto.jce.provider.X509CertificateObject;
import cn.tca.TopBasicCrypto.util.encoders.Base64;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.util.CertUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class X509Certificate
extends X509CertificateObject {
    private java.security.cert.X509Certificate cert;
    public static String AccountHashOID;
    protected static String certAttrName;
    protected static String _certAttrName;

    public X509Certificate(X509CertificateStructure x509) throws CertificateParsingException {
        super(x509);
        try {
            this.cert = (java.security.cert.X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(x509.getDEREncoded()));
        }
        catch (CertificateException e) {
            throw new CertificateParsingException(e);
        }
    }

    public X509Certificate(ASN1Sequence as) throws CertificateParsingException {
        this(X509CertificateStructure.getInstance(as));
    }

    @Override
    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public String getHexSerialNumber() {
        return CertUtils.getIEValidSerialNumber(this.getSerialNumber().toString(16));
    }

    public boolean isOnValidPeriod() {
        Date notBefore = this.getNotBefore();
        Date notAfter = this.getNotAfter();
        Date now = new Date();
        return !now.before(notBefore) && !now.after(notAfter);
    }

    public static X509Certificate getInstanceFromFile(String certFileName) throws FileNotFoundException, CertificateException {
        FileInputStream fis = new FileInputStream(certFileName);
        return X509Certificate.engineGenerateCertificate(fis);
    }

    public static X509Certificate getInstanceFromHttpsClient(HttpServletRequest request) throws CertificateException {
        if (request.getAttribute(certAttrName) != null) {
            java.security.cert.X509Certificate cert = ((java.security.cert.X509Certificate[])request.getAttribute(certAttrName))[0];
            return X509Certificate.getInstance(cert.getEncoded());
        }
        if (request.getHeader(_certAttrName) != null) {
            String certPem = request.getHeader(_certAttrName);
            try {
                certPem = certPem.replaceAll("\t", "\n");
                X509Certificate cert = X509Certificate.readPEMCertificate(new ByteArrayInputStream(certPem.getBytes()));
                return cert;
            }
            catch (IOException e) {
                throw new CertificateException(e.toString());
            }
        }
        return null;
    }

    public static X509Certificate getInstance(java.security.cert.X509Certificate cert) throws CertificateEncodingException, CertificateException {
        return X509Certificate.getInstance(cert.getEncoded());
    }

    public static X509Certificate getInstance(String pemCertString) throws CertificateException {
        ASN1InputStream in = new ASN1InputStream(pemCertString.getBytes());
        return X509Certificate.engineGenerateCertificate(in);
    }

    public static X509Certificate getInstance(byte[] derCertEncoded) throws CertificateException {
        ASN1InputStream in = new ASN1InputStream(derCertEncoded);
        return X509Certificate.engineGenerateCertificate(in);
    }

    public static X509Certificate getInstance(InputStream in) throws CertificateException {
        return X509Certificate.engineGenerateCertificate(in);
    }

    public String getICASubjectDNString() {
        return this.getSubjectDNString().replaceFirst("E=", "emailAddress=");
    }

    public String getICAIssuerDNString() {
        return this.getIssuerDNString().replaceFirst("E=", "emailAddress=");
    }

    public String getSubjectDNString() {
        return CertUtils.getX509NameString(this.getSubjectX500Principal());
    }

    public String getIssuerDNString() {
        return CertUtils.getX509NameString(this.getIssuerX500Principal());
    }

    public String getICASerialNumber() {
        return CertUtils.getICAValidSerialNumber(this.getSerialNumber().toString(16));
    }

    public boolean verify(X509Certificate cACert) {
        try {
            PublicKey publicKey = cACert.getPublicKey();
            if ("SM2".equalsIgnoreCase(publicKey.getAlgorithm())) {
                if (AlgorithmId.SM3withSM2_oid.toString().equals(this.getSigAlgOID())) {
                    Signature signature = Signature.getInstance("SM3withSM2");
                    signature.initVerify(publicKey);
                    signature.update(this.getTBSCertificate());
                    return signature.verify(this.getSignature());
                }
                return false;
            }
            this.verify(publicKey);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getCRLDistributionPointURL() {
        try {
            return CertUtils.getCRLDistributionPointURL(this);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return CertUtils.getIssuerAndSerialNumber(this);
    }

    public String getCertID() {
        return CertUtils.getCertID(this);
    }

    public String getAccountHash() {
        byte[] extValue = CertUtils.getExtensionValue(this, AccountHashOID);
        if (extValue != null) {
            return new String(extValue);
        }
        return null;
    }

    private static X509Certificate engineGenerateCertificate(InputStream in) throws CertificateException {
        try {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(10);
            int tag = in.read();
            if (tag == -1) {
                return null;
            }
            if (tag != 48) {
                in.reset();
                return X509Certificate.readPEMCertificate(in);
            }
            if (in.read() == 128) {
                in.reset();
                return X509Certificate.readPKCS7Certificate(in);
            }
            in.reset();
            return X509Certificate.readDERCertificate(in);
        }
        catch (Exception e) {
            throw new CertificateException(e.toString());
        }
    }

    private static String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer l = new StringBuffer();
        while ((c = in.read()) != 10 && c >= 0) {
            if (c == 13) continue;
            l.append((char)c);
        }
        if (l.length() == 0 && c < 0) {
            return null;
        }
        return l.toString();
    }

    private static X509Certificate readDERCertificate(InputStream in) throws IOException, CertificateParsingException {
        ASN1InputStream dIn = new ASN1InputStream(in);
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        return new X509Certificate(X509CertificateStructure.getInstance(seq));
    }

    private static X509Certificate readPKCS7Certificate(InputStream in) throws IOException, CertificateParsingException {
        ASN1InputStream dIn = new ASN1InputStream(in);
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        return new X509Certificate(X509CertificateStructure.getInstance(seq));
    }

    private static X509Certificate readPEMCertificate(InputStream in) throws IOException, CertificateParsingException {
        String line;
        StringBuffer pemBuf = new StringBuffer();
        while ((line = X509Certificate.readLine(in)) != null) {
            if (line.equals("-----BEGIN CERTIFICATE-----") || line.equals("-----BEGIN X509 CERTIFICATE-----") || line.equals("-----END CERTIFICATE-----") || line.equals("-----END X509 CERTIFICATE-----")) continue;
            pemBuf.append(line);
        }
        if (pemBuf.length() != 0) {
            ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode(pemBuf.toString()));
            return X509Certificate.readDERCertificate(bIn);
        }
        return null;
    }

    static {
        Security.addProvider(new TopSMProvider());
        AccountHashOID = "1.2.156.112535.1.2.1";
        certAttrName = "javax.servlet.request.X509Certificate";
        _certAttrName = "sslClientAuthCertPEM";
    }
}

